/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TezBytesWritableSerialization
extends Configured
implements Serialization<Writable> {
    private static final Log LOG = LogFactory.getLog((String)TezBytesWritableSerialization.class.getName());

    public boolean accept(Class<?> c) {
        return BytesWritable.class.isAssignableFrom(c);
    }

    public Serializer<Writable> getSerializer(Class<Writable> c) {
        return new TezBytesWritableSerializer();
    }

    public Deserializer<Writable> getDeserializer(Class<Writable> c) {
        return new TezBytesWritableDeserializer(this.getConf(), c);
    }

    public static class TezBytesWritableSerializer
    extends Configured
    implements Serializer<Writable> {
        private OutputStream dataOut;

        public void open(OutputStream out) {
            this.dataOut = out;
        }

        public void serialize(Writable w) throws IOException {
            BytesWritable writable = (BytesWritable)w;
            this.dataOut.write(writable.getBytes(), 0, writable.getLength());
        }

        public void close() throws IOException {
            this.dataOut.close();
        }
    }

    public static class TezBytesWritableDeserializer
    extends Configured
    implements Deserializer<Writable> {
        private Class<?> writableClass;
        private DataInputBuffer dataIn;

        public TezBytesWritableDeserializer(Configuration conf, Class<?> c) {
            this.setConf(conf);
            this.writableClass = c;
        }

        public void open(InputStream in) {
            this.dataIn = (DataInputBuffer)in;
        }

        public Writable deserialize(Writable w) throws IOException {
            BytesWritable writable = (BytesWritable)w;
            if (w == null) {
                writable = (BytesWritable)ReflectionUtils.newInstance(this.writableClass, (Configuration)this.getConf());
            }
            writable.set(this.dataIn.getData(), this.dataIn.getPosition(), this.dataIn.getLength() - this.dataIn.getPosition());
            return writable;
        }

        public void close() throws IOException {
            this.dataIn.close();
        }
    }
}

