/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.http.BaseHttpConnection;
import org.apache.tez.http.HttpConnection;
import org.apache.tez.http.HttpConnectionParams;
import org.apache.tez.http.SSLFactory;
import org.apache.tez.http.async.netty.AsyncHttpConnection;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.library.api.Partitioner;
import org.apache.tez.runtime.library.common.combine.Combiner;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutput;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutputFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TezRuntimeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TezRuntimeUtils.class);
    private static volatile SSLFactory sslFactory;
    public static final int INVALID_PORT = -1;

    public static String getTaskIdentifier(String vertexName, int taskIndex) {
        return String.format("%s_%06d", vertexName, taskIndex);
    }

    public static String getTaskAttemptIdentifier(int taskIndex, int taskAttemptNumber) {
        return String.format("%d_%d", taskIndex, taskAttemptNumber);
    }

    public static String getTaskAttemptIdentifier(String vertexName, int taskIndex, int taskAttemptNumber) {
        return String.format("%s_%06d_%02d", vertexName, taskIndex, taskAttemptNumber);
    }

    public static Combiner instantiateCombiner(Configuration conf, TaskContext taskContext) throws IOException {
        Class clazz;
        String className = conf.get("tez.runtime.combiner.class");
        if (className == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using Combiner class: " + className);
        }
        try {
            clazz = conf.getClassByName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to load combiner class: " + className);
        }
        Combiner combiner = null;
        try {
            Constructor ctor = clazz.getConstructor(TaskContext.class);
            combiner = (Combiner)ctor.newInstance(taskContext);
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
        return combiner;
    }

    public static Partitioner instantiatePartitioner(Configuration conf) throws IOException {
        Class clazz;
        try {
            clazz = conf.getClassByName(conf.get("tez.runtime.partitioner.class"));
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to find Partitioner class specified in config : " + conf.get("tez.runtime.partitioner.class"), e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using partitioner class: " + clazz.getName());
        }
        Partitioner partitioner = null;
        try {
            Constructor ctorWithConf = clazz.getConstructor(Configuration.class);
            partitioner = (Partitioner)ctorWithConf.newInstance(conf);
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        catch (NoSuchMethodException e) {
            try {
                partitioner = (Partitioner)clazz.newInstance();
            }
            catch (InstantiationException e1) {
                throw new IOException(e1);
            }
            catch (IllegalAccessException e1) {
                throw new IOException(e1);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
        return partitioner;
    }

    public static TezTaskOutput instantiateTaskOutputManager(Configuration conf, OutputContext outputContext) {
        Class clazz = conf.getClass("tez.runtime.task.local.output.manager", TezTaskOutputFiles.class);
        try {
            Constructor ctor = clazz.getConstructor(Configuration.class, String.class, Integer.TYPE);
            ctor.setAccessible(true);
            TezTaskOutput instance = (TezTaskOutput)ctor.newInstance(conf, outputContext.getUniqueIdentifier(), outputContext.getDagIdentifier());
            return instance;
        }
        catch (Exception e) {
            throw new TezUncheckedException("Unable to instantiate configured TezOutputFileManager: " + conf.get("tez.runtime.task.local.output.manager", TezTaskOutputFiles.class.getName()), (Throwable)e);
        }
    }

    public static URL constructBaseURIForShuffleHandlerDagComplete(String host, int port, String appId, int dagIdentifier, boolean sslShuffle) throws MalformedURLException {
        String http_protocol = sslShuffle ? "https://" : "http://";
        StringBuilder sb = new StringBuilder(http_protocol);
        sb.append(host);
        sb.append(":");
        sb.append(port);
        sb.append("/");
        sb.append("mapOutput?dagAction=delete");
        sb.append("&job=");
        sb.append(appId.replace("application", "job"));
        sb.append("&dag=");
        sb.append(String.valueOf(dagIdentifier));
        return new URL(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpConnectionParams getHttpConnectionParams(Configuration conf) {
        boolean sslShuffle;
        int connectionTimeout = conf.getInt("tez.runtime.shuffle.connect.timeout", 180000);
        int readTimeout = conf.getInt("tez.runtime.shuffle.read.timeout", 180000);
        int bufferSize = conf.getInt("tez.runtime.shuffle.buffersize", 8192);
        boolean keepAlive = conf.getBoolean("tez.runtime.shuffle.keep-alive.enabled", false);
        int keepAliveMaxConnections = conf.getInt("tez.runtime.shuffle.keep-alive.max.connections", 20);
        if (keepAlive) {
            System.setProperty("sun.net.http.errorstream.enableBuffering", "true");
            System.setProperty("http.maxConnections", String.valueOf(keepAliveMaxConnections));
        }
        if (!(sslShuffle = conf.getBoolean("tez.runtime.shuffle.ssl.enable", false))) return new HttpConnectionParams(keepAlive, keepAliveMaxConnections, connectionTimeout, readTimeout, bufferSize, sslShuffle, sslFactory);
        if (sslFactory != null) return new HttpConnectionParams(keepAlive, keepAliveMaxConnections, connectionTimeout, readTimeout, bufferSize, sslShuffle, sslFactory);
        Class<HttpConnectionParams> clazz = HttpConnectionParams.class;
        synchronized (HttpConnectionParams.class) {
            if (sslFactory != null) {
                if (sslFactory.getKeystoresFactory().getTrustManagers() != null) return new HttpConnectionParams(keepAlive, keepAliveMaxConnections, connectionTimeout, readTimeout, bufferSize, sslShuffle, sslFactory);
            }
            sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
            try {
                sslFactory.init();
            }
            catch (Exception ex) {
                sslFactory.destroy();
                sslFactory = null;
                throw new RuntimeException(ex);
            }
            return new HttpConnectionParams(keepAlive, keepAliveMaxConnections, connectionTimeout, readTimeout, bufferSize, sslShuffle, sslFactory);
        }
    }

    public static BaseHttpConnection getHttpConnection(boolean asyncHttp, URL url, HttpConnectionParams params, String logIdentifier, JobTokenSecretManager jobTokenSecretManager) throws IOException {
        if (asyncHttp) {
            return new AsyncHttpConnection(url, params, logIdentifier, jobTokenSecretManager);
        }
        return new HttpConnection(url, params, logIdentifier, jobTokenSecretManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deserializeShuffleProviderMetaData(ByteBuffer meta) throws IOException {
        try (DataInputByteBuffer in = new DataInputByteBuffer();){
            int port;
            in.reset(new ByteBuffer[]{meta});
            int n = port = in.readInt();
            return n;
        }
    }

    public static String getBufferSizeProperty(CompressionCodec codec) {
        return TezRuntimeUtils.getBufferSizeProperty(codec.getClass().getName());
    }

    public static String getBufferSizeProperty(String className) {
        switch (className) {
            case "org.apache.hadoop.io.compress.DefaultCodec": {
                return "io.file.buffer.size";
            }
            case "org.apache.hadoop.io.compress.SnappyCodec": {
                return "io.compression.codec.snappy.buffersize";
            }
            case "org.apache.hadoop.io.compress.ZStandardCodec": {
                return "io.compression.codec.zstd.buffersize";
            }
            case "org.apache.hadoop.io.compress.LzoCodec": {
                return "io.compression.codec.lzo.buffersize";
            }
            case "com.hadoop.compression.lzo.LzoCodec": {
                return "io.compression.codec.lzo.buffersize";
            }
            case "org.apache.hadoop.io.compress.Lz4Codec": {
                return "io.compression.codec.lz4.buffersize";
            }
        }
        return null;
    }
}

