/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.PreWarmVertex;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.examples.OrderedWordCount;

public class SimpleSessionExample
extends Configured
implements Tool {
    private static final String enablePrewarmConfig = "simplesessionexample.prewarm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String[] inputPaths, String[] outputPaths, Configuration conf, int numPartitions) throws Exception {
        TezConfiguration tezConf = conf != null ? new TezConfiguration(conf) : new TezConfiguration();
        TezClient tezClient = TezClient.create((String)"SimpleSessionExample", (TezConfiguration)tezConf, (boolean)true);
        tezClient.start();
        if (tezConf.getBoolean(enablePrewarmConfig, false)) {
            tezConf.setInt("tez.am.session.min.held-containers", numPartitions);
            tezClient.preWarm(PreWarmVertex.createConfigBuilder((Configuration)tezConf).build());
        }
        try {
            for (int i = 0; i < inputPaths.length; ++i) {
                DAG dag = OrderedWordCount.createDAG(tezConf, inputPaths[i], outputPaths[i], numPartitions, "DAG-Iteration-" + i);
                tezClient.waitTillReady();
                System.out.println("Running dag number " + i);
                DAGClient dagClient = tezClient.submitDAG(dag);
                DAGStatus dagStatus = dagClient.waitForCompletion();
                if (dagStatus.getState() == DAGStatus.State.SUCCEEDED) continue;
                System.out.println("Iteration " + i + " failed with diagnostics: " + dagStatus.getDiagnostics());
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            tezClient.stop();
        }
    }

    private static void printUsage() {
        System.err.println("Usage:  simplesessionexample <in1,in2> <out1, out2> [numPartitions]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
    }

    public int run(String[] args) throws Exception {
        String[] outputPaths;
        System.out.println("Running SimpleSessionExample");
        Configuration conf = this.getConf();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 2 || otherArgs.length > 3) {
            SimpleSessionExample.printUsage();
            return 2;
        }
        String[] inputPaths = otherArgs[0].split(",");
        if (inputPaths.length != (outputPaths = otherArgs[1].split(",")).length) {
            System.err.println("Inputs and outputs must be equal in number");
            return 3;
        }
        SimpleSessionExample job = new SimpleSessionExample();
        if (job.run(inputPaths, outputPaths, conf, otherArgs.length == 3 ? Integer.parseInt(otherArgs[2]) : 1)) {
            return 0;
        }
        return 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new SimpleSessionExample(), (String[])args);
        System.exit(res);
    }
}

