/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.examples.WordCount;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.processor.SimpleMRProcessor;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.partitioner.HashPartitioner;
import org.apache.tez.runtime.library.processor.SimpleProcessor;

public class OrderedWordCount
extends Configured
implements Tool {
    private static String INPUT = WordCount.INPUT;
    private static String OUTPUT = WordCount.OUTPUT;
    private static String TOKENIZER = WordCount.TOKENIZER;
    private static String SUMMATION = WordCount.SUMMATION;
    private static String SORTER = "Sorter";

    public static DAG createDAG(TezConfiguration tezConf, String inputPath, String outputPath, int numPartitions, String dagName) throws IOException {
        DataSourceDescriptor dataSource = MRInput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextInputFormat.class, (String)inputPath).build();
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextOutputFormat.class, (String)outputPath).build();
        Vertex tokenizerVertex = Vertex.create((String)TOKENIZER, (ProcessorDescriptor)ProcessorDescriptor.create((String)WordCount.TokenProcessor.class.getName()));
        tokenizerVertex.addDataSource(INPUT, dataSource);
        OrderedPartitionedKVEdgeConfig summationEdgeConf = OrderedPartitionedKVEdgeConfig.newBuilder((String)Text.class.getName(), (String)IntWritable.class.getName(), (String)HashPartitioner.class.getName()).build();
        Vertex summationVertex = Vertex.create((String)SUMMATION, (ProcessorDescriptor)ProcessorDescriptor.create((String)SumProcessor.class.getName()), (int)numPartitions);
        OrderedPartitionedKVEdgeConfig sorterEdgeConf = OrderedPartitionedKVEdgeConfig.newBuilder((String)IntWritable.class.getName(), (String)Text.class.getName(), (String)HashPartitioner.class.getName()).build();
        Vertex sorterVertex = Vertex.create((String)SORTER, (ProcessorDescriptor)ProcessorDescriptor.create((String)NoOpSorter.class.getName()), (int)1);
        sorterVertex.addDataSink(OUTPUT, dataSink);
        DAG dag = DAG.create((String)dagName);
        dag.addVertex(tokenizerVertex).addVertex(summationVertex).addVertex(sorterVertex).addEdge(Edge.create((Vertex)tokenizerVertex, (Vertex)summationVertex, (EdgeProperty)summationEdgeConf.createDefaultEdgeProperty())).addEdge(Edge.create((Vertex)summationVertex, (Vertex)sorterVertex, (EdgeProperty)sorterEdgeConf.createDefaultEdgeProperty()));
        return dag;
    }

    private static void printUsage() {
        System.err.println("Usage:  orderedwordcount in out [numPartitions]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String inputPath, String outputPath, Configuration conf, int numPartitions) throws Exception {
        System.out.println("Running OrderedWordCount");
        TezConfiguration tezConf = conf != null ? new TezConfiguration(conf) : new TezConfiguration();
        UserGroupInformation.setConfiguration((Configuration)tezConf);
        TezClient tezClient = TezClient.create((String)"OrderedWordCount", (TezConfiguration)tezConf);
        tezClient.start();
        try {
            DAG dag = OrderedWordCount.createDAG(tezConf, inputPath, outputPath, numPartitions, "OrderedWordCount");
            tezClient.waitTillReady();
            DAGClient dagClient = tezClient.submitDAG(dag);
            DAGStatus dagStatus = dagClient.waitForCompletionWithStatusUpdates(null);
            if (dagStatus.getState() != DAGStatus.State.SUCCEEDED) {
                System.out.println("OrderedWordCount failed with diagnostics: " + dagStatus.getDiagnostics());
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            tezClient.stop();
        }
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 2 || otherArgs.length > 3) {
            OrderedWordCount.printUsage();
            return 2;
        }
        OrderedWordCount job = new OrderedWordCount();
        if (job.run(otherArgs[0], otherArgs[1], conf, otherArgs.length == 3 ? Integer.parseInt(otherArgs[2]) : 1)) {
            return 0;
        }
        return 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new OrderedWordCount(), (String[])args);
        System.exit(res);
    }

    public static class NoOpSorter
    extends SimpleMRProcessor {
        public NoOpSorter(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            Preconditions.checkArgument((this.getInputs().size() == 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.getOutputs().size() == 1 ? 1 : 0) != 0);
            KeyValueWriter kvWriter = (KeyValueWriter)((LogicalOutput)this.getOutputs().get(OUTPUT)).getWriter();
            KeyValuesReader kvReader = (KeyValuesReader)((LogicalInput)this.getInputs().get(SUMMATION)).getReader();
            while (kvReader.next()) {
                Object sum = kvReader.getCurrentKey();
                for (Object word : kvReader.getCurrentValues()) {
                    kvWriter.write(word, sum);
                }
            }
        }
    }

    public static class SumProcessor
    extends SimpleProcessor {
        public SumProcessor(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            Preconditions.checkArgument((this.getInputs().size() == 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.getOutputs().size() == 1 ? 1 : 0) != 0);
            KeyValueWriter kvWriter = (KeyValueWriter)((LogicalOutput)this.getOutputs().get(SORTER)).getWriter();
            KeyValuesReader kvReader = (KeyValuesReader)((LogicalInput)this.getInputs().get(TOKENIZER)).getReader();
            while (kvReader.next()) {
                Text word = (Text)kvReader.getCurrentKey();
                int sum = 0;
                for (Object value : kvReader.getCurrentValues()) {
                    sum += ((IntWritable)value).get();
                }
                kvWriter.write((Object)new IntWritable(sum), (Object)word);
            }
        }
    }
}

