/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.impl.ServicePluginInfo;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.utils.TezEventUtils;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.runtime.api.impl.TezEvent;

public class VertexInitializedEvent
implements HistoryEvent {
    private TezVertexID vertexID;
    private String vertexName;
    private long initRequestedTime;
    private long initedTime;
    private int numTasks;
    private String processorName;
    private Map<String, RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> additionalInputs;
    private List<TezEvent> initGeneratedEvents;
    private ServicePluginInfo servicePluginInfo;

    public VertexInitializedEvent() {
    }

    public VertexInitializedEvent(TezVertexID vertexId, String vertexName, long initRequestedTime, long initedTime, int numTasks, String processorName, Map<String, RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> additionalInputs, List<TezEvent> initGeneratedEvents, ServicePluginInfo servicePluginInfo) {
        this.vertexName = vertexName;
        this.vertexID = vertexId;
        this.initRequestedTime = initRequestedTime;
        this.initedTime = initedTime;
        this.numTasks = numTasks;
        this.processorName = processorName;
        this.additionalInputs = additionalInputs;
        this.initGeneratedEvents = initGeneratedEvents;
        this.servicePluginInfo = servicePluginInfo;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_INITIALIZED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.VertexInitializedProto toProto() throws IOException {
        RecoveryProtos.VertexInitializedProto.Builder builder = RecoveryProtos.VertexInitializedProto.newBuilder();
        if (this.additionalInputs != null && !this.additionalInputs.isEmpty()) {
            for (RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor> input : this.additionalInputs.values()) {
                DAGProtos.RootInputLeafOutputProto.Builder inputBuilder = DAGProtos.RootInputLeafOutputProto.newBuilder();
                inputBuilder.setName(input.getName());
                if (input.getControllerDescriptor() != null) {
                    inputBuilder.setControllerDescriptor(DagTypeConverters.convertToDAGPlan((EntityDescriptor)input.getControllerDescriptor()));
                }
                inputBuilder.setIODescriptor(DagTypeConverters.convertToDAGPlan((EntityDescriptor)input.getIODescriptor()));
                builder.addInputs(inputBuilder.build());
            }
        }
        if (this.initGeneratedEvents != null && !this.initGeneratedEvents.isEmpty()) {
            for (TezEvent event : this.initGeneratedEvents) {
                builder.addInitGeneratedEvents(TezEventUtils.toProto(event));
            }
        }
        return builder.setVertexId(this.vertexID.toString()).setVertexName(this.vertexName).setInitRequestedTime(this.initRequestedTime).setInitTime(this.initedTime).setNumTasks(this.numTasks).build();
    }

    public void fromProto(RecoveryProtos.VertexInitializedProto proto) throws IOException {
        int eventCount;
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
        this.vertexName = proto.getVertexName();
        this.initRequestedTime = proto.getInitRequestedTime();
        this.initedTime = proto.getInitTime();
        this.numTasks = proto.getNumTasks();
        if (proto.getInputsCount() > 0) {
            this.additionalInputs = new LinkedHashMap<String, RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>>();
            for (DAGProtos.RootInputLeafOutputProto inputProto : proto.getInputsList()) {
                RootInputLeafOutput input = new RootInputLeafOutput(inputProto.getName(), (EntityDescriptor)DagTypeConverters.convertInputDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)inputProto.getIODescriptor()), inputProto.hasControllerDescriptor() ? DagTypeConverters.convertInputInitializerDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)inputProto.getControllerDescriptor()) : null);
                this.additionalInputs.put(input.getName(), (RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>)input);
            }
        }
        if ((eventCount = proto.getInitGeneratedEventsCount()) > 0) {
            this.initGeneratedEvents = Lists.newArrayListWithCapacity((int)eventCount);
        }
        for (RecoveryProtos.TezEventProto eventProto : proto.getInitGeneratedEventsList()) {
            this.initGeneratedEvents.add(TezEventUtils.fromProto(eventProto));
        }
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.VertexInitializedProto proto = RecoveryProtos.VertexInitializedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", vertexId=" + this.vertexID + ", initRequestedTime=" + this.initRequestedTime + ", initedTime=" + this.initedTime + ", numTasks=" + this.numTasks + ", processorName=" + this.processorName + ", additionalInputsCount=" + (this.additionalInputs != null ? this.additionalInputs.size() : 0) + ", initGeneratedEventsCount=" + (this.initGeneratedEvents != null ? this.initGeneratedEvents.size() : 0) + ", servicePluginInfo=" + (this.servicePluginInfo != null ? this.servicePluginInfo : "null");
    }

    public TezVertexID getVertexID() {
        return this.vertexID;
    }

    public long getInitRequestedTime() {
        return this.initRequestedTime;
    }

    public long getInitedTime() {
        return this.initedTime;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public Map<String, RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> getAdditionalInputs() {
        return this.additionalInputs;
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public String getVertexName() {
        return this.vertexName;
    }

    public List<TezEvent> getInitGeneratedEvents() {
        return this.initGeneratedEvents;
    }

    public ServicePluginInfo getServicePluginInfo() {
        return this.servicePluginInfo;
    }
}

