/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.Utils;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventType;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventUserServiceFatalError;
import org.apache.tez.dag.app.dag.event.DiagnosableEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminated;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminatedBySystem;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminating;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventNodeFailed;
import org.apache.tez.dag.app.rm.AMSchedulerEventDeallocateContainer;
import org.apache.tez.dag.app.rm.ContainerLauncherLaunchRequestEvent;
import org.apache.tez.dag.app.rm.ContainerLauncherStopRequestEvent;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEventAssignTA;
import org.apache.tez.dag.app.rm.container.AMContainerEventCompleted;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunchFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunchRequest;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.app.rm.container.AMContainerHelpers;
import org.apache.tez.dag.app.rm.container.AMContainerState;
import org.apache.tez.dag.app.rm.container.AMContainerTask;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.history.events.ContainerStoppedEvent;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.serviceplugins.api.ContainerEndReason;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMContainerImpl
implements AMContainer {
    private static final Logger LOG = LoggerFactory.getLogger(AMContainerImpl.class);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ContainerId containerId;
    private final Container container;
    private final AppContext appContext;
    private final ContainerHeartbeatHandler containerHeartbeatHandler;
    private final TaskCommunicatorManagerInterface taskCommunicatorManagerInterface;
    protected final EventHandler eventHandler;
    private final ContainerSignatureMatcher signatureMatcher;
    private final int schedulerId;
    private final int launcherId;
    private final int taskCommId;
    private final List<TezTaskAttemptID> completedAttempts = new LinkedList<TezTaskAttemptID>();
    private long idleTimeBetweenTasks = 0L;
    private long lastTaskFinishTime;
    private TezDAGID lastTaskDAGID;
    private boolean nodeFailed = false;
    private TezTaskAttemptID currentAttempt;
    private long currentAttemptAllocationTime;
    private List<TezTaskAttemptID> failedAssignments;
    private boolean inError = false;
    @VisibleForTesting
    Map<String, LocalResource> containerLocalResources;
    @VisibleForTesting
    Map<String, LocalResource> additionalLocalResources;
    private Credentials credentials;
    private boolean credentialsChanged = false;
    private final StateMachine<AMContainerState, AMContainerEventType, AMContainerEvent> stateMachine;
    private static final StateMachineFactory<AMContainerImpl, AMContainerState, AMContainerEventType, AMContainerEvent> stateMachineFactory = new StateMachineFactory((Enum)AMContainerState.ALLOCATED).addTransition((Enum)AMContainerState.ALLOCATED, (Enum)AMContainerState.LAUNCHING, (Enum)AMContainerEventType.C_LAUNCH_REQUEST, (SingleArcTransition)new LaunchRequestTransition()).addTransition((Enum)AMContainerState.ALLOCATED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_ASSIGN_TA, (SingleArcTransition)new AssignTaskAttemptAtAllocatedTransition()).addTransition((Enum)AMContainerState.ALLOCATED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_COMPLETED, (SingleArcTransition)new CompletedAtAllocatedTransition()).addTransition((Enum)AMContainerState.ALLOCATED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_STOP_REQUEST, (SingleArcTransition)new StopRequestAtAllocatedTransition()).addTransition((Enum)AMContainerState.ALLOCATED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedAtAllocatedTransition()).addTransition((Enum)AMContainerState.ALLOCATED, (Enum)AMContainerState.COMPLETED, EnumSet.of(AMContainerEventType.C_LAUNCHED, new AMContainerEventType[]{AMContainerEventType.C_LAUNCH_FAILED, AMContainerEventType.C_TA_SUCCEEDED, AMContainerEventType.C_NM_STOP_SENT, AMContainerEventType.C_NM_STOP_FAILED, AMContainerEventType.C_TIMED_OUT}), (SingleArcTransition)new ErrorTransition()).addTransition((Enum)AMContainerState.LAUNCHING, EnumSet.of(AMContainerState.LAUNCHING, AMContainerState.STOP_REQUESTED), (Enum)AMContainerEventType.C_ASSIGN_TA, (MultipleArcTransition)new AssignTaskAttemptTransition()).addTransition((Enum)AMContainerState.LAUNCHING, EnumSet.of(AMContainerState.IDLE, AMContainerState.RUNNING), (Enum)AMContainerEventType.C_LAUNCHED, (MultipleArcTransition)new LaunchedTransition()).addTransition((Enum)AMContainerState.LAUNCHING, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_LAUNCH_FAILED, (SingleArcTransition)new LaunchFailedTransition()).addTransition((Enum)AMContainerState.LAUNCHING, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_COMPLETED, (SingleArcTransition)new CompletedAtLaunchingTransition()).addTransition((Enum)AMContainerState.LAUNCHING, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_STOP_REQUEST, (SingleArcTransition)new StopRequestAtLaunchingTransition()).addTransition((Enum)AMContainerState.LAUNCHING, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedAtLaunchingTransition()).addTransition((Enum)AMContainerState.LAUNCHING, (Enum)AMContainerState.STOP_REQUESTED, EnumSet.of(AMContainerEventType.C_LAUNCH_REQUEST, AMContainerEventType.C_TA_SUCCEEDED, AMContainerEventType.C_NM_STOP_SENT, AMContainerEventType.C_NM_STOP_FAILED, AMContainerEventType.C_TIMED_OUT), (SingleArcTransition)new ErrorAtLaunchingTransition()).addTransition((Enum)AMContainerState.IDLE, EnumSet.of(AMContainerState.RUNNING, AMContainerState.STOP_REQUESTED), (Enum)AMContainerEventType.C_ASSIGN_TA, (MultipleArcTransition)new AssignTaskAttemptTransition()).addTransition((Enum)AMContainerState.IDLE, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_COMPLETED, (SingleArcTransition)new CompletedAtIdleTransition()).addTransition((Enum)AMContainerState.IDLE, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_STOP_REQUEST, (SingleArcTransition)new StopRequestAtIdleTransition()).addTransition((Enum)AMContainerState.IDLE, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_TIMED_OUT, (SingleArcTransition)new TimedOutAtIdleTransition()).addTransition((Enum)AMContainerState.IDLE, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedAtIdleTransition()).addTransition((Enum)AMContainerState.IDLE, (Enum)AMContainerState.STOP_REQUESTED, EnumSet.of(AMContainerEventType.C_LAUNCH_REQUEST, new AMContainerEventType[]{AMContainerEventType.C_LAUNCHED, AMContainerEventType.C_LAUNCH_FAILED, AMContainerEventType.C_TA_SUCCEEDED, AMContainerEventType.C_NM_STOP_SENT, AMContainerEventType.C_NM_STOP_FAILED}), (SingleArcTransition)new ErrorAtIdleTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_ASSIGN_TA, (SingleArcTransition)new AssignTaskAttemptAtRunningTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.IDLE, (Enum)AMContainerEventType.C_TA_SUCCEEDED, (SingleArcTransition)new TASucceededAtRunningTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_COMPLETED, (SingleArcTransition)new CompletedAtRunningTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_STOP_REQUEST, (SingleArcTransition)new StopRequestAtRunningTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_TIMED_OUT, (SingleArcTransition)new TimedOutAtRunningTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedAtRunningTransition()).addTransition((Enum)AMContainerState.RUNNING, (Enum)AMContainerState.STOP_REQUESTED, EnumSet.of(AMContainerEventType.C_LAUNCH_REQUEST, AMContainerEventType.C_LAUNCHED, AMContainerEventType.C_LAUNCH_FAILED, AMContainerEventType.C_NM_STOP_SENT, AMContainerEventType.C_NM_STOP_FAILED), (SingleArcTransition)new ErrorAtRunningTransition()).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_ASSIGN_TA, (SingleArcTransition)new AssignTAAtWindDownTransition()).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_COMPLETED, (SingleArcTransition)new CompletedAtWindDownTransition()).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NM_STOP_SENT).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NM_STOP_FAILED, (SingleArcTransition)new NMStopRequestFailedTransition()).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedAtNMStopRequestedTransition()).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.STOP_REQUESTED, EnumSet.of(AMContainerEventType.C_LAUNCHED, AMContainerEventType.C_LAUNCH_FAILED, AMContainerEventType.C_TA_SUCCEEDED, AMContainerEventType.C_STOP_REQUEST, AMContainerEventType.C_TIMED_OUT)).addTransition((Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerState.STOP_REQUESTED, (Enum)AMContainerEventType.C_LAUNCH_REQUEST, (SingleArcTransition)new ErrorAtNMStopRequestedTransition()).addTransition((Enum)AMContainerState.STOPPING, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_ASSIGN_TA, (SingleArcTransition)new AssignTAAtWindDownTransition()).addTransition((Enum)AMContainerState.STOPPING, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_COMPLETED, (SingleArcTransition)new CompletedAtWindDownTransition()).addTransition((Enum)AMContainerState.STOPPING, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedBaseTransition()).addTransition((Enum)AMContainerState.STOPPING, (Enum)AMContainerState.STOPPING, EnumSet.of(AMContainerEventType.C_LAUNCHED, new AMContainerEventType[]{AMContainerEventType.C_LAUNCH_FAILED, AMContainerEventType.C_TA_SUCCEEDED, AMContainerEventType.C_STOP_REQUEST, AMContainerEventType.C_NM_STOP_SENT, AMContainerEventType.C_NM_STOP_FAILED, AMContainerEventType.C_TIMED_OUT})).addTransition((Enum)AMContainerState.STOPPING, (Enum)AMContainerState.STOPPING, (Enum)AMContainerEventType.C_LAUNCH_REQUEST, (SingleArcTransition)new ErrorAtStoppingTransition()).addTransition((Enum)AMContainerState.COMPLETED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_ASSIGN_TA, (SingleArcTransition)new AssignTAAtCompletedTransition()).addTransition((Enum)AMContainerState.COMPLETED, (Enum)AMContainerState.COMPLETED, (Enum)AMContainerEventType.C_NODE_FAILED, (SingleArcTransition)new NodeFailedBaseTransition()).addTransition((Enum)AMContainerState.COMPLETED, (Enum)AMContainerState.COMPLETED, EnumSet.of(AMContainerEventType.C_LAUNCH_REQUEST, new AMContainerEventType[]{AMContainerEventType.C_LAUNCHED, AMContainerEventType.C_LAUNCH_FAILED, AMContainerEventType.C_TA_SUCCEEDED, AMContainerEventType.C_COMPLETED, AMContainerEventType.C_STOP_REQUEST, AMContainerEventType.C_NM_STOP_SENT, AMContainerEventType.C_NM_STOP_FAILED, AMContainerEventType.C_TIMED_OUT})).installTopology();

    public AMContainerImpl(Container container, ContainerHeartbeatHandler chh, TaskCommunicatorManagerInterface tal, ContainerSignatureMatcher signatureMatcher, AppContext appContext, int schedulerId, int launcherId, int taskCommId) {
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.readLock = rwLock.readLock();
        this.writeLock = rwLock.writeLock();
        this.container = container;
        this.containerId = container.getId();
        this.eventHandler = appContext.getEventHandler();
        this.signatureMatcher = signatureMatcher;
        this.appContext = appContext;
        this.containerHeartbeatHandler = chh;
        this.taskCommunicatorManagerInterface = tal;
        this.failedAssignments = new LinkedList<TezTaskAttemptID>();
        this.schedulerId = schedulerId;
        this.launcherId = launcherId;
        this.taskCommId = taskCommId;
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AMContainerState getState() {
        this.readLock.lock();
        try {
            AMContainerState aMContainerState = (AMContainerState)this.stateMachine.getCurrentState();
            return aMContainerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ContainerId getContainerId() {
        return this.containerId;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TezTaskAttemptID> getAllTaskAttempts() {
        this.readLock.lock();
        try {
            LinkedList<TezTaskAttemptID> allAttempts = new LinkedList<TezTaskAttemptID>();
            allAttempts.addAll(this.completedAttempts);
            allAttempts.addAll(this.failedAssignments);
            if (this.currentAttempt != null) {
                allAttempts.add(this.currentAttempt);
            }
            LinkedList<TezTaskAttemptID> linkedList = allAttempts;
            return linkedList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TezTaskAttemptID getCurrentTaskAttempt() {
        this.readLock.lock();
        try {
            TezTaskAttemptID tezTaskAttemptID = this.currentAttempt;
            return tezTaskAttemptID;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrentTaskAttemptAllocationTime() {
        this.readLock.lock();
        try {
            long l = this.currentAttemptAllocationTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getTaskSchedulerIdentifier() {
        return this.schedulerId;
    }

    @Override
    public int getContainerLauncherIdentifier() {
        return this.launcherId;
    }

    @Override
    public int getTaskCommunicatorIdentifier() {
        return this.taskCommId;
    }

    public boolean isInErrorState() {
        return this.inError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(AMContainerEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing AMContainerEvent " + event.getContainerId() + " of type " + event.getType() + " while in state: " + (Object)((Object)this.getState()) + ". Event: " + (Object)((Object)event));
        }
        this.writeLock.lock();
        try {
            AMContainerState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error("Can't handle event " + event.getType() + " at current state " + (Object)((Object)oldState) + " for ContainerId " + this.containerId, (Throwable)e);
                this.inError = true;
            }
            if (oldState != this.getState() && LOG.isDebugEnabled()) {
                LOG.debug("AMContainer " + this.containerId + " transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState()) + " via event " + event.getType());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void sendEvent(Event<?> event) {
        this.eventHandler.handle(event);
    }

    private void handleExtraTAAssign(AMContainerEventAssignTA event, TezTaskAttemptID currentTaId) {
        this.inError = true;
        String errorMessage = "AMScheduler Error: Multiple simultaneous taskAttempt allocations to: " + this.getContainerId() + ". Attempts: " + currentTaId + ", " + event.getTaskAttemptId() + ". Current state: " + (Object)((Object)this.getState());
        this.maybeSendNodeFailureForFailedAssignment(event.getTaskAttemptId());
        this.sendTerminatingToTaskAttempt(event.getTaskAttemptId(), errorMessage, TaskAttemptTerminationCause.FRAMEWORK_ERROR);
        this.sendTerminatingToTaskAttempt(currentTaId, errorMessage, TaskAttemptTerminationCause.FRAMEWORK_ERROR);
        this.registerFailedAttempt(event.getTaskAttemptId());
        LOG.warn(errorMessage);
        this.logStopped(-1000);
        this.sendStopRequestToNM();
        this.unregisterFromTAListener(ContainerEndReason.FRAMEWORK_ERROR, errorMessage);
        this.unregisterFromContainerListener();
    }

    protected void registerFailedAttempt(TezTaskAttemptID taId) {
        this.failedAssignments.add(taId);
    }

    private void logStopped(int exitStatus) {
        Clock clock = this.appContext.getClock();
        HistoryEventHandler historyHandler = this.appContext.getHistoryHandler();
        ContainerStoppedEvent lEvt = new ContainerStoppedEvent(this.containerId, clock.getTime(), exitStatus, this.appContext.getApplicationAttemptId());
        historyHandler.handle(new DAGHistoryEvent(this.appContext.getCurrentDAGID(), lEvt));
    }

    protected void deAllocate() {
        this.sendEvent((Event<?>)new AMSchedulerEventDeallocateContainer(this.containerId, this.schedulerId));
    }

    protected void sendTerminatedToTaskAttempt(TezTaskAttemptID taId, String message, TaskAttemptTerminationCause errCause) {
        this.sendEvent((Event<?>)new TaskAttemptEventContainerTerminated(this.containerId, taId, message, errCause));
    }

    protected void sendContainerTerminatedBySystemToTaskAttempt(TezTaskAttemptID taId, String message, TaskAttemptTerminationCause errorCause) {
        this.sendEvent((Event<?>)new TaskAttemptEventContainerTerminatedBySystem(this.containerId, taId, message, errorCause));
    }

    protected void sendTerminatingToTaskAttempt(TezTaskAttemptID taId, String message, TaskAttemptTerminationCause errorCause) {
        this.sendEvent((Event<?>)new TaskAttemptEventContainerTerminating(taId, message, errorCause));
    }

    protected void maybeSendNodeFailureForFailedAssignment(TezTaskAttemptID taId) {
        if (this.nodeFailed) {
            this.sendNodeFailureToTA(taId, "Node Failed", TaskAttemptTerminationCause.NODE_FAILED);
        }
    }

    protected void sendNodeFailureToTA(TezTaskAttemptID taId, String message, TaskAttemptTerminationCause errorCause) {
        this.sendEvent((Event<?>)new TaskAttemptEventNodeFailed(taId, message, errorCause));
    }

    protected void sendStartRequestToNM(ContainerLaunchContext clc) {
        this.sendEvent((Event<?>)new ContainerLauncherLaunchRequestEvent(clc, this.container, this.launcherId, this.schedulerId, this.taskCommId));
    }

    protected void sendStopRequestToNM() {
        this.sendEvent((Event<?>)new ContainerLauncherStopRequestEvent(this.containerId, this.container.getNodeId(), this.container.getContainerToken(), this.launcherId, this.schedulerId, this.taskCommId));
    }

    protected void unregisterAttemptFromListener(TezTaskAttemptID attemptId, TaskAttemptEndReason endReason, String diagnostics) {
        this.taskCommunicatorManagerInterface.unregisterTaskAttempt(attemptId, this.taskCommId, endReason, diagnostics);
    }

    protected void registerAttemptWithListener(AMContainerTask amContainerTask) {
        this.taskCommunicatorManagerInterface.registerTaskAttempt(amContainerTask, this.containerId, this.taskCommId);
    }

    protected void registerWithTAListener() {
        this.taskCommunicatorManagerInterface.registerRunningContainer(this.containerId, this.taskCommId);
    }

    protected void unregisterFromTAListener(ContainerEndReason endReason, String diagnostics) {
        this.taskCommunicatorManagerInterface.unregisterRunningContainer(this.containerId, this.taskCommId, endReason, diagnostics);
    }

    protected void registerWithContainerListener() {
        this.containerHeartbeatHandler.register(this.containerId);
    }

    protected void unregisterFromContainerListener() {
        this.containerHeartbeatHandler.unregister(this.containerId);
    }

    protected static class AssignTAAtCompletedTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected AssignTAAtCompletedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.inError = true;
            AMContainerEventAssignTA event = (AMContainerEventAssignTA)cEvent;
            String errorMessage = "AttemptId: " + event.getTaskAttemptId() + " cannot be allocated to container: " + container.getContainerId() + " in COMPLETED state";
            container.maybeSendNodeFailureForFailedAssignment(event.getTaskAttemptId());
            container.sendTerminatedToTaskAttempt(event.getTaskAttemptId(), errorMessage, TaskAttemptTerminationCause.FRAMEWORK_ERROR);
            container.registerFailedAttempt(event.getTaskAttemptId());
        }
    }

    protected static class ErrorBaseTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected ErrorBaseTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.inError = true;
        }
    }

    protected static class ErrorAtStoppingTransition
    extends ErrorBaseTransition {
        protected ErrorAtStoppingTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
        }
    }

    protected static class ErrorAtNMStopRequestedTransition
    extends ErrorBaseTransition {
        protected ErrorAtNMStopRequestedTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
        }
    }

    protected static class NodeFailedAtNMStopRequestedTransition
    extends NodeFailedBaseTransition {
        protected NodeFailedAtNMStopRequestedTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.deAllocate();
        }
    }

    protected static class NMStopRequestFailedTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected NMStopRequestFailedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.deAllocate();
        }
    }

    protected static class CompletedAtWindDownTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected CompletedAtWindDownTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventCompleted event = (AMContainerEventCompleted)cEvent;
            String diag = event.getDiagnostics();
            for (TezTaskAttemptID taId : container.failedAssignments) {
                container.sendTerminatedToTaskAttempt(taId, diag, TaskAttemptTerminationCause.CONTAINER_EXITED);
            }
            if (container.currentAttempt != null) {
                container.sendTerminatedToTaskAttempt(container.currentAttempt, diag, TaskAttemptTerminationCause.CONTAINER_EXITED);
                container.registerFailedAttempt(container.currentAttempt);
                container.currentAttempt = null;
            }
            if (diag != null && !diag.equals("")) {
                LOG.info("Container " + container.getContainerId() + " exited with diagnostics set to " + diag);
            }
            container.containerLocalResources = null;
            container.additionalLocalResources = null;
        }
    }

    protected static class AssignTAAtWindDownTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected AssignTAAtWindDownTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventAssignTA event = (AMContainerEventAssignTA)cEvent;
            container.inError = true;
            String errorMessage = "AttemptId: " + event.getTaskAttemptId() + " cannot be allocated to container: " + container.getContainerId() + " in " + (Object)((Object)container.getState()) + " state";
            container.maybeSendNodeFailureForFailedAssignment(event.getTaskAttemptId());
            container.sendTerminatingToTaskAttempt(event.getTaskAttemptId(), errorMessage, TaskAttemptTerminationCause.CONTAINER_EXITED);
            container.registerFailedAttempt(event.getTaskAttemptId());
        }
    }

    protected static class ErrorAtRunningTransition
    extends ErrorAtIdleTransition {
        protected ErrorAtRunningTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            String errorMessage = "Container " + container.getContainerId() + " hit an invalid transition - " + cEvent.getType() + " at " + (Object)((Object)container.getState());
            container.unregisterAttemptFromListener(container.currentAttempt, TaskAttemptEndReason.FRAMEWORK_ERROR, errorMessage);
            container.sendTerminatingToTaskAttempt(container.currentAttempt, errorMessage, TaskAttemptTerminationCause.FRAMEWORK_ERROR);
        }
    }

    protected static class NodeFailedAtRunningTransition
    extends NodeFailedAtIdleTransition {
        protected NodeFailedAtRunningTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            String errorMessage = "Node " + container.getContainer().getNodeId() + " failed. ";
            container.unregisterAttemptFromListener(container.currentAttempt, TaskAttemptEndReason.NODE_FAILED, errorMessage);
        }
    }

    protected static class TimedOutAtRunningTransition
    extends StopRequestAtRunningTransition {
        protected TimedOutAtRunningTransition() {
        }

        @Override
        public String getMessage(AMContainerImpl container, AMContainerEvent event) {
            return "Container " + container.getContainerId() + " timed out";
        }
    }

    protected static class StopRequestAtRunningTransition
    extends StopRequestAtIdleTransition {
        protected StopRequestAtRunningTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.unregisterAttemptFromListener(container.currentAttempt, TaskAttemptEndReason.OTHER, this.getMessage(container, cEvent));
            super.transition(container, cEvent);
        }
    }

    protected static class CompletedAtRunningTransition
    extends CompletedAtIdleTransition {
        protected CompletedAtRunningTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventCompleted event = (AMContainerEventCompleted)cEvent;
            if (event.isSystemAction()) {
                container.sendContainerTerminatedBySystemToTaskAttempt(container.currentAttempt, this.getMessage(container, event), event.getTerminationCause());
            } else {
                container.sendTerminatedToTaskAttempt(container.currentAttempt, this.getMessage(container, event), event.getTerminationCause());
            }
            container.unregisterAttemptFromListener(container.currentAttempt, TezUtilsInternal.toTaskAttemptEndReason((TaskAttemptTerminationCause)event.getTerminationCause()), this.getMessage(container, event));
            container.registerFailedAttempt(container.currentAttempt);
            container.currentAttempt = null;
            super.transition(container, cEvent);
        }
    }

    protected static class TASucceededAtRunningTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected TASucceededAtRunningTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.lastTaskFinishTime = System.currentTimeMillis();
            container.completedAttempts.add(container.currentAttempt);
            container.unregisterAttemptFromListener(container.currentAttempt, TaskAttemptEndReason.OTHER, null);
            container.currentAttempt = null;
        }
    }

    protected static class AssignTaskAttemptAtRunningTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected AssignTaskAttemptAtRunningTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventAssignTA event = (AMContainerEventAssignTA)cEvent;
            String errorMessage = "AMScheduler Error: Multiple simultaneous taskAttempt allocations to: " + container.getContainerId() + ". Attempts: " + container.getCurrentTaskAttempt() + ", " + event.getTaskAttemptId() + ". Current state: " + (Object)((Object)container.getState());
            container.unregisterAttemptFromListener(container.currentAttempt, TaskAttemptEndReason.FRAMEWORK_ERROR, errorMessage);
            container.handleExtraTAAssign(event, container.currentAttempt);
        }
    }

    protected static class ErrorAtIdleTransition
    extends ErrorAtLaunchingTransition {
        protected ErrorAtIdleTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.unregisterFromContainerListener();
        }
    }

    protected static class NodeFailedAtIdleTransition
    extends NodeFailedAtLaunchingTransition {
        protected NodeFailedAtIdleTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.unregisterFromContainerListener();
        }
    }

    protected static class TimedOutAtIdleTransition
    extends StopRequestAtIdleTransition {
        protected TimedOutAtIdleTransition() {
        }

        @Override
        public String getMessage(AMContainerImpl container, AMContainerEvent event) {
            return "Container " + container.getContainerId() + " timed out";
        }
    }

    protected static class StopRequestAtIdleTransition
    extends StopRequestAtLaunchingTransition {
        protected StopRequestAtIdleTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.unregisterFromContainerListener();
        }
    }

    protected static class CompletedAtIdleTransition
    extends CompletedAtLaunchingTransition {
        protected CompletedAtIdleTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.unregisterFromContainerListener();
            if (LOG.isDebugEnabled()) {
                LOG.debug("TotalIdleTimeBetweenTasks for container: " + container.getContainerId() + " = " + container.idleTimeBetweenTasks);
            }
        }

        @Override
        public String getMessage(AMContainerImpl container, AMContainerEventCompleted event) {
            return "Container " + container.getContainerId() + " finished with diagnostics set to [" + event.getDiagnostics() + "]";
        }
    }

    protected static class ErrorAtLaunchingTransition
    extends ErrorBaseTransition {
        protected ErrorAtLaunchingTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            String errorMessage = "Container " + container.getContainerId() + " hit an invalid transition - " + cEvent.getType() + " at " + (Object)((Object)container.getState());
            if (container.currentAttempt != null) {
                container.sendTerminatingToTaskAttempt(container.currentAttempt, errorMessage, TaskAttemptTerminationCause.FRAMEWORK_ERROR);
            }
            container.logStopped(-100);
            container.unregisterFromTAListener(ContainerEndReason.FRAMEWORK_ERROR, errorMessage);
            container.sendStopRequestToNM();
        }
    }

    protected static class NodeFailedAtLaunchingTransition
    extends NodeFailedBaseTransition {
        protected NodeFailedAtLaunchingTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            String errorMessage = "Node " + container.getContainer().getNodeId() + " failed. ";
            if (cEvent instanceof DiagnosableEvent) {
                errorMessage = errorMessage + ((DiagnosableEvent)((Object)cEvent)).getDiagnosticInfo();
            }
            container.unregisterFromTAListener(ContainerEndReason.NODE_FAILED, errorMessage);
            container.deAllocate();
        }
    }

    protected static class NodeFailedBaseTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected NodeFailedBaseTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            if (container.nodeFailed) {
                return;
            }
            container.nodeFailed = true;
            String errorMessage = "Node " + container.getContainer().getNodeId() + " failed. ";
            if (cEvent instanceof DiagnosableEvent) {
                errorMessage = errorMessage + ((DiagnosableEvent)((Object)cEvent)).getDiagnosticInfo();
            }
            for (TezTaskAttemptID taId : container.failedAssignments) {
                container.sendNodeFailureToTA(taId, errorMessage, TaskAttemptTerminationCause.NODE_FAILED);
            }
            for (TezTaskAttemptID taId : container.completedAttempts) {
                container.sendNodeFailureToTA(taId, errorMessage, TaskAttemptTerminationCause.NODE_FAILED);
            }
            if (container.currentAttempt != null) {
                container.sendNodeFailureToTA(container.currentAttempt, errorMessage, TaskAttemptTerminationCause.NODE_FAILED);
                container.sendTerminatingToTaskAttempt(container.currentAttempt, errorMessage, TaskAttemptTerminationCause.NODE_FAILED);
            }
            container.logStopped(-100);
        }
    }

    protected static class StopRequestAtLaunchingTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected StopRequestAtLaunchingTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            if (container.currentAttempt != null) {
                container.sendTerminatingToTaskAttempt(container.currentAttempt, this.getMessage(container, cEvent), TaskAttemptTerminationCause.CONTAINER_STOPPED);
            }
            container.unregisterFromTAListener(ContainerEndReason.OTHER, this.getMessage(container, cEvent));
            container.logStopped(container.currentAttempt == null ? 0 : -1000);
            container.sendStopRequestToNM();
        }

        public String getMessage(AMContainerImpl container, AMContainerEvent event) {
            return "Container " + container.getContainerId() + " received a STOP_REQUEST";
        }
    }

    protected static class CompletedAtLaunchingTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected CompletedAtLaunchingTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventCompleted event = (AMContainerEventCompleted)cEvent;
            if (container.currentAttempt != null) {
                String errorMessage = this.getMessage(container, event);
                if (event.isSystemAction()) {
                    container.sendContainerTerminatedBySystemToTaskAttempt(container.currentAttempt, errorMessage, event.getTerminationCause());
                } else {
                    container.sendTerminatedToTaskAttempt(container.currentAttempt, errorMessage, event.getTerminationCause() == TaskAttemptTerminationCause.CONTAINER_EXITED ? TaskAttemptTerminationCause.CONTAINER_LAUNCH_FAILED : event.getTerminationCause());
                }
                container.registerFailedAttempt(container.currentAttempt);
                container.currentAttempt = null;
                LOG.warn(errorMessage);
            }
            container.containerLocalResources = null;
            container.additionalLocalResources = null;
            container.unregisterFromTAListener(event.getContainerEndReason(), event.getDiagnostics());
            String diag = event.getDiagnostics();
            if (diag != null && !diag.equals("")) {
                LOG.info("Container " + container.getContainerId() + " exited with diagnostics set to " + diag);
            }
            container.logStopped(event.getContainerExitStatus());
        }

        public String getMessage(AMContainerImpl container, AMContainerEventCompleted event) {
            return "Container" + container.getContainerId() + " finished while trying to launch. Diagnostics: [" + event.getDiagnostics() + "]";
        }
    }

    protected static class LaunchFailedTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected LaunchFailedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventLaunchFailed event = (AMContainerEventLaunchFailed)cEvent;
            if (container.currentAttempt != null) {
                container.sendTerminatingToTaskAttempt(container.currentAttempt, event.getMessage(), TaskAttemptTerminationCause.CONTAINER_LAUNCH_FAILED);
            }
            container.unregisterFromTAListener(ContainerEndReason.LAUNCH_FAILED, event.getMessage());
            container.deAllocate();
        }
    }

    protected static class LaunchedTransition
    implements MultipleArcTransition<AMContainerImpl, AMContainerEvent, AMContainerState> {
        protected LaunchedTransition() {
        }

        public AMContainerState transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.registerWithContainerListener();
            if (container.currentAttempt != null) {
                return AMContainerState.RUNNING;
            }
            return AMContainerState.IDLE;
        }
    }

    protected static class AssignTaskAttemptTransition
    implements MultipleArcTransition<AMContainerImpl, AMContainerEvent, AMContainerState> {
        protected AssignTaskAttemptTransition() {
        }

        public AMContainerState transition(AMContainerImpl container, AMContainerEvent cEvent) {
            TezDAGID currentDAGID;
            AMContainerEventAssignTA event = (AMContainerEventAssignTA)cEvent;
            if (LOG.isDebugEnabled()) {
                LOG.debug("AssignTaskAttempt at state " + (Object)((Object)container.getState()) + ", attempt: " + ((AMContainerEventAssignTA)cEvent).getRemoteTaskSpec());
            }
            if (container.currentAttempt != null) {
                container.handleExtraTAAssign(event, container.currentAttempt);
                return AMContainerState.STOP_REQUESTED;
            }
            Map<String, LocalResource> taskLocalResources = event.getRemoteTaskLocalResources();
            Preconditions.checkState((container.additionalLocalResources == null ? 1 : 0) != 0, (Object)"No additional resources should be pending when assigning a new task");
            container.additionalLocalResources = container.signatureMatcher.getAdditionalResources(container.containerLocalResources, taskLocalResources);
            container.containerLocalResources.putAll(container.additionalLocalResources);
            container.currentAttempt = event.getTaskAttemptId();
            container.currentAttemptAllocationTime = container.appContext.getClock().getTime();
            if (LOG.isDebugEnabled()) {
                LOG.debug("AssignTA: attempt: " + event.getRemoteTaskSpec());
                LOG.debug("AdditionalLocalResources: " + container.additionalLocalResources);
            }
            if (!(currentDAGID = container.appContext.getCurrentDAGID()).equals((Object)container.lastTaskDAGID)) {
                container.credentialsChanged = true;
                container.credentials = event.getCredentials();
                container.lastTaskDAGID = currentDAGID;
            } else {
                container.credentialsChanged = false;
            }
            if (container.lastTaskFinishTime != 0L) {
                long idleTimeDiff = System.currentTimeMillis() - container.lastTaskFinishTime;
                container.idleTimeBetweenTasks += idleTimeDiff;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Computing idle (scheduling) time for container: " + container.getContainerId() + ", lastFinishTime: " + container.lastTaskFinishTime + ", Incremented by: " + idleTimeDiff);
                }
            }
            AMContainerTask amContainerTask = new AMContainerTask(event.getRemoteTaskSpec(), container.additionalLocalResources, container.credentialsChanged ? container.credentials : null, container.credentialsChanged, event.getPriority());
            container.registerAttemptWithListener(amContainerTask);
            container.additionalLocalResources = null;
            container.credentialsChanged = false;
            if (container.getState() == AMContainerState.IDLE) {
                return AMContainerState.RUNNING;
            }
            return container.getState();
        }
    }

    protected static class ErrorTransition
    extends ErrorBaseTransition {
        protected ErrorTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.deAllocate();
            LOG.warn("Unexpected event type: " + cEvent.getType() + " while in state: " + (Object)((Object)container.getState()) + ". Event: " + (Object)((Object)cEvent));
        }
    }

    protected static class NodeFailedAtAllocatedTransition
    extends NodeFailedBaseTransition {
        protected NodeFailedAtAllocatedTransition() {
        }

        @Override
        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            super.transition(container, cEvent);
            container.deAllocate();
        }
    }

    protected static class StopRequestAtAllocatedTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected StopRequestAtAllocatedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            container.deAllocate();
        }
    }

    protected static class CompletedAtAllocatedTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected CompletedAtAllocatedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventCompleted event = (AMContainerEventCompleted)cEvent;
            String diag = event.getDiagnostics();
            if (diag != null && !diag.equals("")) {
                LOG.info("Container " + container.getContainerId() + " exited with diagnostics set to " + diag);
            }
        }
    }

    protected static class AssignTaskAttemptAtAllocatedTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected AssignTaskAttemptAtAllocatedTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventAssignTA event = (AMContainerEventAssignTA)cEvent;
            container.inError = true;
            container.registerFailedAttempt(event.getTaskAttemptId());
            container.maybeSendNodeFailureForFailedAssignment(event.getTaskAttemptId());
            container.sendTerminatedToTaskAttempt(event.getTaskAttemptId(), "AMScheduler Error: TaskAttempt allocated to unlaunched container: " + container.getContainerId(), TaskAttemptTerminationCause.FRAMEWORK_ERROR);
            container.deAllocate();
            LOG.warn("Unexpected TA Assignment: TAId: " + event.getTaskAttemptId() + "  for ContainerId: " + container.getContainerId() + " while in state: " + (Object)((Object)container.getState()));
        }
    }

    protected static class LaunchRequestTransition
    implements SingleArcTransition<AMContainerImpl, AMContainerEvent> {
        protected LaunchRequestTransition() {
        }

        public void transition(AMContainerImpl container, AMContainerEvent cEvent) {
            AMContainerEventLaunchRequest event = (AMContainerEventLaunchRequest)cEvent;
            ContainerContext containerContext = event.getContainerContext();
            container.containerLocalResources = new HashMap<String, LocalResource>(containerContext.getLocalResources());
            container.credentials = containerContext.getCredentials();
            container.credentialsChanged = true;
            TezDAGID dagId = null;
            Map<String, LocalResource> dagLocalResources = null;
            if (container.appContext.getCurrentDAG() != null) {
                dagId = container.appContext.getCurrentDAG().getID();
                dagLocalResources = container.appContext.getCurrentDAG().getLocalResources();
            }
            InetSocketAddress cAddress = null;
            try {
                cAddress = container.taskCommunicatorManagerInterface.getTaskCommunicator(container.taskCommId).getAddress();
            }
            catch (Exception e) {
                String msg = "Error in TaskCommunicator when getting address, communicator=" + Utils.getTaskCommIdentifierString(container.taskCommId, container.appContext) + ", containerId=" + container.containerId;
                LOG.error(msg, (Throwable)e);
                container.sendEvent((Event)new DAGAppMasterEventUserServiceFatalError(DAGAppMasterEventType.TASK_COMMUNICATOR_SERVICE_FATAL_ERROR, msg, e));
                container.inError = true;
                container.deAllocate();
                return;
            }
            ContainerLaunchContext clc = AMContainerHelpers.createContainerLaunchContext(dagId, dagLocalResources, container.appContext.getApplicationACLs(), container.getContainerId(), containerContext.getLocalResources(), containerContext.getEnvironment(), containerContext.getJavaOpts(), cAddress, containerContext.getCredentials(), container.appContext, container.container.getResource(), container.appContext.getAMConf());
            container.registerWithTAListener();
            container.sendStartRequestToNM(clc);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending Launch Request for Container with id: " + container.container.getId());
            }
        }
    }
}

