/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.ServicePluginError;
import org.apache.tez.serviceplugins.api.TaskSchedulerContext;

class TaskSchedulerContextImplWrapper
implements TaskSchedulerContext {
    private TaskSchedulerContext real;
    private ExecutorService executorService;

    public TaskSchedulerContextImplWrapper(TaskSchedulerContext real, ExecutorService executorService) {
        this.real = real;
        this.executorService = executorService;
    }

    public void taskAllocated(Object task, Object appCookie, Container container) {
        this.executorService.submit(new TaskAllocatedCallable(this.real, task, appCookie, container));
    }

    public void containerCompleted(Object taskLastAllocated, ContainerStatus containerStatus) {
        this.executorService.submit(new ContainerCompletedCallable(this.real, taskLastAllocated, containerStatus));
    }

    public void containerBeingReleased(ContainerId containerId) {
        this.executorService.submit(new ContainerBeingReleasedCallable(this.real, containerId));
    }

    public void nodesUpdated(List<NodeReport> updatedNodes) {
        this.executorService.submit(new NodesUpdatedCallable(this.real, updatedNodes));
    }

    public void appShutdownRequested() {
        this.executorService.submit(new AppShudownRequestedCallable(this.real));
    }

    public void setApplicationRegistrationData(Resource maxContainerCapability, Map<ApplicationAccessType, String> appAcls, ByteBuffer key) {
        this.executorService.submit(new SetApplicationRegistrationDataCallable(this.real, maxContainerCapability, appAcls, key));
    }

    public void reportError(@Nonnull ServicePluginError servicePluginError, String message, DagInfo dagInfo) {
        this.executorService.submit(new ReportErrorCallable(this.real, servicePluginError, message, dagInfo));
    }

    public float getProgress() {
        Future<Float> progressFuture = this.executorService.submit(new GetProgressCallable(this.real));
        try {
            return progressFuture.get().floatValue();
        }
        catch (Exception e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    public void preemptContainer(ContainerId containerId) {
        this.executorService.submit(new PreemptContainerCallable(this.real, containerId));
    }

    public TaskSchedulerContext.AppFinalStatus getFinalAppStatus() {
        Future<TaskSchedulerContext.AppFinalStatus> appFinalStatusFuture = this.executorService.submit(new GetFinalAppStatusCallable(this.real));
        try {
            return appFinalStatusFuture.get();
        }
        catch (Exception e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    public UserPayload getInitialUserPayload() {
        return this.real.getInitialUserPayload();
    }

    public String getAppTrackingUrl() {
        return this.real.getAppTrackingUrl();
    }

    public long getCustomClusterIdentifier() {
        return this.real.getCustomClusterIdentifier();
    }

    public ContainerSignatureMatcher getContainerSignatureMatcher() {
        return this.real.getContainerSignatureMatcher();
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.real.getApplicationAttemptId();
    }

    @Nullable
    public DagInfo getCurrentDagInfo() {
        return this.real.getCurrentDagInfo();
    }

    public String getAppHostName() {
        return this.real.getAppHostName();
    }

    public int getAppClientPort() {
        return this.real.getAppClientPort();
    }

    public boolean isSession() {
        return this.real.isSession();
    }

    public TaskSchedulerContext.AMState getAMState() {
        return this.real.getAMState();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    ExecutorService getExecutorService() {
        return this.executorService;
    }

    static class GetFinalAppStatusCallable
    extends TaskSchedulerContextCallbackBase
    implements Callable<TaskSchedulerContext.AppFinalStatus> {
        public GetFinalAppStatusCallable(TaskSchedulerContext app) {
            super(app);
        }

        @Override
        public TaskSchedulerContext.AppFinalStatus call() throws Exception {
            return this.app.getFinalAppStatus();
        }
    }

    static class GetProgressCallable
    extends TaskSchedulerContextCallbackBase
    implements Callable<Float> {
        public GetProgressCallable(TaskSchedulerContext app) {
            super(app);
        }

        @Override
        public Float call() throws Exception {
            return Float.valueOf(this.app.getProgress());
        }
    }

    static class PreemptContainerCallable
    extends TaskSchedulerContextCallbackBase
    implements Callable<Void> {
        private final ContainerId containerId;

        public PreemptContainerCallable(TaskSchedulerContext app, ContainerId id) {
            super(app);
            this.containerId = id;
        }

        @Override
        public Void call() throws Exception {
            this.app.preemptContainer(this.containerId);
            return null;
        }
    }

    static class ReportErrorCallable
    extends TaskSchedulerContextCallbackBase
    implements Callable<Void> {
        private final ServicePluginError servicePluginError;
        private final String message;
        private final DagInfo dagInfo;

        public ReportErrorCallable(TaskSchedulerContext app, ServicePluginError servicePluginError, String message, DagInfo dagInfo) {
            super(app);
            this.servicePluginError = servicePluginError;
            this.message = message;
            this.dagInfo = dagInfo;
        }

        @Override
        public Void call() throws Exception {
            this.app.reportError(this.servicePluginError, this.message, this.dagInfo);
            return null;
        }
    }

    static class SetApplicationRegistrationDataCallable
    extends TaskSchedulerContextCallbackBase
    implements Callable<Void> {
        private final Resource maxContainerCapability;
        private final Map<ApplicationAccessType, String> appAcls;
        private final ByteBuffer key;

        public SetApplicationRegistrationDataCallable(TaskSchedulerContext app, Resource maxContainerCapability, Map<ApplicationAccessType, String> appAcls, ByteBuffer key) {
            super(app);
            this.maxContainerCapability = maxContainerCapability;
            this.appAcls = appAcls;
            this.key = key;
        }

        @Override
        public Void call() throws Exception {
            this.app.setApplicationRegistrationData(this.maxContainerCapability, this.appAcls, this.key);
            return null;
        }
    }

    static class AppShudownRequestedCallable
    extends TaskSchedulerContextCallbackBase
    implements Callable<Void> {
        public AppShudownRequestedCallable(TaskSchedulerContext app) {
            super(app);
        }

        @Override
        public Void call() throws Exception {
            this.app.appShutdownRequested();
            return null;
        }
    }

    static class NodesUpdatedCallable
    extends TaskSchedulerContextCallbackBase
    implements Callable<Void> {
        private final List<NodeReport> updatedNodes;

        public NodesUpdatedCallable(TaskSchedulerContext app, List<NodeReport> updatedNodes) {
            super(app);
            this.updatedNodes = updatedNodes;
        }

        @Override
        public Void call() throws Exception {
            this.app.nodesUpdated(this.updatedNodes);
            return null;
        }
    }

    static class ContainerBeingReleasedCallable
    extends TaskSchedulerContextCallbackBase
    implements Callable<Void> {
        private final ContainerId containerId;

        public ContainerBeingReleasedCallable(TaskSchedulerContext app, ContainerId containerId) {
            super(app);
            this.containerId = containerId;
        }

        @Override
        public Void call() throws Exception {
            this.app.containerBeingReleased(this.containerId);
            return null;
        }
    }

    static class ContainerCompletedCallable
    extends TaskSchedulerContextCallbackBase
    implements Callable<Void> {
        private final Object taskLastAllocated;
        private final ContainerStatus containerStatus;

        public ContainerCompletedCallable(TaskSchedulerContext app, Object taskLastAllocated, ContainerStatus containerStatus) {
            super(app);
            this.taskLastAllocated = taskLastAllocated;
            this.containerStatus = containerStatus;
        }

        @Override
        public Void call() throws Exception {
            this.app.containerCompleted(this.taskLastAllocated, this.containerStatus);
            return null;
        }
    }

    static class TaskAllocatedCallable
    extends TaskSchedulerContextCallbackBase
    implements Callable<Void> {
        private final Object task;
        private final Object appCookie;
        private final Container container;

        public TaskAllocatedCallable(TaskSchedulerContext app, Object task, Object appCookie, Container container) {
            super(app);
            this.task = task;
            this.appCookie = appCookie;
            this.container = container;
        }

        @Override
        public Void call() throws Exception {
            this.app.taskAllocated(this.task, this.appCookie, this.container);
            return null;
        }
    }

    static abstract class TaskSchedulerContextCallbackBase {
        protected TaskSchedulerContext app;

        public TaskSchedulerContextCallbackBase(TaskSchedulerContext app) {
            this.app = app;
        }
    }
}

