/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.TaskCommunicatorManager;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.VertexStateUpdateListener;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.ServicePluginError;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.serviceplugins.api.TaskCommunicatorContext;
import org.apache.tez.serviceplugins.api.TaskHeartbeatRequest;
import org.apache.tez.serviceplugins.api.TaskHeartbeatResponse;

@InterfaceAudience.Private
public class TaskCommunicatorContextImpl
implements TaskCommunicatorContext,
VertexStateUpdateListener {
    private final AppContext context;
    private final TaskCommunicatorManager taskCommunicatorManager;
    private final int taskCommunicatorIndex;
    private final ReentrantReadWriteLock.ReadLock dagChangedReadLock;
    private final ReentrantReadWriteLock.WriteLock dagChangedWriteLock;
    private final UserPayload userPayload;
    private DAG dag;

    public TaskCommunicatorContextImpl(AppContext appContext, TaskCommunicatorManager taskCommunicatorManager, UserPayload userPayload, int taskCommunicatorIndex) {
        this.context = appContext;
        this.taskCommunicatorManager = taskCommunicatorManager;
        this.userPayload = userPayload;
        this.taskCommunicatorIndex = taskCommunicatorIndex;
        ReentrantReadWriteLock dagChangedLock = new ReentrantReadWriteLock();
        this.dagChangedReadLock = dagChangedLock.readLock();
        this.dagChangedWriteLock = dagChangedLock.writeLock();
    }

    public UserPayload getInitialUserPayload() {
        return this.userPayload;
    }

    @Override
    public ApplicationAttemptId getApplicationAttemptId() {
        return this.context.getApplicationAttemptId();
    }

    @Override
    public Credentials getAMCredentials() {
        return this.context.getAppCredentials();
    }

    @Override
    public boolean canCommit(TezTaskAttemptID taskAttemptId) throws IOException {
        return this.taskCommunicatorManager.canCommit(taskAttemptId);
    }

    @Override
    public TaskHeartbeatResponse heartbeat(TaskHeartbeatRequest request) throws IOException, TezException {
        return this.taskCommunicatorManager.heartbeat(request);
    }

    @Override
    public boolean isKnownContainer(ContainerId containerId) {
        AMContainer amContainer = this.context.getAllContainers().get(containerId);
        return amContainer != null && amContainer.getTaskCommunicatorIdentifier() == this.taskCommunicatorIndex;
    }

    @Override
    public void taskAlive(TezTaskAttemptID taskAttemptId) {
        this.taskCommunicatorManager.taskAlive(taskAttemptId);
    }

    @Override
    public void containerAlive(ContainerId containerId) {
        if (this.isKnownContainer(containerId)) {
            this.taskCommunicatorManager.containerAlive(containerId);
        }
    }

    @Override
    public void taskStartedRemotely(TezTaskAttemptID taskAttemptId, ContainerId containerId) {
        this.taskCommunicatorManager.taskStartedRemotely(taskAttemptId, containerId);
    }

    @Override
    public void taskKilled(TezTaskAttemptID taskAttemptId, TaskAttemptEndReason taskAttemptEndReason, @Nullable String diagnostics) {
        this.taskCommunicatorManager.taskKilled(taskAttemptId, taskAttemptEndReason, diagnostics);
    }

    @Override
    public void taskFailed(TezTaskAttemptID taskAttemptId, TaskFailureType taskFailureType, TaskAttemptEndReason taskAttemptEndReason, @Nullable String diagnostics) {
        this.taskCommunicatorManager.taskFailed(taskAttemptId, taskFailureType, taskAttemptEndReason, diagnostics);
    }

    @Override
    public void registerForVertexStateUpdates(String vertexName, @Nullable Set<VertexState> stateSet) {
        Preconditions.checkNotNull((Object)vertexName, (Object)("VertexName cannot be null: " + vertexName));
        this.getDag().getStateChangeNotifier().registerForVertexUpdates(vertexName, stateSet, this);
    }

    @Override
    public String getCurrentAppIdentifier() {
        return this.context.getApplicationID().toString();
    }

    @Nullable
    public DagInfo getCurrentDagInfo() {
        return this.getDag();
    }

    @Override
    public Iterable<String> getInputVertexNames(String vertexName) {
        Preconditions.checkNotNull((Object)vertexName, (Object)("VertexName cannot be null: " + vertexName));
        Vertex vertex = this.getDag().getVertex(vertexName);
        Set<Vertex> sources = vertex.getInputVertices().keySet();
        return Iterables.transform(sources, (Function)new Function<Vertex, String>(){

            public String apply(Vertex input) {
                return input.getName();
            }
        });
    }

    @Override
    public int getVertexTotalTaskCount(String vertexName) {
        Preconditions.checkArgument((vertexName != null ? 1 : 0) != 0, (Object)"VertexName must be specified");
        return this.getDag().getVertex(vertexName).getTotalTasks();
    }

    @Override
    public int getVertexCompletedTaskCount(String vertexName) {
        Preconditions.checkArgument((vertexName != null ? 1 : 0) != 0, (Object)"VertexName must be specified");
        return this.getDag().getVertex(vertexName).getCompletedTasks();
    }

    @Override
    public int getVertexRunningTaskCount(String vertexName) {
        Preconditions.checkArgument((vertexName != null ? 1 : 0) != 0, (Object)"VertexName must be specified");
        return this.getDag().getVertex(vertexName).getRunningTasks();
    }

    @Override
    public long getFirstAttemptStartTime(String vertexName, int taskIndex) {
        Preconditions.checkArgument((vertexName != null ? 1 : 0) != 0, (Object)"VertexName must be specified");
        Preconditions.checkArgument((taskIndex >= 0 ? 1 : 0) != 0, (Object)"TaskIndex must be > 0");
        return this.getDag().getVertex(vertexName).getTask(taskIndex).getFirstAttemptStartTime();
    }

    @Override
    public long getDagStartTime() {
        return this.getDag().getStartTime();
    }

    public void reportError(@Nonnull ServicePluginError servicePluginError, String message, DagInfo dagInfo) {
        Preconditions.checkNotNull((Object)servicePluginError, (Object)"ServicePluginError must be set");
        this.taskCommunicatorManager.reportError(this.taskCommunicatorIndex, servicePluginError, message, dagInfo);
    }

    @Override
    public void onStateUpdated(VertexStateUpdate event) {
        this.taskCommunicatorManager.vertexStateUpdateNotificationReceived(event, this.taskCommunicatorIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DAG getDag() {
        this.dagChangedReadLock.lock();
        try {
            if (this.dag != null) {
                DAG dAG = this.dag;
                return dAG;
            }
            DAG dAG = this.context.getCurrentDAG();
            return dAG;
        }
        finally {
            this.dagChangedReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public void dagCompleteStart(DAG dag) {
        this.dagChangedWriteLock.lock();
        try {
            this.dag = dag;
        }
        finally {
            this.dagChangedWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dagCompleteEnd() {
        this.dagChangedWriteLock.lock();
        try {
            this.dag = null;
        }
        finally {
            this.dagChangedWriteLock.unlock();
        }
    }
}

