/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client.rpc;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.tez.client.TezAppMasterStatus;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClientHandler;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.DAGStatusBuilder;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.client.VertexStatusBuilder;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.api.records.DAGProtos;

public class DAGClientAMProtocolBlockingPBServerImpl
implements DAGClientAMProtocolBlockingPB {
    DAGClientHandler real;
    final FileSystem stagingFs;

    public DAGClientAMProtocolBlockingPBServerImpl(DAGClientHandler real, FileSystem stagingFs) {
        this.real = real;
        this.stagingFs = stagingFs;
    }

    private UserGroupInformation getRPCUser() throws ServiceException {
        try {
            return UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    public DAGClientAMProtocolRPC.GetAllDAGsResponseProto getAllDAGs(RpcController controller, DAGClientAMProtocolRPC.GetAllDAGsRequestProto request) throws ServiceException {
        UserGroupInformation user = this.getRPCUser();
        if (!this.real.getACLManager().checkAMViewAccess(user)) {
            throw new AccessControlException("User " + user + " cannot perform AM view operation");
        }
        try {
            List<String> dagIds = this.real.getAllDAGs();
            return DAGClientAMProtocolRPC.GetAllDAGsResponseProto.newBuilder().addAllDagId(dagIds).build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }

    public DAGClientAMProtocolRPC.GetDAGStatusResponseProto getDAGStatus(RpcController controller, DAGClientAMProtocolRPC.GetDAGStatusRequestProto request) throws ServiceException {
        UserGroupInformation user = this.getRPCUser();
        try {
            String dagId = request.getDagId();
            long timeout = request.getTimeout();
            if (!this.real.getACLManager(dagId).checkDAGViewAccess(user)) {
                throw new AccessControlException("User " + user + " cannot perform DAG view operation");
            }
            DAGStatus status = this.real.getDAGStatus(dagId, DagTypeConverters.convertStatusGetOptsFromProto((List)request.getStatusOptionsList()), timeout);
            assert (status instanceof DAGStatusBuilder);
            DAGStatusBuilder builder = (DAGStatusBuilder)status;
            return DAGClientAMProtocolRPC.GetDAGStatusResponseProto.newBuilder().setDagStatus(builder.getProto()).build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }

    public DAGClientAMProtocolRPC.GetVertexStatusResponseProto getVertexStatus(RpcController controller, DAGClientAMProtocolRPC.GetVertexStatusRequestProto request) throws ServiceException {
        UserGroupInformation user = this.getRPCUser();
        try {
            String dagId = request.getDagId();
            if (!this.real.getACLManager(dagId).checkDAGViewAccess(user)) {
                throw new AccessControlException("User " + user + " cannot perform DAG view operation");
            }
            String vertexName = request.getVertexName();
            VertexStatus status = this.real.getVertexStatus(dagId, vertexName, DagTypeConverters.convertStatusGetOptsFromProto((List)request.getStatusOptionsList()));
            assert (status instanceof VertexStatusBuilder);
            VertexStatusBuilder builder = (VertexStatusBuilder)status;
            return DAGClientAMProtocolRPC.GetVertexStatusResponseProto.newBuilder().setVertexStatus(builder.getProto()).build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }

    public DAGClientAMProtocolRPC.TryKillDAGResponseProto tryKillDAG(RpcController controller, DAGClientAMProtocolRPC.TryKillDAGRequestProto request) throws ServiceException {
        UserGroupInformation user = this.getRPCUser();
        try {
            String dagId = request.getDagId();
            if (!this.real.getACLManager(dagId).checkDAGModifyAccess(user)) {
                throw new AccessControlException("User " + user + " cannot perform DAG modify operation");
            }
            this.real.tryKillDAG(dagId);
            return DAGClientAMProtocolRPC.TryKillDAGResponseProto.newBuilder().build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }

    public DAGClientAMProtocolRPC.SubmitDAGResponseProto submitDAG(RpcController controller, DAGClientAMProtocolRPC.SubmitDAGRequestProto request) throws ServiceException {
        UserGroupInformation user = this.getRPCUser();
        if (!this.real.getACLManager().checkAMModifyAccess(user)) {
            throw new AccessControlException("User " + user + " cannot perform AM modify operation");
        }
        try {
            if (request.hasSerializedRequestPath()) {
                Path requestPath = new Path(request.getSerializedRequestPath());
                try (FSDataInputStream fsDataInputStream = this.stagingFs.open(requestPath);){
                    request = DAGClientAMProtocolRPC.SubmitDAGRequestProto.parseFrom((InputStream)fsDataInputStream);
                }
                catch (IOException e) {
                    throw this.wrapException(e);
                }
            }
            DAGProtos.DAGPlan dagPlan = request.getDAGPlan();
            Map additionalResources = null;
            if (request.hasAdditionalAmResources()) {
                additionalResources = DagTypeConverters.convertFromPlanLocalResources((DAGProtos.PlanLocalResourcesProto)request.getAdditionalAmResources());
            }
            String dagId = this.real.submitDAG(dagPlan, additionalResources);
            return DAGClientAMProtocolRPC.SubmitDAGResponseProto.newBuilder().setDagId(dagId).build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }

    ServiceException wrapException(Exception e) {
        return new ServiceException((Throwable)e);
    }

    public DAGClientAMProtocolRPC.ShutdownSessionResponseProto shutdownSession(RpcController arg0, DAGClientAMProtocolRPC.ShutdownSessionRequestProto arg1) throws ServiceException {
        UserGroupInformation user = this.getRPCUser();
        if (!this.real.getACLManager().checkAMModifyAccess(user)) {
            throw new AccessControlException("User " + user + " cannot perform AM modify operation");
        }
        try {
            this.real.shutdownAM();
            return DAGClientAMProtocolRPC.ShutdownSessionResponseProto.newBuilder().build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }

    public DAGClientAMProtocolRPC.GetAMStatusResponseProto getAMStatus(RpcController controller, DAGClientAMProtocolRPC.GetAMStatusRequestProto request) throws ServiceException {
        UserGroupInformation user = this.getRPCUser();
        if (!this.real.getACLManager().checkAMViewAccess(user)) {
            throw new AccessControlException("User " + user + " cannot perform AM view operation");
        }
        try {
            TezAppMasterStatus sessionStatus = this.real.getTezAppMasterStatus();
            return DAGClientAMProtocolRPC.GetAMStatusResponseProto.newBuilder().setStatus(DagTypeConverters.convertTezAppMasterStatusToProto((TezAppMasterStatus)sessionStatus)).build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }
}

