/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.common.counters.DAGCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.oldrecords.TaskAttemptReport;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;

public interface TaskAttempt {
    public TezTaskAttemptID getID();

    public TezTaskID getTaskID();

    public TezVertexID getVertexID();

    public TezDAGID getDAGID();

    public TaskAttemptReport getReport();

    public List<String> getDiagnostics();

    public TezCounters getCounters();

    public float getProgress();

    public TaskAttemptState getState();

    public TaskAttemptState getStateNoLock();

    public boolean isFinished();

    public ContainerId getAssignedContainerID();

    public Container getAssignedContainer();

    public String getAssignedContainerMgrAddress();

    public NodeId getNodeId();

    public String getNodeHttpAddress();

    public String getNodeRackName();

    public long getLaunchTime();

    public long getFinishTime();

    public Task getTask();

    public TaskAttemptState restoreFromEvent(HistoryEvent var1);

    public static class TaskAttemptStatus {
        public TaskAttemptState state;
        public DAGCounter localityCounter;
        public float progress;
        public TezCounters counters;
        private AtomicBoolean localitySet = new AtomicBoolean(false);

        public void setLocalityCounter(DAGCounter localityCounter) {
            if (!this.localitySet.get()) {
                this.localitySet.set(true);
                if (this.counters == null) {
                    this.counters = new TezCounters();
                }
                if (localityCounter != null) {
                    this.counters.findCounter((Enum)localityCounter).increment(1L);
                }
            }
        }
    }
}

