/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.impl.Edge;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;

public class VertexManager {
    VertexManagerPluginDescriptor pluginDesc;
    VertexManagerPlugin plugin;
    Vertex managedVertex;
    VertexManagerPluginContextImpl pluginContext;
    UserPayload payload = null;
    AppContext appContext;
    ConcurrentHashMap<String, List<TezEvent>> cachedRootInputEventMap;

    public VertexManager(VertexManagerPluginDescriptor pluginDesc, Vertex managedVertex, AppContext appContext) {
        Preconditions.checkNotNull((Object)pluginDesc, (Object)"pluginDesc is null");
        Preconditions.checkNotNull((Object)managedVertex, (Object)"managedVertex is null");
        Preconditions.checkNotNull((Object)appContext, (Object)"appContext is null");
        this.pluginDesc = pluginDesc;
        this.managedVertex = managedVertex;
        this.appContext = appContext;
        this.cachedRootInputEventMap = new ConcurrentHashMap();
    }

    public VertexManagerPlugin getPlugin() {
        return this.plugin;
    }

    public void initialize() {
        this.pluginContext = new VertexManagerPluginContextImpl();
        if (this.pluginDesc != null) {
            this.plugin = (VertexManagerPlugin)ReflectionUtils.createClazzInstance((String)this.pluginDesc.getClassName(), (Class[])new Class[]{VertexManagerPluginContext.class}, (Object[])new Object[]{this.pluginContext});
            this.payload = this.pluginDesc.getUserPayload();
        }
        this.plugin.initialize();
    }

    public void onVertexStarted(List<TezTaskAttemptID> completions) {
        HashMap pluginCompletionsMap = Maps.newHashMap();
        if (completions != null && !completions.isEmpty()) {
            for (TezTaskAttemptID tezTaskAttemptID : completions) {
                Integer taskId = new Integer(tezTaskAttemptID.getTaskID().getId());
                String vertexName = this.appContext.getCurrentDAG().getVertex(tezTaskAttemptID.getTaskID().getVertexID()).getName();
                List taskIdList = (List)pluginCompletionsMap.get(vertexName);
                if (taskIdList == null) {
                    taskIdList = Lists.newArrayList();
                    pluginCompletionsMap.put(vertexName, taskIdList);
                }
                taskIdList.add(taskId);
            }
        }
        this.plugin.onVertexStarted((Map)pluginCompletionsMap);
    }

    public void onSourceTaskCompleted(TezTaskID tezTaskId) {
        Integer taskId = new Integer(tezTaskId.getId());
        String vertexName = this.appContext.getCurrentDAG().getVertex(tezTaskId.getVertexID()).getName();
        this.plugin.onSourceTaskCompleted(vertexName, taskId);
    }

    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) {
        this.plugin.onVertexManagerEventReceived(vmEvent);
    }

    public List<TezEvent> onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) {
        this.plugin.onRootVertexInitialized(inputName, inputDescriptor, events);
        return this.cachedRootInputEventMap.get(inputName);
    }

    class VertexManagerPluginContextImpl
    implements VertexManagerPluginContext {
        private EventMetaData rootEventSourceMetadata;
        private Map<String, EventMetaData> destinationEventMetadataMap;

        VertexManagerPluginContextImpl() {
            this.rootEventSourceMetadata = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, VertexManager.this.managedVertex.getName(), "NULL_VERTEX", null);
            this.destinationEventMetadataMap = Maps.newHashMap();
        }

        public Map<String, EdgeProperty> getInputVertexEdgeProperties() {
            Map<Vertex, Edge> inputs = VertexManager.this.managedVertex.getInputVertices();
            HashMap vertexEdgeMap = Maps.newHashMapWithExpectedSize((int)inputs.size());
            for (Map.Entry<Vertex, Edge> entry : inputs.entrySet()) {
                vertexEdgeMap.put(entry.getKey().getName(), entry.getValue().getEdgeProperty());
            }
            return vertexEdgeMap;
        }

        public String getVertexName() {
            return VertexManager.this.managedVertex.getName();
        }

        public int getVertexNumTasks(String vertexName) {
            return VertexManager.this.appContext.getCurrentDAG().getVertex(vertexName).getTotalTasks();
        }

        public boolean setVertexParallelism(int parallelism, VertexLocationHint vertexLocationHint, Map<String, EdgeManagerPluginDescriptor> sourceEdgeManagers, Map<String, InputSpecUpdate> rootInputSpecUpdate) {
            return VertexManager.this.managedVertex.setParallelism(parallelism, vertexLocationHint, sourceEdgeManagers, rootInputSpecUpdate);
        }

        public void scheduleVertexTasks(List<VertexManagerPluginContext.TaskWithLocationHint> tasks) {
            VertexManager.this.managedVertex.scheduleTasks(tasks);
        }

        @Nullable
        public Set<String> getVertexInputNames() {
            Set<String> inputNames = null;
            Map<String, RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> inputs = VertexManager.this.managedVertex.getAdditionalInputs();
            if (inputs != null) {
                inputNames = inputs.keySet();
            }
            return inputNames;
        }

        public UserPayload getUserPayload() {
            return VertexManager.this.payload;
        }

        public void addRootInputEvents(final String inputName, Collection<InputDataInformationEvent> events) {
            this.verifyIsRootInput(inputName);
            Iterable tezEvents = Iterables.transform(events, (Function)new Function<InputDataInformationEvent, TezEvent>(){

                public TezEvent apply(InputDataInformationEvent riEvent) {
                    TezEvent tezEvent = new TezEvent((Event)riEvent, VertexManagerPluginContextImpl.this.rootEventSourceMetadata);
                    tezEvent.setDestinationInfo(VertexManagerPluginContextImpl.this.getDestinationMetaData(inputName));
                    return tezEvent;
                }
            });
            VertexManager.this.cachedRootInputEventMap.put(inputName, Lists.newArrayList((Iterable)tezEvents));
        }

        public void setVertexLocationHint(VertexLocationHint locationHint) {
            Preconditions.checkNotNull((Object)locationHint, (Object)"locationHint is null");
            VertexManager.this.managedVertex.setVertexLocationHint(locationHint);
        }

        public int getDAGAttemptNumber() {
            return VertexManager.this.appContext.getApplicationAttemptId().getAttemptId();
        }

        private void verifyIsRootInput(String inputName) {
            Preconditions.checkState((VertexManager.this.managedVertex.getAdditionalInputs().get(inputName) != null ? 1 : 0) != 0, (Object)"Cannot add events for non-root inputs");
        }

        private EventMetaData getDestinationMetaData(String inputName) {
            EventMetaData destMeta = this.destinationEventMetadataMap.get(inputName);
            if (destMeta == null) {
                destMeta = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, VertexManager.this.managedVertex.getName(), inputName, null);
                this.destinationEventMetadataMap.put(inputName, destMeta);
            }
            return destMeta;
        }

        public Resource getVertexTaskResource() {
            return VertexManager.this.managedVertex.getTaskResource();
        }

        public Resource getTotalAvailableResource() {
            return VertexManager.this.appContext.getTaskScheduler().getTotalResources();
        }

        public int getNumClusterNodes() {
            return VertexManager.this.appContext.getTaskScheduler().getNumClusterNodes();
        }

        public Container getTaskContainer(String vertexName, Integer taskIndex) {
            Vertex vertex = VertexManager.this.appContext.getCurrentDAG().getVertex(vertexName);
            Task task = vertex.getTask(taskIndex);
            TaskAttempt attempt = task.getSuccessfulAttempt();
            if (attempt != null) {
                return attempt.getAssignedContainer();
            }
            return null;
        }
    }
}

