/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.VertexManagerEvent;

public class ImmediateStartVertexManager
extends VertexManagerPlugin {
    private static final Log LOG = LogFactory.getLog(ImmediateStartVertexManager.class);
    private final Map<String, SourceVertexInfo> srcVertexInfo = Maps.newHashMap();
    private int managedTasks;
    private boolean tasksScheduled = false;

    public ImmediateStartVertexManager(VertexManagerPluginContext context) {
        super(context);
    }

    public void onVertexStarted(Map<String, List<Integer>> completions) {
        this.managedTasks = this.getContext().getVertexNumTasks(this.getContext().getVertexName());
        Map edges = this.getContext().getInputVertexEdgeProperties();
        for (Map.Entry entry : edges.entrySet()) {
            String srcVertex = (String)entry.getKey();
            EdgeProperty edgeProp = (EdgeProperty)entry.getValue();
            LOG.info((Object)("Task count in " + srcVertex + ": " + this.getContext().getVertexNumTasks(srcVertex)));
            if (this.getContext().getVertexNumTasks(srcVertex) > 0) {
                this.srcVertexInfo.put(srcVertex, new SourceVertexInfo(edgeProp));
                continue;
            }
            LOG.info((Object)("Vertex: " + this.getContext().getVertexName() + "; Ignoring " + srcVertex + " as it has got 0 tasks"));
        }
        for (Map.Entry<Object, Object> entry : completions.entrySet()) {
            for (Integer task : (List)entry.getValue()) {
                this.handleSourceTaskFinished((String)entry.getKey(), task);
            }
        }
        this.scheduleTasks();
    }

    private void handleSourceTaskFinished(String vertex, Integer taskId) {
        SourceVertexInfo srcInfo = this.srcVertexInfo.get(vertex);
        ++srcInfo.numFinishedTasks;
    }

    private void scheduleTasks() {
        if (!this.canScheduleTasks()) {
            return;
        }
        ArrayList tasksToStart = Lists.newArrayListWithCapacity((int)this.managedTasks);
        for (int i = 0; i < this.managedTasks; ++i) {
            tasksToStart.add(new VertexManagerPluginContext.TaskWithLocationHint(new Integer(i), null));
        }
        if (!tasksToStart.isEmpty()) {
            LOG.info((Object)("Starting " + tasksToStart.size() + " in " + this.getContext().getVertexName()));
            this.getContext().scheduleVertexTasks((List)tasksToStart);
        }
        this.tasksScheduled = true;
    }

    private boolean canScheduleTasks() {
        for (Map.Entry<String, SourceVertexInfo> entry : this.srcVertexInfo.entrySet()) {
            SourceVertexInfo srcVertexInfo = entry.getValue();
            switch (srcVertexInfo.edgeProperty.getDataMovementType()) {
                case ONE_TO_ONE: 
                case BROADCAST: 
                case CUSTOM: {
                    if (srcVertexInfo.numFinishedTasks != 0) break;
                    return false;
                }
            }
        }
        return true;
    }

    public void onSourceTaskCompleted(String srcVertexName, Integer attemptId) {
        this.handleSourceTaskFinished(srcVertexName, attemptId);
        if (!this.tasksScheduled) {
            this.scheduleTasks();
        }
    }

    public void initialize() {
    }

    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) {
    }

    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) {
    }

    class SourceVertexInfo {
        EdgeProperty edgeProperty;
        int numFinishedTasks;

        SourceVertexInfo(EdgeProperty edgeProperty) {
            this.edgeProperty = edgeProperty;
        }
    }
}

