/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.tez.dag.app.dag.Vertex;

public class ContainerContext {
    private static final Log LOG = LogFactory.getLog(ContainerContext.class);
    private final Map<String, LocalResource> localResources;
    private final Credentials credentials;
    private final Map<String, String> environment;
    private final String javaOpts;
    private final Vertex vertex;

    public ContainerContext(Map<String, LocalResource> localResources, Credentials credentials, Map<String, String> environment, String javaOpts) {
        Preconditions.checkNotNull(localResources, (Object)"localResources should not be null");
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials should not be null");
        Preconditions.checkNotNull(environment, (Object)"environment should not be null");
        Preconditions.checkNotNull((Object)javaOpts, (Object)"javaOpts should not be null");
        this.localResources = localResources;
        this.credentials = credentials;
        this.environment = environment;
        this.javaOpts = javaOpts;
        this.vertex = null;
    }

    public ContainerContext(Map<String, LocalResource> localResources, Credentials credentials, Map<String, String> environment, String javaOpts, @Nullable Vertex vertex) {
        Preconditions.checkNotNull(localResources, (Object)"localResources should not be null");
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials should not be null");
        Preconditions.checkNotNull(environment, (Object)"environment should not be null");
        Preconditions.checkNotNull((Object)javaOpts, (Object)"javaOpts should not be null");
        this.localResources = localResources;
        this.credentials = credentials;
        this.environment = environment;
        this.javaOpts = javaOpts;
        this.vertex = vertex;
    }

    public Map<String, LocalResource> getLocalResources() {
        return this.localResources;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public String getJavaOpts() {
        return this.javaOpts;
    }

    public boolean isSuperSet(ContainerContext otherContext) {
        Preconditions.checkNotNull((Object)otherContext, (Object)"otherContext should not null");
        if (!this.javaOpts.equals(otherContext.javaOpts)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Incompatible java opts, , this=" + this.javaOpts + ", other=" + otherContext.javaOpts));
            }
            return false;
        }
        return ContainerContext.isSuperSet(this.environment, otherContext.getEnvironment(), "Environment") && ContainerContext.localResourcesCompatible(this.localResources, otherContext.getLocalResources());
    }

    public boolean isExactMatch(ContainerContext otherContext) {
        return this.vertex == otherContext.vertex;
    }

    private static boolean localResourcesCompatible(Map<String, LocalResource> srcLRs, Map<String, LocalResource> reqLRs) {
        HashMap<String, LocalResource> reqLRsCopy = new HashMap<String, LocalResource>(reqLRs);
        for (Map.Entry<String, LocalResource> entry : srcLRs.entrySet()) {
            LocalResource requestedLocalResource = (LocalResource)reqLRsCopy.remove(entry.getKey());
            if (requestedLocalResource == null || entry.getValue().equals(requestedLocalResource)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cannot match container: Attempting to use same target resource name: " + entry.getKey() + ", but with different source resources. Already localized: " + entry.getValue() + ", requested: " + requestedLocalResource));
            }
            return false;
        }
        for (Map.Entry<String, Object> entry : reqLRsCopy.entrySet()) {
            LocalResource lr = (LocalResource)entry.getValue();
            if (!EnumSet.of(LocalResourceType.ARCHIVE, LocalResourceType.PATTERN).contains(lr.getType())) continue;
            return false;
        }
        return true;
    }

    private static <K, V> boolean isSuperSet(Map<K, V> srcMap, Map<K, V> matchMap, String matchInfo) {
        for (Map.Entry<K, V> oEntry : matchMap.entrySet()) {
            K oKey = oEntry.getKey();
            V oVal = oEntry.getValue();
            if (srcMap.containsKey(oKey)) {
                if (oVal.equals(srcMap.get(oKey))) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Incompatible container context, matchInfo=" + matchInfo + ", thisKey=" + oKey + ", thisVal=" + srcMap.get(oKey) + ", otherVal=" + oVal));
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Incompatible container context, matchInfo=" + matchInfo + ", thisKey=" + oKey + ", thisVal=null" + ", otherVal=" + oVal));
            }
            return false;
        }
        return true;
    }
}

