/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.impl.VertexStats;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.history.utils.DAGUtils;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class VertexFinishedEvent
implements HistoryEvent,
SummaryEvent {
    private TezVertexID vertexID;
    private String vertexName;
    private long initRequestedTime;
    private long initedTime;
    private long startRequestedTime;
    private long startTime;
    private long finishTime;
    private VertexState state;
    private String diagnostics;
    private TezCounters tezCounters;
    private boolean fromSummary = false;
    private VertexStats vertexStats;

    public VertexFinishedEvent(TezVertexID vertexId, String vertexName, long initRequestedTime, long initedTime, long startRequestedTime, long startedTime, long finishTime, VertexState state, String diagnostics, TezCounters counters, VertexStats vertexStats) {
        this.vertexName = vertexName;
        this.vertexID = vertexId;
        this.initRequestedTime = initRequestedTime;
        this.initedTime = initedTime;
        this.startRequestedTime = startRequestedTime;
        this.startTime = startedTime;
        this.finishTime = finishTime;
        this.state = state;
        this.diagnostics = diagnostics;
        this.tezCounters = counters;
        this.vertexStats = vertexStats;
    }

    public VertexFinishedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_FINISHED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)this.vertexID.toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        JSONArray events = new JSONArray();
        JSONObject finishEvent = new JSONObject();
        finishEvent.put("ts", this.finishTime);
        finishEvent.put("eventtype", (Object)HistoryEventType.VERTEX_FINISHED.name());
        events.put((Object)finishEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("endTime", this.finishTime);
        otherInfo.put("timeTaken", this.finishTime - this.startTime);
        otherInfo.put("status", (Object)this.state.name());
        otherInfo.put("diagnostics", (Object)this.diagnostics);
        otherInfo.put("counters", (Object)DAGUtils.convertCountersToJSON(this.tezCounters));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.VertexFinishedProto toProto() {
        RecoveryProtos.VertexFinishedProto.Builder builder = RecoveryProtos.VertexFinishedProto.newBuilder();
        builder.setVertexName(this.vertexName).setVertexId(this.vertexID.toString()).setState(this.state.ordinal()).setFinishTime(this.finishTime);
        if (this.diagnostics != null) {
            builder.setDiagnostics(this.diagnostics);
        }
        if (this.tezCounters != null) {
            builder.setCounters(DagTypeConverters.convertTezCountersToProto((TezCounters)this.tezCounters));
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.VertexFinishedProto proto) {
        this.vertexName = proto.getVertexName();
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
        this.finishTime = proto.getFinishTime();
        this.state = VertexState.values()[proto.getState()];
        if (proto.hasDiagnostics()) {
            this.diagnostics = proto.getDiagnostics();
        }
        if (proto.hasCounters()) {
            this.tezCounters = DagTypeConverters.convertTezCountersFromProto((DAGProtos.TezCountersProto)proto.getCounters());
        }
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.VertexFinishedProto proto = RecoveryProtos.VertexFinishedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", vertexId=" + this.vertexID + ", initRequestedTime=" + this.initRequestedTime + ", initedTime=" + this.initedTime + ", startRequestedTime=" + this.startRequestedTime + ", startedTime=" + this.startTime + ", finishTime=" + this.finishTime + ", timeTaken=" + (this.finishTime - this.startTime) + ", status=" + this.state.name() + ", diagnostics=" + this.diagnostics + ", counters=" + (this.tezCounters == null ? "null" : this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " ")) + ", vertexStats=" + (this.vertexStats == null ? "null" : this.vertexStats.toString());
    }

    public TezVertexID getVertexID() {
        return this.vertexID;
    }

    public VertexState getState() {
        return this.state;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public TezCounters getTezCounters() {
        return this.tezCounters;
    }

    @Override
    public void toSummaryProtoStream(OutputStream outputStream) throws IOException {
        RecoveryProtos.VertexFinishStateProto finishStateProto = RecoveryProtos.VertexFinishStateProto.newBuilder().setState(this.state.ordinal()).setVertexId(this.vertexID.toString()).build();
        RecoveryProtos.SummaryEventProto.Builder builder = RecoveryProtos.SummaryEventProto.newBuilder().setDagId(this.vertexID.getDAGId().toString()).setTimestamp(this.finishTime).setEventType(this.getEventType().ordinal()).setEventPayload(finishStateProto.toByteString());
        builder.build().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromSummaryProtoStream(RecoveryProtos.SummaryEventProto proto) throws IOException {
        RecoveryProtos.VertexFinishStateProto finishStateProto = RecoveryProtos.VertexFinishStateProto.parseFrom(proto.getEventPayload());
        this.vertexID = TezVertexID.fromString((String)finishStateProto.getVertexId());
        this.state = VertexState.values()[finishStateProto.getState()];
        this.finishTime = proto.getTimestamp();
        this.fromSummary = true;
    }

    @Override
    public boolean writeToRecoveryImmediately() {
        return false;
    }

    public boolean isFromSummary() {
        return this.fromSummary;
    }
}

