/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.dag.utils.ProtoUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DAGCommitStartedEvent
implements HistoryEvent,
SummaryEvent {
    private TezDAGID dagID;
    private long commitStartTime;

    public DAGCommitStartedEvent() {
    }

    public DAGCommitStartedEvent(TezDAGID dagID, long commitStartTime) {
        this.dagID = dagID;
        this.commitStartTime = commitStartTime;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.DAG_COMMIT_STARTED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        return null;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return false;
    }

    public RecoveryProtos.DAGCommitStartedProto toProto() {
        return RecoveryProtos.DAGCommitStartedProto.newBuilder().setDagId(this.dagID.toString()).build();
    }

    public void fromProto(RecoveryProtos.DAGCommitStartedProto proto) {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.DAGCommitStartedProto proto = RecoveryProtos.DAGCommitStartedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "dagID=" + this.dagID;
    }

    public TezDAGID getDagID() {
        return this.dagID;
    }

    @Override
    public void toSummaryProtoStream(OutputStream outputStream) throws IOException {
        ProtoUtils.toSummaryEventProto(this.dagID, this.commitStartTime, this.getEventType()).writeDelimitedTo(outputStream);
    }

    @Override
    public void fromSummaryProtoStream(RecoveryProtos.SummaryEventProto proto) throws IOException {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.commitStartTime = proto.getTimestamp();
    }

    @Override
    public boolean writeToRecoveryImmediately() {
        return false;
    }
}

