/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.utils;

import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.records.DAGProtos;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DAGUtils {
    public static JSONObject generateSimpleJSONPlan(DAGProtos.DAGPlan dagPlan) throws JSONException {
        String DAG_NAME_KEY = "dagName";
        String VERTICES_KEY = "vertices";
        String EDGES_KEY = "edges";
        String VERTEX_NAME_KEY = "vertexName";
        String PROCESSOR_CLASS_KEY = "processorClass";
        String IN_EDGE_IDS_KEY = "inEdgeIds";
        String OUT_EDGE_IDS_KEY = "outEdgeIds";
        String ADDITIONAL_INPUTS_KEY = "additionalInputs";
        String ADDITIONAL_OUTPUTS_KEY = "additionalOutputs";
        String VERTEX_MANAGER_PLUGIN_CLASS_KEY = "vertexManagerPluginClass";
        String EDGE_ID_KEY = "edgeId";
        String INPUT_VERTEX_NAME_KEY = "inputVertexName";
        String OUTPUT_VERTEX_NAME_KEY = "outputVertexName";
        String DATA_MOVEMENT_TYPE_KEY = "dataMovementType";
        String DATA_SOURCE_TYPE_KEY = "dataSourceType";
        String SCHEDULING_TYPE_KEY = "schedulingType";
        String EDGE_SOURCE_CLASS_KEY = "edgeSourceClass";
        String EDGE_DESTINATION_CLASS_KEY = "edgeDestinationClass";
        String NAME_KEY = "name";
        String CLASS_KEY = "class";
        String INITIALIZER_KEY = "initializer";
        JSONObject dagJson = new JSONObject();
        dagJson.put("dagName", (Object)dagPlan.getName());
        for (DAGProtos.VertexPlan vertexPlan : dagPlan.getVertexList()) {
            JSONObject vertexJson = new JSONObject();
            vertexJson.put("vertexName", (Object)vertexPlan.getName());
            if (vertexPlan.hasProcessorDescriptor()) {
                vertexJson.put("processorClass", (Object)vertexPlan.getProcessorDescriptor().getClassName());
            }
            for (String inEdgeId : vertexPlan.getInEdgeIdList()) {
                vertexJson.accumulate("inEdgeIds", (Object)inEdgeId);
            }
            for (String outEdgeId : vertexPlan.getOutEdgeIdList()) {
                vertexJson.accumulate("outEdgeIds", (Object)outEdgeId);
            }
            for (DAGProtos.RootInputLeafOutputProto input : vertexPlan.getInputsList()) {
                JSONObject jsonInput = new JSONObject();
                jsonInput.put("name", (Object)input.getName());
                jsonInput.put("class", (Object)input.getEntityDescriptor().getClassName());
                if (input.hasInitializerClassName()) {
                    jsonInput.put("initializer", (Object)input.getInitializerClassName());
                }
                vertexJson.accumulate("additionalInputs", (Object)jsonInput);
            }
            for (DAGProtos.RootInputLeafOutputProto output : vertexPlan.getOutputsList()) {
                JSONObject jsonOutput = new JSONObject();
                jsonOutput.put("name", (Object)output.getName());
                jsonOutput.put("class", (Object)output.getEntityDescriptor().getClassName());
                if (output.hasInitializerClassName()) {
                    jsonOutput.put("initializer", (Object)output.getInitializerClassName());
                }
                vertexJson.accumulate("additionalOutputs", (Object)jsonOutput);
            }
            if (vertexPlan.hasVertexManagerPlugin()) {
                vertexJson.put("vertexManagerPluginClass", (Object)vertexPlan.getVertexManagerPlugin().getClassName());
            }
            dagJson.accumulate("vertices", (Object)vertexJson);
        }
        for (DAGProtos.EdgePlan edgePlan : dagPlan.getEdgeList()) {
            JSONObject edgeJson = new JSONObject();
            edgeJson.put("edgeId", (Object)edgePlan.getId());
            edgeJson.put("inputVertexName", (Object)edgePlan.getInputVertexName());
            edgeJson.put("outputVertexName", (Object)edgePlan.getOutputVertexName());
            edgeJson.put("dataMovementType", (Object)edgePlan.getDataMovementType().name());
            edgeJson.put("dataSourceType", (Object)edgePlan.getDataSourceType().name());
            edgeJson.put("schedulingType", (Object)edgePlan.getSchedulingType().name());
            edgeJson.put("edgeSourceClass", (Object)edgePlan.getEdgeSource().getClassName());
            edgeJson.put("edgeDestinationClass", (Object)edgePlan.getEdgeDestination().getClassName());
            dagJson.accumulate("edges", (Object)edgeJson);
        }
        return dagJson;
    }

    public static JSONObject convertCountersToJSON(TezCounters counters) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        if (counters == null) {
            return jsonObject;
        }
        for (CounterGroup group : counters) {
            JSONObject jsonCGrp = new JSONObject();
            jsonCGrp.put("counterGroupName", (Object)group.getName());
            jsonCGrp.put("counterGroupDisplayName", (Object)group.getDisplayName());
            for (TezCounter counter : group) {
                JSONObject counterJson = new JSONObject();
                counterJson.put("counterName", (Object)counter.getName());
                counterJson.put("counterDisplayName", (Object)counter.getDisplayName());
                counterJson.put("counterValue", counter.getValue());
                jsonCGrp.accumulate("counters", (Object)counterJson);
            }
            jsonObject.accumulate("counterGroups", (Object)jsonCGrp);
        }
        return jsonObject;
    }
}

