/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AMStartedEvent
implements HistoryEvent {
    private ApplicationAttemptId applicationAttemptId;
    private long startTime;

    public AMStartedEvent() {
    }

    public AMStartedEvent(ApplicationAttemptId appAttemptId, long startTime) {
        this.applicationAttemptId = appAttemptId;
        this.startTime = startTime;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.AM_STARTED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)("tez_" + this.applicationAttemptId.toString()));
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject appEntity = new JSONObject();
        appEntity.put("entity", (Object)this.applicationAttemptId.getApplicationId().toString());
        appEntity.put("entitytype", (Object)"applicationId");
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)this.applicationAttemptId.toString());
        appAttemptEntity.put("entitytype", (Object)"applicationAttemptId");
        relatedEntities.put((Object)appEntity);
        relatedEntities.put((Object)appAttemptEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", this.startTime);
        startEvent.put("eventtype", (Object)HistoryEventType.AM_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public String toString() {
        return "appAttemptId=" + this.applicationAttemptId + ", startTime=" + this.startTime;
    }

    public RecoveryProtos.AMStartedProto toProto() {
        return RecoveryProtos.AMStartedProto.newBuilder().setApplicationAttemptId(this.applicationAttemptId.toString()).setStartTime(this.startTime).build();
    }

    public void fromProto(RecoveryProtos.AMStartedProto proto) {
        this.applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)proto.getApplicationAttemptId());
        this.startTime = proto.getStartTime();
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.AMStartedProto proto = RecoveryProtos.AMStartedProto.parseDelimitedFrom(inputStream);
        this.fromProto(proto);
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

