/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerImpl;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;

public class AMContainerMap
extends AbstractService
implements EventHandler<AMContainerEvent> {
    private static final Log LOG = LogFactory.getLog(AMContainerMap.class);
    private final ContainerHeartbeatHandler chh;
    private final TaskAttemptListener tal;
    private final AppContext context;
    private final ContainerSignatureMatcher containerSignatureMatcher;
    private final ConcurrentHashMap<ContainerId, AMContainer> containerMap;
    private Set<Integer> profileContainerSet;
    private String commonProfileJavaOpts;

    public AMContainerMap(ContainerHeartbeatHandler chh, TaskAttemptListener tal, ContainerSignatureMatcher containerSignatureMatcher, AppContext context) {
        super("AMContainerMaps");
        this.chh = chh;
        this.tal = tal;
        this.context = context;
        this.containerSignatureMatcher = containerSignatureMatcher;
        this.containerMap = new ConcurrentHashMap();
    }

    public synchronized void serviceInit(Configuration conf) {
        Collection profileContainers = this.getConfig().getTrimmedStringCollection("tez.profile.container.list");
        if (profileContainers != null && !profileContainers.isEmpty()) {
            this.profileContainerSet = new HashSet<Integer>();
            for (String containerNum : profileContainers) {
                this.profileContainerSet.add(Integer.parseInt(containerNum));
            }
            this.commonProfileJavaOpts = conf.get("tez.profile.jvm.opts");
            if (!this.profileContainerSet.isEmpty() && (this.commonProfileJavaOpts == null || this.commonProfileJavaOpts.isEmpty())) {
                LOG.warn((Object)("Profiling specified for " + this.profileContainerSet.size() + " containers, but no profiling string specified. " + "tez.profile.jvm.opts" + " needs to be set"));
            }
            LOG.info((Object)("Containers to be profile: " + this.profileContainerSet));
        }
    }

    public void handle(AMContainerEvent event) {
        AMContainer container = this.containerMap.get(event.getContainerId());
        if (container != null) {
            container.handle((Event)event);
        } else {
            LOG.info((Object)("Event for unknown container: " + event.getContainerId()));
        }
    }

    public boolean addContainerIfNew(Container container) {
        boolean shouldProfile = this.profileContainerSet == null ? false : this.profileContainerSet.contains(container.getId().getId());
        AMContainerImpl amc = new AMContainerImpl(container, this.chh, this.tal, this.containerSignatureMatcher, shouldProfile, shouldProfile ? this.commonProfileJavaOpts : null, this.context);
        return this.containerMap.putIfAbsent(container.getId(), amc) == null;
    }

    public AMContainer get(ContainerId containerId) {
        return this.containerMap.get(containerId);
    }

    public Collection<AMContainer> values() {
        return this.containerMap.values();
    }
}

