/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.rm.TaskScheduler;

class TaskSchedulerAppCallbackWrapper
implements TaskScheduler.TaskSchedulerAppCallback {
    private TaskScheduler.TaskSchedulerAppCallback real;
    ExecutorService executorService;

    public TaskSchedulerAppCallbackWrapper(TaskScheduler.TaskSchedulerAppCallback real, ExecutorService executorService) {
        this.real = real;
        this.executorService = executorService;
    }

    @Override
    public void taskAllocated(Object task, Object appCookie, Container container) {
        this.executorService.submit(new TaskAllocatedCallable(this.real, task, appCookie, container));
    }

    @Override
    public void containerCompleted(Object taskLastAllocated, ContainerStatus containerStatus) {
        this.executorService.submit(new ContainerCompletedCallable(this.real, taskLastAllocated, containerStatus));
    }

    @Override
    public void containerBeingReleased(ContainerId containerId) {
        this.executorService.submit(new ContainerBeingReleasedCallable(this.real, containerId));
    }

    @Override
    public void nodesUpdated(List<NodeReport> updatedNodes) {
        this.executorService.submit(new NodesUpdatedCallable(this.real, updatedNodes));
    }

    @Override
    public void appShutdownRequested() {
        this.executorService.submit(new AppShudownRequestedCallable(this.real));
    }

    @Override
    public void setApplicationRegistrationData(Resource maxContainerCapability, Map<ApplicationAccessType, String> appAcls, ByteBuffer key) {
        this.executorService.submit(new SetApplicationRegistrationDataCallable(this.real, maxContainerCapability, appAcls, key));
    }

    @Override
    public void onError(Throwable t) {
        this.executorService.submit(new OnErrorCallable(this.real, t));
    }

    @Override
    public float getProgress() {
        Future<Float> progressFuture = this.executorService.submit(new GetProgressCallable(this.real));
        try {
            return progressFuture.get().floatValue();
        }
        catch (Exception e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    @Override
    public void preemptContainer(ContainerId containerId) {
        this.executorService.submit(new PreemptContainerCallable(this.real, containerId));
    }

    @Override
    public TaskScheduler.TaskSchedulerAppCallback.AppFinalStatus getFinalAppStatus() {
        Future<TaskScheduler.TaskSchedulerAppCallback.AppFinalStatus> appFinalStatusFuture = this.executorService.submit(new GetFinalAppStatusCallable(this.real));
        try {
            return appFinalStatusFuture.get();
        }
        catch (Exception e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    static class GetFinalAppStatusCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<TaskScheduler.TaskSchedulerAppCallback.AppFinalStatus> {
        public GetFinalAppStatusCallable(TaskScheduler.TaskSchedulerAppCallback app) {
            super(app);
        }

        @Override
        public TaskScheduler.TaskSchedulerAppCallback.AppFinalStatus call() throws Exception {
            return this.app.getFinalAppStatus();
        }
    }

    static class GetProgressCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Float> {
        public GetProgressCallable(TaskScheduler.TaskSchedulerAppCallback app) {
            super(app);
        }

        @Override
        public Float call() throws Exception {
            return Float.valueOf(this.app.getProgress());
        }
    }

    static class PreemptContainerCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        private final ContainerId containerId;

        public PreemptContainerCallable(TaskScheduler.TaskSchedulerAppCallback app, ContainerId id) {
            super(app);
            this.containerId = id;
        }

        @Override
        public Void call() throws Exception {
            this.app.preemptContainer(this.containerId);
            return null;
        }
    }

    static class OnErrorCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        private final Throwable throwable;

        public OnErrorCallable(TaskScheduler.TaskSchedulerAppCallback app, Throwable throwable) {
            super(app);
            this.throwable = throwable;
        }

        @Override
        public Void call() throws Exception {
            this.app.onError(this.throwable);
            return null;
        }
    }

    static class SetApplicationRegistrationDataCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        private final Resource maxContainerCapability;
        private final Map<ApplicationAccessType, String> appAcls;
        private final ByteBuffer key;

        public SetApplicationRegistrationDataCallable(TaskScheduler.TaskSchedulerAppCallback app, Resource maxContainerCapability, Map<ApplicationAccessType, String> appAcls, ByteBuffer key) {
            super(app);
            this.maxContainerCapability = maxContainerCapability;
            this.appAcls = appAcls;
            this.key = key;
        }

        @Override
        public Void call() throws Exception {
            this.app.setApplicationRegistrationData(this.maxContainerCapability, this.appAcls, this.key);
            return null;
        }
    }

    static class AppShudownRequestedCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        public AppShudownRequestedCallable(TaskScheduler.TaskSchedulerAppCallback app) {
            super(app);
        }

        @Override
        public Void call() throws Exception {
            this.app.appShutdownRequested();
            return null;
        }
    }

    static class NodesUpdatedCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        private final List<NodeReport> updatedNodes;

        public NodesUpdatedCallable(TaskScheduler.TaskSchedulerAppCallback app, List<NodeReport> updatedNodes) {
            super(app);
            this.updatedNodes = updatedNodes;
        }

        @Override
        public Void call() throws Exception {
            this.app.nodesUpdated(this.updatedNodes);
            return null;
        }
    }

    static class ContainerBeingReleasedCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        private final ContainerId containerId;

        public ContainerBeingReleasedCallable(TaskScheduler.TaskSchedulerAppCallback app, ContainerId containerId) {
            super(app);
            this.containerId = containerId;
        }

        @Override
        public Void call() throws Exception {
            this.app.containerBeingReleased(this.containerId);
            return null;
        }
    }

    static class ContainerCompletedCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        private final Object taskLastAllocated;
        private final ContainerStatus containerStatus;

        public ContainerCompletedCallable(TaskScheduler.TaskSchedulerAppCallback app, Object taskLastAllocated, ContainerStatus containerStatus) {
            super(app);
            this.taskLastAllocated = taskLastAllocated;
            this.containerStatus = containerStatus;
        }

        @Override
        public Void call() throws Exception {
            this.app.containerCompleted(this.taskLastAllocated, this.containerStatus);
            return null;
        }
    }

    static class TaskAllocatedCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        private final Object task;
        private final Object appCookie;
        private final Container container;

        public TaskAllocatedCallable(TaskScheduler.TaskSchedulerAppCallback app, Object task, Object appCookie, Container container) {
            super(app);
            this.task = task;
            this.appCookie = appCookie;
            this.container = container;
        }

        @Override
        public Void call() throws Exception {
            this.app.taskAllocated(this.task, this.appCookie, this.container);
            return null;
        }
    }

    static abstract class TaskSchedulerAppCallbackBase {
        protected TaskScheduler.TaskSchedulerAppCallback app;

        public TaskSchedulerAppCallbackBase(TaskScheduler.TaskSchedulerAppCallback app) {
            this.app = app;
        }
    }
}

