/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class VertexCommitStartedEvent
implements HistoryEvent,
SummaryEvent {
    private TezVertexID vertexID;
    private long commitStartTime;

    public VertexCommitStartedEvent() {
    }

    public VertexCommitStartedEvent(TezVertexID vertexId, long commitStartTime) {
        this.vertexID = vertexId;
        this.commitStartTime = commitStartTime;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_COMMIT_STARTED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        return null;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return false;
    }

    public RecoveryProtos.VertexCommitStartedProto toProto() {
        return RecoveryProtos.VertexCommitStartedProto.newBuilder().setVertexId(this.vertexID.toString()).build();
    }

    public void fromProto(RecoveryProtos.VertexCommitStartedProto proto) {
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.VertexCommitStartedProto proto = RecoveryProtos.VertexCommitStartedProto.parseDelimitedFrom(inputStream);
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexId=" + this.vertexID;
    }

    public TezVertexID getVertexID() {
        return this.vertexID;
    }

    @Override
    public void toSummaryProtoStream(OutputStream outputStream) throws IOException {
        RecoveryProtos.SummaryEventProto.Builder builder = RecoveryProtos.SummaryEventProto.newBuilder().setDagId(this.vertexID.getDAGId().toString()).setTimestamp(this.commitStartTime).setEventType(this.getEventType().ordinal()).setEventPayload(ByteString.copyFrom((byte[])this.vertexID.toString().getBytes()));
        builder.build().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromSummaryProtoStream(RecoveryProtos.SummaryEventProto proto) throws IOException {
        this.vertexID = TezVertexID.fromString((String)new String(proto.getEventPayload().toByteArray()));
        this.commitStartTime = proto.getTimestamp();
    }

    @Override
    public boolean writeToRecoveryImmediately() {
        return false;
    }
}

