/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DAGInitializedEvent
implements HistoryEvent {
    private TezDAGID dagID;
    private long initTime;

    public DAGInitializedEvent() {
    }

    public DAGInitializedEvent(TezDAGID dagID, long initTime) {
        this.dagID = dagID;
        this.initTime = initTime;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.DAG_INITIALIZED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public String toString() {
        return "dagID=" + this.dagID + ", initTime=" + this.initTime;
    }

    public RecoveryProtos.DAGInitializedProto toProto() {
        return RecoveryProtos.DAGInitializedProto.newBuilder().setDagId(this.dagID.toString()).setInitTime(this.initTime).build();
    }

    public void fromProto(RecoveryProtos.DAGInitializedProto proto) {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.initTime = proto.getInitTime();
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.DAGInitializedProto proto = RecoveryProtos.DAGInitializedProto.parseDelimitedFrom(inputStream);
        this.fromProto(proto);
    }

    public long getInitTime() {
        return this.initTime;
    }

    public TezDAGID getDagID() {
        return this.dagID;
    }
}

