/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ContainerLaunchedEvent
implements HistoryEvent {
    private ContainerId containerId;
    private long launchTime;
    private ApplicationAttemptId applicationAttemptId;

    public ContainerLaunchedEvent() {
    }

    public ContainerLaunchedEvent(ContainerId containerId, long launchTime, ApplicationAttemptId applicationAttemptId) {
        this.containerId = containerId;
        this.launchTime = launchTime;
        this.applicationAttemptId = applicationAttemptId;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.CONTAINER_LAUNCHED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)("tez_" + this.containerId.toString()));
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_CONTAINER_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)this.applicationAttemptId.toString());
        appAttemptEntity.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONObject containerEntity = new JSONObject();
        containerEntity.put("entity", (Object)this.containerId.toString());
        containerEntity.put("entitytype", (Object)"containerId");
        relatedEntities.put((Object)appAttemptEntity);
        relatedEntities.put((Object)containerEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject launchEvent = new JSONObject();
        launchEvent.put("ts", this.launchTime);
        launchEvent.put("eventtype", (Object)HistoryEventType.CONTAINER_LAUNCHED.name());
        events.put((Object)launchEvent);
        jsonObject.put("events", (Object)events);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return false;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.ContainerLaunchedProto toProto() {
        return RecoveryProtos.ContainerLaunchedProto.newBuilder().setApplicationAttemptId(this.applicationAttemptId.toString()).setContainerId(this.containerId.toString()).setLaunchTime(this.launchTime).build();
    }

    public void fromProto(RecoveryProtos.ContainerLaunchedProto proto) {
        this.containerId = ConverterUtils.toContainerId((String)proto.getContainerId());
        this.launchTime = proto.getLaunchTime();
        this.applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)proto.getApplicationAttemptId());
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.ContainerLaunchedProto proto = RecoveryProtos.ContainerLaunchedProto.parseDelimitedFrom(inputStream);
        this.fromProto(proto);
    }

    public String toString() {
        return "containerId=" + this.containerId + ", launchTime=" + this.launchTime;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public long getLaunchTime() {
        return this.launchTime;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }
}

