/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.recovery;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.events.AMLaunchedEvent;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexDataMovementEventsGeneratedEvent;
import org.apache.tez.dag.history.events.VertexFinishedEvent;
import org.apache.tez.dag.history.events.VertexInitializedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class RecoveryParser {
    private static final Log LOG = LogFactory.getLog(RecoveryParser.class);
    Path recoveryDirectory;
    FileSystem recoveryDirFS;

    public RecoveryParser(Path recoveryDirectory, Configuration conf) throws IOException {
        this.recoveryDirectory = recoveryDirectory;
        this.recoveryDirFS = FileSystem.get((URI)recoveryDirectory.toUri(), (Configuration)conf);
    }

    public void parse() throws IOException {
        RemoteIterator locatedFilesStatus = this.recoveryDirFS.listFiles(this.recoveryDirectory, false);
        while (locatedFilesStatus.hasNext()) {
            FSDataInputStream inputStream;
            LocatedFileStatus fileStatus = (LocatedFileStatus)locatedFilesStatus.next();
            String fileName = fileStatus.getPath().getName();
            if (fileName.endsWith(".recovery")) {
                inputStream = this.recoveryDirFS.open(fileStatus.getPath());
                LOG.info((Object)("Parsing DAG file " + fileName));
                this.parseDAGRecoveryFile(inputStream);
                continue;
            }
            if (fileName.endsWith(".summary")) {
                inputStream = this.recoveryDirFS.open(fileStatus.getPath());
                LOG.info((Object)("Parsing Summary file " + fileName));
                this.parseSummaryFile(inputStream);
                continue;
            }
            LOG.warn((Object)("Encountered unknown file in recovery dir, fileName=" + fileName));
        }
    }

    private void parseSummaryFile(FSDataInputStream inputStream) throws IOException {
        boolean counter = false;
        while (inputStream.available() > 0) {
            RecoveryProtos.SummaryEventProto proto = RecoveryProtos.SummaryEventProto.parseDelimitedFrom((InputStream)inputStream);
            LOG.info((Object)("[SUMMARY] dagId=" + proto.getDagId() + ", timestamp=" + proto.getTimestamp() + ", event=" + (Object)((Object)HistoryEventType.values()[proto.getEventType()])));
        }
    }

    private void parseDAGRecoveryFile(FSDataInputStream inputStream) throws IOException {
        int counter = 0;
        while (inputStream.available() > 0) {
            int eventTypeOrdinal = inputStream.read();
            if (eventTypeOrdinal < 0 || eventTypeOrdinal >= HistoryEventType.values().length) {
                LOG.warn((Object)"Corrupt data found when trying to read next event type");
                break;
            }
            HistoryEventType eventType = HistoryEventType.values()[eventTypeOrdinal];
            HistoryEvent event = null;
            switch (eventType) {
                case AM_LAUNCHED: {
                    event = new AMLaunchedEvent();
                    break;
                }
                case AM_STARTED: {
                    event = new AMStartedEvent();
                    break;
                }
                case DAG_SUBMITTED: {
                    event = new DAGSubmittedEvent();
                    break;
                }
                case DAG_INITIALIZED: {
                    event = new DAGInitializedEvent();
                    break;
                }
                case DAG_STARTED: {
                    event = new DAGStartedEvent();
                    break;
                }
                case DAG_FINISHED: {
                    event = new DAGFinishedEvent();
                    break;
                }
                case CONTAINER_LAUNCHED: {
                    event = new ContainerLaunchedEvent();
                    break;
                }
                case VERTEX_INITIALIZED: {
                    event = new VertexInitializedEvent();
                    break;
                }
                case VERTEX_STARTED: {
                    event = new VertexStartedEvent();
                    break;
                }
                case VERTEX_FINISHED: {
                    event = new VertexFinishedEvent();
                    break;
                }
                case TASK_STARTED: {
                    event = new TaskStartedEvent();
                    break;
                }
                case TASK_FINISHED: {
                    event = new TaskFinishedEvent();
                    break;
                }
                case TASK_ATTEMPT_STARTED: {
                    event = new TaskAttemptStartedEvent();
                    break;
                }
                case TASK_ATTEMPT_FINISHED: {
                    event = new TaskAttemptFinishedEvent();
                    break;
                }
                case VERTEX_DATA_MOVEMENT_EVENTS_GENERATED: {
                    event = new VertexDataMovementEventsGeneratedEvent();
                    break;
                }
                default: {
                    throw new IOException("Invalid data found, unknown event type " + (Object)((Object)eventType));
                }
            }
            LOG.info((Object)("Parsing event from input stream, eventType=" + (Object)((Object)eventType) + ", eventIndex=" + ++counter));
            event.fromProtoStream((InputStream)inputStream);
            LOG.info((Object)("Parsed event from input stream, eventType=" + (Object)((Object)eventType) + ", eventIndex=" + counter + ", event=" + event.toString()));
        }
    }

    public static void main(String[] argv) throws IOException {
        Configuration conf = new Configuration();
        String dir = argv[0];
        RecoveryParser parser = new RecoveryParser(new Path(dir), conf);
        parser.parse();
    }
}

