/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.history.utils.DAGUtils;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.dag.utils.ProtoUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DAGFinishedEvent
implements HistoryEvent,
SummaryEvent {
    private TezDAGID dagID;
    private long startTime;
    private long finishTime;
    private DAGStatus.State state;
    private String diagnostics;
    private TezCounters tezCounters;

    public DAGFinishedEvent() {
    }

    public DAGFinishedEvent(TezDAGID dagId, long startTime, long finishTime, DAGStatus.State state, String diagnostics, TezCounters counters) {
        this.dagID = dagId;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.state = state;
        this.diagnostics = diagnostics;
        this.tezCounters = counters;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.DAG_FINISHED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)this.dagID.toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        JSONArray events = new JSONArray();
        JSONObject finishEvent = new JSONObject();
        finishEvent.put("ts", this.finishTime);
        finishEvent.put("eventtype", (Object)HistoryEventType.DAG_FINISHED.name());
        events.put((Object)finishEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("startTime", this.startTime);
        otherInfo.put("endTime", this.finishTime);
        otherInfo.put("timeTaken", this.finishTime - this.startTime);
        otherInfo.put("status", (Object)this.state.name());
        otherInfo.put("diagnostics", (Object)this.diagnostics);
        otherInfo.put("counters", (Object)DAGUtils.convertCountersToJSON(this.tezCounters));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.DAGFinishedProto toProto() {
        return RecoveryProtos.DAGFinishedProto.newBuilder().setDagId(this.dagID.toString()).setState(this.state.ordinal()).setDiagnostics(this.diagnostics).setFinishTime(this.finishTime).setCounters(DagTypeConverters.convertTezCountersToProto((TezCounters)this.tezCounters)).build();
    }

    public void fromProto(RecoveryProtos.DAGFinishedProto proto) {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.finishTime = proto.getFinishTime();
        this.state = DAGStatus.State.values()[proto.getState()];
        this.diagnostics = proto.getDiagnostics();
        this.tezCounters = DagTypeConverters.convertTezCountersFromProto((DAGProtos.TezCountersProto)proto.getCounters());
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.DAGFinishedProto proto = RecoveryProtos.DAGFinishedProto.parseDelimitedFrom(inputStream);
        this.fromProto(proto);
    }

    public String toString() {
        return "dagId=" + this.dagID + ", startTime=" + this.startTime + ", finishTime=" + this.finishTime + ", timeTaken=" + (this.finishTime - this.startTime) + ", status=" + this.state.name() + ", diagnostics=" + this.diagnostics + ", counters=" + this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " ");
    }

    @Override
    public void toSummaryProtoStream(OutputStream outputStream) throws IOException {
        ProtoUtils.toSummaryEventProto(this.dagID, this.finishTime, HistoryEventType.DAG_FINISHED).writeDelimitedTo(outputStream);
    }
}

