/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.speculate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventStatusUpdate;
import org.apache.tez.dag.app.speculate.DataStatistics;
import org.apache.tez.dag.app.speculate.TaskRuntimeEstimator;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class StartEndTimesBase<V>
implements TaskRuntimeEstimator {
    static final float MINIMUM_COMPLETE_PROPORTION_TO_SPECULATE = 0.05f;
    static final int MINIMUM_COMPLETE_NUMBER_TO_SPECULATE = 1;
    protected Configuration conf = null;
    protected AppContext context = null;
    protected final Map<TezTaskAttemptID, Long> startTimes = new ConcurrentHashMap<TezTaskAttemptID, Long>();
    protected final Map<TezVertexID, DataStatistics> vertexStatistics = new HashMap<TezVertexID, DataStatistics>();
    private float slowTaskRelativeTresholds = 0.0f;
    protected final Set<Task> doneTasks = new HashSet<Task>();

    StartEndTimesBase() {
    }

    @Override
    public void enrollAttempt(TaskAttemptEventStatusUpdate.TaskAttemptStatusOld status, long timestamp) {
        this.startTimes.put(status.id, timestamp);
    }

    @Override
    public long attemptEnrolledTime(TezTaskAttemptID attemptID) {
        Long result = this.startTimes.get(attemptID);
        return result == null ? Long.MAX_VALUE : result;
    }

    @Override
    public void contextualize(Configuration conf, AppContext context) {
        this.conf = conf;
        this.context = context;
        DAG dag = context.getCurrentDAG();
        for (Map.Entry<TezVertexID, Vertex> entry : dag.getVertices().entrySet()) {
            this.vertexStatistics.put(entry.getKey(), new DataStatistics());
            this.slowTaskRelativeTresholds = conf.getFloat("mapreduce.job.speculative.slowtaskthreshold", 1.0f);
        }
    }

    protected DataStatistics dataStatisticsForTask(TezTaskID taskID) {
        DAG dag = this.context.getCurrentDAG();
        if (dag == null) {
            return null;
        }
        Task task = dag.getVertex(taskID.getVertexID()).getTask(taskID);
        if (task == null) {
            return null;
        }
        return this.vertexStatistics.get(taskID.getVertexID());
    }

    @Override
    public long thresholdRuntime(TezTaskID taskID) {
        DAG job = this.context.getCurrentDAG();
        DataStatistics statistics = this.dataStatisticsForTask(taskID);
        Vertex v = job.getVertex(taskID.getVertexID());
        int completedTasksOfType = v.getCompletedTasks();
        int totalTasksOfType = v.getTotalTasks();
        if (completedTasksOfType < 1 || (float)completedTasksOfType / (float)totalTasksOfType < 0.05f) {
            return Long.MAX_VALUE;
        }
        long result = statistics == null ? Long.MAX_VALUE : (long)statistics.outlier(this.slowTaskRelativeTresholds);
        return result;
    }

    @Override
    public long estimatedNewAttemptRuntime(TezTaskID id) {
        DataStatistics statistics = this.dataStatisticsForTask(id);
        if (statistics == null) {
            return -1L;
        }
        return (long)statistics.mean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAttempt(TaskAttemptEventStatusUpdate.TaskAttemptStatusOld status, long timestamp) {
        TezTaskAttemptID attemptID = status.id;
        TezTaskID taskID = attemptID.getTaskID();
        DAG job = this.context.getCurrentDAG();
        if (job == null) {
            return;
        }
        Task task = job.getVertex(taskID.getVertexID()).getTask(taskID);
        if (task == null) {
            return;
        }
        Long boxedStart = this.startTimes.get(attemptID);
        long start = boxedStart == null ? Long.MIN_VALUE : boxedStart;
        TaskAttempt taskAttempt = task.getAttempt(attemptID);
        if (taskAttempt.getState() == TaskAttemptState.SUCCEEDED) {
            boolean isNew = false;
            Set<Task> set = this.doneTasks;
            synchronized (set) {
                if (!this.doneTasks.contains(task)) {
                    this.doneTasks.add(task);
                    isNew = true;
                }
            }
            if (isNew) {
                long finish = timestamp;
                if (start > 1L && finish > 1L && start <= finish) {
                    long duration = finish - start;
                    DataStatistics statistics = this.dataStatisticsForTask(taskID);
                    if (statistics != null) {
                        statistics.add(duration);
                    }
                }
            }
        }
    }
}

