/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.speculate;

import org.apache.hadoop.yarn.event.AbstractEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventStatusUpdate;
import org.apache.tez.dag.app.speculate.Speculator;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeculatorEvent
extends AbstractEvent<Speculator.EventType> {
    private TaskAttemptEventStatusUpdate.TaskAttemptStatusOld reportedStatus;
    private TezTaskID taskID;
    private int containersNeededChange;
    private TezDAGID dagId;

    public SpeculatorEvent(TezDAGID dagId, long timestamp) {
        super((Enum)Speculator.EventType.JOB_CREATE, timestamp);
        this.dagId = dagId;
    }

    public SpeculatorEvent(TaskAttemptEventStatusUpdate.TaskAttemptStatusOld reportedStatus, long timestamp) {
        super((Enum)Speculator.EventType.ATTEMPT_STATUS_UPDATE, timestamp);
        this.reportedStatus = reportedStatus;
    }

    public SpeculatorEvent(TezTaskAttemptID attemptID, boolean flag, long timestamp) {
        super((Enum)Speculator.EventType.ATTEMPT_START, timestamp);
        this.reportedStatus = new TaskAttemptEventStatusUpdate.TaskAttemptStatusOld();
        this.reportedStatus.id = attemptID;
        this.taskID = attemptID.getTaskID();
    }

    public SpeculatorEvent(TezTaskID taskID, int containersNeededChange) {
        super((Enum)Speculator.EventType.TASK_CONTAINER_NEED_UPDATE);
        this.taskID = taskID;
        this.containersNeededChange = containersNeededChange;
    }

    public TaskAttemptEventStatusUpdate.TaskAttemptStatusOld getReportedStatus() {
        return this.reportedStatus;
    }

    public int containersNeededChange() {
        return this.containersNeededChange;
    }

    public TezTaskID getTaskID() {
        return this.taskID;
    }

    public TezDAGID getJobID() {
        return this.dagId;
    }
}

