/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.rm.TaskScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskSchedulerAppCallbackWrapper
implements TaskScheduler.TaskSchedulerAppCallback {
    private TaskScheduler.TaskSchedulerAppCallback real;
    @VisibleForTesting
    CompletionService completionService;
    ExecutorService executorService;

    public TaskSchedulerAppCallbackWrapper(TaskScheduler.TaskSchedulerAppCallback real, ExecutorService executorService) {
        this.real = real;
        this.executorService = executorService;
        this.completionService = this.craeteAppCallbackCompletionService();
    }

    @VisibleForTesting
    CompletionService craeteAppCallbackCompletionService() {
        return new ExecutorCompletionService(this.executorService);
    }

    @Override
    public void taskAllocated(Object task, Object appCookie, Container container) {
        this.completionService.submit(new TaskAllocatedCallable(this.real, task, appCookie, container));
    }

    @Override
    public void containerCompleted(Object taskLastAllocated, ContainerStatus containerStatus) {
        this.completionService.submit(new ContainerCompletedCallable(this.real, taskLastAllocated, containerStatus));
    }

    @Override
    public void containerBeingReleased(ContainerId containerId) {
        this.completionService.submit(new ContainerBeingReleasedCallable(this.real, containerId));
    }

    @Override
    public void nodesUpdated(List<NodeReport> updatedNodes) {
        this.completionService.submit(new NodesUpdatedCallable(this.real, updatedNodes));
    }

    @Override
    public void appShutdownRequested() {
        this.completionService.submit(new AppShudownRequestedCallable(this.real));
    }

    @Override
    public void setApplicationRegistrationData(Resource maxContainerCapability, Map<ApplicationAccessType, String> appAcls, ByteBuffer key) {
        this.completionService.submit(new SetApplicationRegistrationDataCallable(this.real, maxContainerCapability, appAcls, key));
    }

    @Override
    public void onError(Throwable t) {
        this.completionService.submit(new OnErrorCallable(this.real, t));
    }

    @Override
    public float getProgress() {
        Future<Float> progressFuture = this.completionService.submit(new GetProgressCallable(this.real));
        try {
            return progressFuture.get().floatValue();
        }
        catch (Exception e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    @Override
    public TaskScheduler.TaskSchedulerAppCallback.AppFinalStatus getFinalAppStatus() {
        Future<TaskScheduler.TaskSchedulerAppCallback.AppFinalStatus> appFinalStatusFuture = this.completionService.submit(new GetFinalAppStatusCallable(this.real));
        try {
            return appFinalStatusFuture.get();
        }
        catch (Exception e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GetFinalAppStatusCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<TaskScheduler.TaskSchedulerAppCallback.AppFinalStatus> {
        public GetFinalAppStatusCallable(TaskScheduler.TaskSchedulerAppCallback app) {
            super(app);
        }

        @Override
        public TaskScheduler.TaskSchedulerAppCallback.AppFinalStatus call() throws Exception {
            return this.app.getFinalAppStatus();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GetProgressCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Float> {
        public GetProgressCallable(TaskScheduler.TaskSchedulerAppCallback app) {
            super(app);
        }

        @Override
        public Float call() throws Exception {
            return Float.valueOf(this.app.getProgress());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OnErrorCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        private final Throwable throwable;

        public OnErrorCallable(TaskScheduler.TaskSchedulerAppCallback app, Throwable throwable) {
            super(app);
            this.throwable = throwable;
        }

        @Override
        public Void call() throws Exception {
            this.app.onError(this.throwable);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SetApplicationRegistrationDataCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        private final Resource maxContainerCapability;
        private final Map<ApplicationAccessType, String> appAcls;
        private final ByteBuffer key;

        public SetApplicationRegistrationDataCallable(TaskScheduler.TaskSchedulerAppCallback app, Resource maxContainerCapability, Map<ApplicationAccessType, String> appAcls, ByteBuffer key) {
            super(app);
            this.maxContainerCapability = maxContainerCapability;
            this.appAcls = appAcls;
            this.key = key;
        }

        @Override
        public Void call() throws Exception {
            this.app.setApplicationRegistrationData(this.maxContainerCapability, this.appAcls, this.key);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AppShudownRequestedCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        public AppShudownRequestedCallable(TaskScheduler.TaskSchedulerAppCallback app) {
            super(app);
        }

        @Override
        public Void call() throws Exception {
            this.app.appShutdownRequested();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NodesUpdatedCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        private final List<NodeReport> updatedNodes;

        public NodesUpdatedCallable(TaskScheduler.TaskSchedulerAppCallback app, List<NodeReport> updatedNodes) {
            super(app);
            this.updatedNodes = updatedNodes;
        }

        @Override
        public Void call() throws Exception {
            this.app.nodesUpdated(this.updatedNodes);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContainerBeingReleasedCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        private final ContainerId containerId;

        public ContainerBeingReleasedCallable(TaskScheduler.TaskSchedulerAppCallback app, ContainerId containerId) {
            super(app);
            this.containerId = containerId;
        }

        @Override
        public Void call() throws Exception {
            this.app.containerBeingReleased(this.containerId);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContainerCompletedCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        private final Object taskLastAllocated;
        private final ContainerStatus containerStatus;

        public ContainerCompletedCallable(TaskScheduler.TaskSchedulerAppCallback app, Object taskLastAllocated, ContainerStatus containerStatus) {
            super(app);
            this.taskLastAllocated = taskLastAllocated;
            this.containerStatus = containerStatus;
        }

        @Override
        public Void call() throws Exception {
            this.app.containerCompleted(this.taskLastAllocated, this.containerStatus);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TaskAllocatedCallable
    extends TaskSchedulerAppCallbackBase
    implements Callable<Void> {
        private final Object task;
        private final Object appCookie;
        private final Container container;

        public TaskAllocatedCallable(TaskScheduler.TaskSchedulerAppCallback app, Object task, Object appCookie, Container container) {
            super(app);
            this.task = task;
            this.appCookie = appCookie;
            this.container = container;
        }

        @Override
        public Void call() throws Exception {
            this.app.taskAllocated(this.task, this.appCookie, this.container);
            return null;
        }
    }

    static abstract class TaskSchedulerAppCallbackBase {
        protected TaskScheduler.TaskSchedulerAppCallback app;

        public TaskSchedulerAppCallbackBase(TaskScheduler.TaskSchedulerAppCallback app) {
            this.app = app;
        }
    }
}

