/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.client.TezSessionStatus;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DAGClientServer;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.client.VertexStatusBuilder;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ClusterInfo;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.DAGAppMasterState;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskAttemptListenerImpTezDag;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEvent;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventDAGFinished;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventType;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.dag.event.VertexEvent;
import org.apache.tez.dag.app.dag.event.VertexEventType;
import org.apache.tez.dag.app.dag.impl.DAGImpl;
import org.apache.tez.dag.app.launcher.ContainerLauncher;
import org.apache.tez.dag.app.launcher.ContainerLauncherImpl;
import org.apache.tez.dag.app.rm.AMSchedulerEventType;
import org.apache.tez.dag.app.rm.NMCommunicatorEventType;
import org.apache.tez.dag.app.rm.TaskSchedulerEventHandler;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.node.AMNodeEventType;
import org.apache.tez.dag.app.rm.node.AMNodeMap;
import org.apache.tez.dag.app.taskclean.TaskCleaner;
import org.apache.tez.dag.app.taskclean.TaskCleanerImpl;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.history.avro.HistoryEventType;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.runtime.library.common.security.JobTokenIdentifier;
import org.apache.tez.runtime.library.common.security.JobTokenSecretManager;
import org.apache.tez.runtime.library.common.security.TokenCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAGAppMaster
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(DAGAppMaster.class);
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private Clock clock;
    private final boolean isSession;
    private long appsStartTime;
    private final long startTime;
    private final long appSubmitTime;
    private String appName;
    private final ApplicationAttemptId appAttemptID;
    private final ContainerId containerID;
    private final String nmHost;
    private final int nmPort;
    private final int nmHttpPort;
    private AMContainerMap containers;
    private AMNodeMap nodes;
    private AppContext context;
    private Configuration amConf;
    private Dispatcher dispatcher;
    private ContainerLauncher containerLauncher;
    private TaskCleaner taskCleaner;
    private ContainerHeartbeatHandler containerHeartbeatHandler;
    private TaskHeartbeatHandler taskHeartbeatHandler;
    private TaskAttemptListener taskAttemptListener;
    private JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    private Token<JobTokenIdentifier> sessionToken;
    private DagEventDispatcher dagEventDispatcher;
    private VertexEventDispatcher vertexEventDispatcher;
    private TaskSchedulerEventHandler taskSchedulerEventHandler;
    private HistoryEventHandler historyEventHandler;
    private final Map<String, LocalResource> sessionResources = new HashMap<String, LocalResource>();
    private DAGAppMasterShutdownHandler shutdownHandler = new DAGAppMasterShutdownHandler();
    private DAGAppMasterState state;
    DAGClientServer clientRpcServer;
    private DAGClientHandler clientHandler;
    private DAG currentDAG;
    private Credentials tokens = new Credentials();
    private UserGroupInformation currentUser;
    private AtomicBoolean sessionStopped = new AtomicBoolean(false);
    private long sessionTimeoutInterval;
    private long lastDAGCompletionTime;
    private Timer dagSubmissionTimer;
    private final AtomicInteger dagCounter = new AtomicInteger();
    private final AtomicInteger submittedDAGs = new AtomicInteger();
    private final AtomicInteger successfulDAGs = new AtomicInteger();
    private final AtomicInteger failedDAGs = new AtomicInteger();
    private final AtomicInteger killedDAGs = new AtomicInteger();
    Map<Service, ServiceWithDependency> services = new LinkedHashMap<Service, ServiceWithDependency>();

    public DAGAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, long appSubmitTime, boolean isSession) {
        this(applicationAttemptId, containerId, nmHost, nmPort, nmHttpPort, (Clock)new SystemClock(), appSubmitTime, isSession);
    }

    public DAGAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, Clock clock, long appSubmitTime, boolean isSession) {
        super(DAGAppMaster.class.getName());
        this.clock = clock;
        this.startTime = clock.getTime();
        this.appSubmitTime = appSubmitTime;
        this.appAttemptID = applicationAttemptId;
        this.containerID = containerId;
        this.nmHost = nmHost;
        this.nmPort = nmPort;
        this.nmHttpPort = nmHttpPort;
        this.state = DAGAppMasterState.NEW;
        this.isSession = isSession;
        LOG.info((Object)("Created DAGAppMaster for application " + applicationAttemptId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void serviceInit(Configuration conf) throws Exception {
        this.amConf = conf;
        conf.setBoolean("yarn.dispatcher.exit-on-error", true);
        this.context = new RunningAppContext(conf);
        this.clientHandler = new DAGClientHandler();
        this.dispatcher = this.createDispatcher();
        this.addIfService(this.dispatcher, false);
        this.clientRpcServer = new DAGClientServer(this.clientHandler, this.appAttemptID);
        this.addIfService((Object)this.clientRpcServer, true);
        this.taskHeartbeatHandler = this.createTaskHeartbeatHandler(this.context, conf);
        this.addIfService((Object)this.taskHeartbeatHandler, true);
        this.containerHeartbeatHandler = this.createContainerHeartbeatHandler(this.context, conf);
        this.addIfService((Object)this.containerHeartbeatHandler, true);
        JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(UUID.randomUUID().toString()));
        this.sessionToken = new Token((TokenIdentifier)identifier, (SecretManager)this.jobTokenSecretManager);
        this.sessionToken.setService(identifier.getJobId());
        TokenCache.setJobToken(this.sessionToken, (Credentials)this.tokens);
        this.taskAttemptListener = this.createTaskAttemptListener(this.context, this.taskHeartbeatHandler, this.containerHeartbeatHandler);
        this.addIfService(this.taskAttemptListener, true);
        this.containers = new AMContainerMap(this.containerHeartbeatHandler, this.taskAttemptListener, this.context);
        this.addIfService((Object)this.containers, true);
        this.dispatcher.register(AMContainerEventType.class, (EventHandler)this.containers);
        this.nodes = new AMNodeMap(this.dispatcher.getEventHandler(), this.context);
        this.addIfService((Object)this.nodes, true);
        this.dispatcher.register(AMNodeEventType.class, (EventHandler)this.nodes);
        this.taskCleaner = this.createTaskCleaner(this.context);
        this.addIfService(this.taskCleaner, true);
        this.dagEventDispatcher = new DagEventDispatcher();
        this.vertexEventDispatcher = new VertexEventDispatcher();
        this.dispatcher.register(DAGAppMasterEventType.class, (EventHandler)new DAGAppMasterEventHandler());
        this.dispatcher.register(DAGEventType.class, (EventHandler)this.dagEventDispatcher);
        this.dispatcher.register(VertexEventType.class, (EventHandler)this.vertexEventDispatcher);
        this.dispatcher.register(TaskEventType.class, (EventHandler)new TaskEventDispatcher());
        this.dispatcher.register(TaskAttemptEventType.class, (EventHandler)new TaskAttemptEventDispatcher());
        this.dispatcher.register(TaskCleaner.EventType.class, (EventHandler)this.taskCleaner);
        this.taskSchedulerEventHandler = new TaskSchedulerEventHandler(this.context, this.clientRpcServer, this.dispatcher.getEventHandler());
        this.addIfService(this.taskSchedulerEventHandler, true);
        this.dispatcher.register(AMSchedulerEventType.class, (EventHandler)this.taskSchedulerEventHandler);
        this.addIfServiceDependency(this.taskSchedulerEventHandler, (Object)this.clientRpcServer);
        this.containerLauncher = this.createContainerLauncher(this.context);
        this.addIfService(this.containerLauncher, true);
        this.dispatcher.register(NMCommunicatorEventType.class, (EventHandler)this.containerLauncher);
        this.historyEventHandler = new HistoryEventHandler(this.context);
        this.addIfService((Object)this.historyEventHandler, true);
        this.dispatcher.register(HistoryEventType.class, (EventHandler)this.historyEventHandler);
        this.sessionTimeoutInterval = 1000 * this.amConf.getInt("tez.session.am.dag.submit.timeout.secs", 300);
        if (this.isSession) {
            FileInputStream sessionResourcesStream = null;
            try {
                sessionResourcesStream = new FileInputStream("tez.session.local-resources.pb.file-name");
                DAGProtos.PlanLocalResourcesProto localResourcesProto = DAGProtos.PlanLocalResourcesProto.parseFrom((InputStream)sessionResourcesStream);
                this.sessionResources.putAll(DagTypeConverters.convertFromPlanLocalResources((DAGProtos.PlanLocalResourcesProto)localResourcesProto));
            }
            finally {
                if (sessionResourcesStream != null) {
                    sessionResourcesStream.close();
                }
            }
        }
        this.initServices(conf);
        super.serviceInit(conf);
        this.state = DAGAppMasterState.INITED;
    }

    protected Dispatcher createDispatcher() {
        return new AsyncDispatcher();
    }

    protected void sysexit() {
        System.exit(0);
    }

    private synchronized void handle(DAGAppMasterEvent event) {
        switch ((DAGAppMasterEventType)event.getType()) {
            case INTERNAL_ERROR: {
                this.state = DAGAppMasterState.ERROR;
                if (this.currentDAG != null) {
                    LOG.info((Object)"Internal Error. Notifying dags to finish.");
                    this.sendEvent((Event<?>)new DAGEvent(this.currentDAG.getID(), DAGEventType.INTERNAL_ERROR));
                    break;
                }
                LOG.info((Object)"Internal Error. Finishing directly as no dag is active.");
                this.shutdownHandler.shutdown();
                break;
            }
            case DAG_FINISHED: {
                DAGAppMasterEventDAGFinished finishEvt = (DAGAppMasterEventDAGFinished)event;
                if (!this.isSession) {
                    this.setStateOnDAGCompletion();
                    LOG.info((Object)("Shutting down on completion of dag:" + finishEvt.getDAGId().toString()));
                    this.shutdownHandler.shutdown();
                    break;
                }
                LOG.info((Object)("DAG completed, dagId=" + finishEvt.getDAGId().toString() + ", dagState=" + (Object)((Object)finishEvt.getDAGState())));
                this.lastDAGCompletionTime = this.clock.getTime();
                switch (finishEvt.getDAGState()) {
                    case SUCCEEDED: {
                        this.successfulDAGs.incrementAndGet();
                        break;
                    }
                    case ERROR: 
                    case FAILED: {
                        this.failedDAGs.incrementAndGet();
                        break;
                    }
                    case KILLED: {
                        this.killedDAGs.incrementAndGet();
                        break;
                    }
                    default: {
                        LOG.fatal((Object)("Received a DAG Finished Event with state=" + (Object)((Object)finishEvt.getDAGState()) + ". Error. Shutting down."));
                        this.state = DAGAppMasterState.ERROR;
                        this.shutdownHandler.shutdown();
                    }
                }
                if (this.state.equals((Object)DAGAppMasterState.ERROR)) break;
                if (!this.sessionStopped.get()) {
                    LOG.info((Object)"Waiting for next DAG to be submitted.");
                    this.taskSchedulerEventHandler.dagCompleted();
                    this.state = DAGAppMasterState.IDLE;
                    break;
                }
                LOG.info((Object)"Session shutting down now.");
                this.state = DAGAppMasterState.SUCCEEDED;
                this.shutdownHandler.shutdown();
                break;
            }
            default: {
                throw new TezUncheckedException("AppMaster: No handler for event type: " + event.getType());
            }
        }
    }

    protected DAG createDAG(DAGProtos.DAGPlan dagPB) {
        TezDAGID dagId = new TezDAGID(this.appAttemptID.getApplicationId(), this.dagCounter.incrementAndGet());
        String dagIdString = dagId.toString();
        this.jobTokenSecretManager.addTokenForJob(dagIdString, this.sessionToken);
        LOG.info((Object)("Adding job token for " + dagIdString + " to jobTokenSecretManager"));
        Iterator iter = dagPB.getDagKeyValues().getConfKeyValuesList().iterator();
        Configuration dagConf = new Configuration(this.amConf);
        while (iter.hasNext()) {
            DAGProtos.PlanKeyValuePair keyValPair = (DAGProtos.PlanKeyValuePair)iter.next();
            dagConf.set(keyValPair.getKey(), keyValPair.getValue());
        }
        DAGImpl newDag = new DAGImpl(dagId, dagConf, dagPB, this.dispatcher.getEventHandler(), this.taskAttemptListener, this.jobTokenSecretManager, this.tokens, this.clock, this.currentUser.getShortUserName(), this.taskHeartbeatHandler, this.context);
        return newDag;
    }

    protected void addIfService(Object object, boolean addDispatcher) {
        if (object instanceof Service) {
            Service service = (Service)object;
            ServiceWithDependency sd = new ServiceWithDependency(service);
            this.services.put(service, sd);
            if (addDispatcher) {
                this.addIfServiceDependency(service, this.dispatcher);
            }
        }
    }

    protected void addIfServiceDependency(Object object, Object dependency) {
        if (object instanceof Service && dependency instanceof Service) {
            Service service = (Service)object;
            Service dependencyService = (Service)dependency;
            ServiceWithDependency sd = this.services.get(service);
            sd.dependencies.add(dependencyService);
            dependencyService.registerServiceListener((ServiceStateChangeListener)sd);
        }
    }

    protected TaskAttemptListener createTaskAttemptListener(AppContext context, TaskHeartbeatHandler thh, ContainerHeartbeatHandler chh) {
        TaskAttemptListenerImpTezDag lis = new TaskAttemptListenerImpTezDag(context, thh, chh, this.jobTokenSecretManager);
        return lis;
    }

    protected TaskHeartbeatHandler createTaskHeartbeatHandler(AppContext context, Configuration conf) {
        TaskHeartbeatHandler thh = new TaskHeartbeatHandler(context, conf.getInt("tez.am.task.listener.thread-count", 30));
        return thh;
    }

    protected ContainerHeartbeatHandler createContainerHeartbeatHandler(AppContext context, Configuration conf) {
        ContainerHeartbeatHandler chh = new ContainerHeartbeatHandler(context, conf.getInt("tez.am.task.listener.thread-count", 30));
        return chh;
    }

    protected TaskCleaner createTaskCleaner(AppContext context) {
        return new TaskCleanerImpl(context);
    }

    protected ContainerLauncher createContainerLauncher(AppContext context) {
        return new ContainerLauncherImpl(context);
    }

    public ApplicationId getAppID() {
        return this.appAttemptID.getApplicationId();
    }

    public ApplicationAttemptId getAttemptID() {
        return this.appAttemptID;
    }

    public int getStartCount() {
        return this.appAttemptID.getAttemptId();
    }

    public AppContext getContext() {
        return this.context;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public ContainerLauncher getContainerLauncher() {
        return this.containerLauncher;
    }

    public TaskAttemptListener getTaskAttemptListener() {
        return this.taskAttemptListener;
    }

    public ContainerId getAppContainerId() {
        return this.containerID;
    }

    public String getAppNMHost() {
        return this.nmHost;
    }

    public int getAppNMPort() {
        return this.nmPort;
    }

    public int getAppNMHttpPort() {
        return this.nmHttpPort;
    }

    public DAGAppMasterState getState() {
        return this.state;
    }

    public List<String> getDiagnostics() {
        if (!this.isSession) {
            if (this.currentDAG != null) {
                return this.currentDAG.getDiagnostics();
            }
        } else {
            return Collections.singletonList("Session stats:submittedDAGs=" + this.submittedDAGs.get() + ", successfulDAGs=" + this.successfulDAGs.get() + ", failedDAGs=" + this.failedDAGs.get() + ", killedDAGs=" + this.killedDAGs.get());
        }
        return null;
    }

    public float getProgress() {
        if (this.isSession && this.state.equals((Object)DAGAppMasterState.IDLE)) {
            return 0.0f;
        }
        if (this.currentDAG != null) {
            DAGState state = this.currentDAG.getState();
            switch (state) {
                case NEW: 
                case INITED: {
                    return 0.0f;
                }
                case RUNNING: {
                    return this.currentDAG.getProgress();
                }
                case SUCCEEDED: 
                case ERROR: 
                case FAILED: 
                case KILLED: 
                case TERMINATING: {
                    return 1.0f;
                }
            }
        }
        return 0.0f;
    }

    private synchronized void setStateOnDAGCompletion() {
        DAGAppMasterState oldState = this.state;
        if (this.isSession) {
            return;
        }
        switch (this.currentDAG.getState()) {
            case SUCCEEDED: {
                this.state = DAGAppMasterState.SUCCEEDED;
                break;
            }
            case FAILED: {
                this.state = DAGAppMasterState.FAILED;
                break;
            }
            case KILLED: {
                this.state = DAGAppMasterState.KILLED;
                break;
            }
            case ERROR: {
                this.state = DAGAppMasterState.ERROR;
                break;
            }
            default: {
                this.state = DAGAppMasterState.ERROR;
            }
        }
        LOG.info((Object)("On DAG completion. Old state: " + (Object)((Object)oldState) + " new state: " + (Object)((Object)this.state)));
    }

    synchronized void shutdownTezAM() {
        this.sessionStopped.set(true);
        if (this.currentDAG != null && !this.currentDAG.isComplete()) {
            LOG.info((Object)("Sending a kill event to the current DAG, dagId=" + this.currentDAG.getID()));
            this.sendEvent((Event<?>)new DAGEvent(this.currentDAG.getID(), DAGEventType.DAG_KILL));
        } else {
            LOG.info((Object)"No current running DAG, shutting down the AM");
            if (this.isSession && !this.state.equals((Object)DAGAppMasterState.ERROR)) {
                this.state = DAGAppMasterState.SUCCEEDED;
            }
            this.shutdownHandler.shutdown();
        }
    }

    synchronized String submitDAGToAppMaster(DAGProtos.DAGPlan dagPlan) throws TezException {
        if (this.currentDAG != null && !this.state.equals((Object)DAGAppMasterState.IDLE)) {
            throw new TezException("App master already running a DAG");
        }
        if (this.state.equals((Object)DAGAppMasterState.ERROR) || this.sessionStopped.get()) {
            throw new TezException("AM unable to accept new DAG submissions. In the process of shutting down");
        }
        LOG.info((Object)"Starting DAG submitted via RPC");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Writing DAG plan to: tez-dag.pb.txt");
            File outFile = new File("tez-dag.pb.txt");
            try {
                PrintWriter printWriter = new PrintWriter(outFile);
                String dagPbString = dagPlan.toString();
                printWriter.println(dagPbString);
                printWriter.close();
            }
            catch (IOException e) {
                throw new TezException("Failed to write TEZ_PLAN to " + outFile.toString(), (Throwable)e);
            }
        }
        this.submittedDAGs.incrementAndGet();
        this.startDAG(dagPlan);
        return this.currentDAG.getID().toString();
    }

    void startServices() {
        try {
            Throwable firstError = null;
            ArrayList<ServiceThread> threads = new ArrayList<ServiceThread>();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Begin parallel start");
            }
            for (ServiceWithDependency sd : this.services.values()) {
                ServiceThread st = new ServiceThread(sd);
                threads.add(st);
            }
            for (ServiceThread st : threads) {
                st.start();
            }
            for (ServiceThread st : threads) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Waiting for service thread to join for " + st.getName()));
                }
                st.join();
                if (st.error == null || firstError != null) continue;
                firstError = st.error;
            }
            if (firstError != null) {
                throw ServiceStateException.convert(firstError);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"End parallel start");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    void initServices(Configuration conf) {
        for (ServiceWithDependency sd : this.services.values()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Initing service : " + sd.service));
            }
            sd.service.init(conf);
        }
    }

    void stopServices() {
        ArrayList<Service> serviceList = new ArrayList<Service>(this.services.size());
        for (ServiceWithDependency sd : this.services.values()) {
            serviceList.add(sd.service);
        }
        Exception firstException = null;
        for (int i = this.services.size() - 1; i >= 0; --i) {
            Exception ex;
            Service service = (Service)serviceList.get(i);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Stopping service : " + service));
            }
            if ((ex = ServiceOperations.stopQuietly((Log)LOG, (Service)service)) == null || firstException != null) continue;
            firstException = ex;
        }
        if (firstException != null) {
            throw ServiceStateException.convert(firstException);
        }
    }

    public synchronized void serviceStart() throws Exception {
        this.startServices();
        super.serviceStart();
        DefaultMetricsSystem.initialize((String)"DAGAppMaster");
        this.appsStartTime = this.clock.getTime();
        AMStartedEvent startEvent = new AMStartedEvent(this.appAttemptID, this.startTime, this.appsStartTime, this.appSubmitTime);
        this.dispatcher.getEventHandler().handle((Event)new DAGHistoryEvent(startEvent));
        this.lastDAGCompletionTime = this.clock.getTime();
        if (!this.isSession) {
            this.startDAG();
        } else {
            boolean preWarmContainersEnabled = this.amConf.getBoolean("tez.session.pre-warm.enabled", false);
            boolean ranPreWarmContainersDAG = false;
            if (preWarmContainersEnabled) {
                ranPreWarmContainersDAG = this.runPreWarmContainersDAG();
            }
            if (!ranPreWarmContainersDAG) {
                LOG.info((Object)"In Session mode. Waiting for DAG over RPC");
                this.state = DAGAppMasterState.IDLE;
                this.dagSubmissionTimer = new Timer(true);
                this.dagSubmissionTimer.scheduleAtFixedRate(new TimerTask(){

                    public void run() {
                        DAGAppMaster.this.checkAndHandleSessionTimeout();
                    }
                }, this.sessionTimeoutInterval, this.sessionTimeoutInterval / 10L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runPreWarmContainersDAG() throws Exception {
        InputStream dagPBBinaryStream = null;
        try {
            DAGProtos.DAGPlan preWarmDAGPlan = null;
            String preWarmDAGPlanPathStr = this.amConf.get("tez.session.pre-warm.dag-plan.pb.path");
            if (preWarmDAGPlanPathStr == null || preWarmDAGPlanPathStr.isEmpty()) {
                LOG.info((Object)"No path to pre-warm DAG plan specified");
                boolean bl = false;
                return bl;
            }
            LOG.info((Object)("Trying to run pre-warm DAG plan from specified path: " + preWarmDAGPlanPathStr));
            FileSystem fs = FileSystem.get((Configuration)this.amConf);
            Path preWarmDAGPlanPath = new Path(preWarmDAGPlanPathStr);
            if (!fs.exists(preWarmDAGPlanPath)) {
                LOG.info((Object)("Could not find pre-warm DAG plan file, path=" + preWarmDAGPlanPathStr));
                boolean bl = false;
                return bl;
            }
            dagPBBinaryStream = fs.open(preWarmDAGPlanPath);
            preWarmDAGPlan = DAGProtos.DAGPlan.parseFrom((InputStream)dagPBBinaryStream);
            this.startDAG(preWarmDAGPlan);
        }
        finally {
            if (dagPBBinaryStream != null) {
                dagPBBinaryStream.close();
            }
        }
        return true;
    }

    public synchronized void serviceStop() throws Exception {
        if (this.isSession) {
            this.sessionStopped.set(true);
        }
        if (this.dagSubmissionTimer != null) {
            this.dagSubmissionTimer.cancel();
        }
        this.stopServices();
        super.serviceStop();
    }

    private static void validateInputParam(String value, String param) throws IOException {
        if (value == null) {
            String msg = param + " is null";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }

    private synchronized void checkAndHandleSessionTimeout() {
        if (this.state.equals((Object)DAGAppMasterState.RUNNING) || this.sessionStopped.get()) {
            return;
        }
        long currentTime = this.clock.getTime();
        if (currentTime < this.lastDAGCompletionTime + this.sessionTimeoutInterval) {
            return;
        }
        LOG.info((Object)("Session timed out, lastDAGCompletionTime=" + this.lastDAGCompletionTime + " ms" + ", sessionTimeoutInterval=" + this.sessionTimeoutInterval + " ms"));
        this.shutdownTezAM();
    }

    public boolean isSession() {
        return this.isSession;
    }

    public static void main(String[] args) {
        try {
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
            String containerIdStr = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
            String nodeHostString = System.getenv(ApplicationConstants.Environment.NM_HOST.name());
            String nodePortString = System.getenv(ApplicationConstants.Environment.NM_PORT.name());
            String nodeHttpPortString = System.getenv(ApplicationConstants.Environment.NM_HTTP_PORT.name());
            String appSubmitTimeStr = System.getenv("APP_SUBMIT_TIME_ENV");
            DAGAppMaster.validateInputParam(appSubmitTimeStr, "APP_SUBMIT_TIME_ENV");
            ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
            ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
            long appSubmitTime = Long.parseLong(appSubmitTimeStr);
            Configuration conf = new Configuration((Configuration)new YarnConfiguration());
            TezUtils.addUserSpecifiedTezConfiguration((Configuration)conf);
            String jobUserName = System.getenv(ApplicationConstants.Environment.USER.name());
            conf.setBoolean("fs.automatic.close", false);
            Options opts = new Options();
            opts.addOption("session", false, "Run Tez Application Master in Session mode");
            CommandLine cliParser = new GnuParser().parse(opts, args);
            DAGAppMaster appMaster = new DAGAppMaster(applicationAttemptId, containerId, nodeHostString, Integer.parseInt(nodePortString), Integer.parseInt(nodeHttpPortString), appSubmitTime, cliParser.hasOption("session"));
            ShutdownHookManager.get().addShutdownHook((Runnable)new DAGAppMasterShutdownHook(appMaster), 30);
            DAGAppMaster.initAndStartAppMaster(appMaster, conf, jobUserName);
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting DAGAppMaster", t);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDAG() throws IOException {
        FileInputStream dagPBBinaryStream = null;
        try {
            DAGProtos.DAGPlan dagPlan = null;
            dagPBBinaryStream = new FileInputStream("tez-dag.pb");
            dagPlan = DAGProtos.DAGPlan.parseFrom((InputStream)dagPBBinaryStream);
            this.startDAG(dagPlan);
        }
        finally {
            if (dagPBBinaryStream != null) {
                dagPBBinaryStream.close();
            }
        }
    }

    private void startDAG(DAGProtos.DAGPlan dagPlan) {
        this.state = DAGAppMasterState.RUNNING;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running a DAG with " + dagPlan.getVertexCount() + " vertices "));
            for (DAGProtos.VertexPlan v : dagPlan.getVertexList()) {
                LOG.debug((Object)("DAG has vertex " + v.getName()));
            }
        }
        this.appName = dagPlan.getName();
        DAG newDAG = this.createDAG(dagPlan);
        this.startDAG(newDAG);
    }

    private void startDAG(DAG dag) {
        this.currentDAG = dag;
        ((RunningAppContext)this.context).setDAG(this.currentDAG);
        DAGEvent initDagEvent = new DAGEvent(this.currentDAG.getID(), DAGEventType.DAG_INIT);
        this.dagEventDispatcher.handle(initDagEvent);
        DAGEvent startDagEvent = new DAGEvent(this.currentDAG.getID(), DAGEventType.DAG_START);
        this.sendEvent((Event<?>)startDagEvent);
    }

    protected static void initAndStartAppMaster(final DAGAppMaster appMaster, final Configuration conf, String jobUserName) throws IOException, InterruptedException {
        UserGroupInformation.setConfiguration((Configuration)conf);
        appMaster.currentUser = UserGroupInformation.getCurrentUser();
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        UserGroupInformation appMasterUgi = UserGroupInformation.createRemoteUser((String)jobUserName);
        appMasterUgi.addCredentials(credentials);
        Iterator iter = credentials.getAllTokens().iterator();
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            iter.remove();
        }
        appMaster.tokens = credentials;
        appMasterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                appMaster.init(conf);
                appMaster.start();
                return null;
            }
        });
    }

    private void sendEvent(Event<?> event) {
        this.dispatcher.getEventHandler().handle(event);
    }

    static class DAGAppMasterShutdownHook
    implements Runnable {
        DAGAppMaster appMaster;

        DAGAppMasterShutdownHook(DAGAppMaster appMaster) {
            this.appMaster = appMaster;
        }

        public void run() {
            if (this.appMaster.getServiceState() == Service.STATE.STOPPED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"DAGAppMaster already stopped. Ignoring signal");
                }
                return;
            }
            if (this.appMaster.getServiceState() == Service.STATE.STARTED) {
                LOG.info((Object)"DAGAppMaster received a signal. Signaling TaskScheduler");
                this.appMaster.taskSchedulerEventHandler.setSignalled(true);
            }
            if (EnumSet.of(DAGAppMasterState.NEW, DAGAppMasterState.INITED, DAGAppMasterState.IDLE, DAGAppMasterState.RUNNING).contains((Object)this.appMaster.state)) {
                this.appMaster.state = DAGAppMasterState.KILLED;
            }
            this.appMaster.stop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VertexEventDispatcher
    implements EventHandler<VertexEvent> {
        private VertexEventDispatcher() {
        }

        public void handle(VertexEvent event) {
            DAG dag = DAGAppMaster.this.context.getCurrentDAG();
            Vertex vertex = dag.getVertex(event.getVertexId());
            ((EventHandler)vertex).handle((Event)event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskAttemptEventDispatcher
    implements EventHandler<TaskAttemptEvent> {
        private TaskAttemptEventDispatcher() {
        }

        public void handle(TaskAttemptEvent event) {
            DAG dag = DAGAppMaster.this.context.getCurrentDAG();
            Task task = dag.getVertex(event.getTaskAttemptID().getTaskID().getVertexID()).getTask(event.getTaskAttemptID().getTaskID());
            TaskAttempt attempt = task.getAttempt(event.getTaskAttemptID());
            ((EventHandler)attempt).handle((Event)event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskEventDispatcher
    implements EventHandler<TaskEvent> {
        private TaskEventDispatcher() {
        }

        public void handle(TaskEvent event) {
            Task task = DAGAppMaster.this.context.getCurrentDAG().getVertex(event.getTaskID().getVertexID()).getTask(event.getTaskID());
            ((EventHandler)task).handle((Event)event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DagEventDispatcher
    implements EventHandler<DAGEvent> {
        private DagEventDispatcher() {
        }

        public void handle(DAGEvent event) {
            ((EventHandler)DAGAppMaster.this.context.getCurrentDAG()).handle((Event)event);
        }
    }

    private class ServiceThread
    extends Thread {
        final ServiceWithDependency serviceWithDependency;
        Throwable error = null;

        public ServiceThread(ServiceWithDependency serviceWithDependency) {
            this.serviceWithDependency = serviceWithDependency;
            this.setName("ServiceThread:" + serviceWithDependency.service.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Starting thread " + this.serviceWithDependency.service.getName()));
            }
            long start = System.currentTimeMillis();
            try {
                this.serviceWithDependency.start();
            }
            catch (Throwable t) {
                this.error = t;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Service: " + this.serviceWithDependency.service.getName() + " started in " + (System.currentTimeMillis() - start) + "ms"));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Service thread completed for " + this.serviceWithDependency.service.getName()));
            }
        }
    }

    private class ServiceWithDependency
    implements ServiceStateChangeListener {
        Service service;
        List<Service> dependencies = new ArrayList<Service>();
        AtomicInteger dependenciesStarted = new AtomicInteger(0);
        volatile boolean canStart = false;
        volatile boolean dependenciesFailed = false;

        ServiceWithDependency(Service service) {
            this.service = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(Service dependency) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Service dependency: " + dependency.getName() + " notify" + " for service: " + this.service.getName()));
            }
            if (dependency.isInState(Service.STATE.STARTED)) {
                if (this.dependenciesStarted.incrementAndGet() == this.dependencies.size()) {
                    ServiceWithDependency serviceWithDependency = this;
                    synchronized (serviceWithDependency) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Service: " + this.service.getName() + " notified to start"));
                        }
                        this.canStart = true;
                        this.notifyAll();
                    }
                }
            } else if (!this.service.isInState(Service.STATE.STARTED) && dependency.getFailureState() != null) {
                ServiceWithDependency serviceWithDependency = this;
                synchronized (serviceWithDependency) {
                    this.dependenciesFailed = true;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Service: " + this.service.getName() + " will fail to start" + " as dependent service " + dependency.getName() + " failed to start"));
                    }
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() throws InterruptedException {
            if (this.dependencies.size() > 0) {
                ServiceWithDependency serviceWithDependency = this;
                synchronized (serviceWithDependency) {
                    while (!this.canStart) {
                        this.wait(180000L);
                        if (!this.dependenciesFailed) continue;
                        throw new TezUncheckedException("Skipping service start for " + this.service.getName() + " as dependencies failed to start");
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Service: " + this.service.getName() + " trying to start"));
            }
            for (Service dependency : this.dependencies) {
                if (dependency.isInState(Service.STATE.STARTED)) continue;
                LOG.info((Object)("Service: " + this.service.getName() + " not started because " + " service: " + dependency.getName() + " is in state: " + dependency.getServiceState()));
                return;
            }
            this.service.start();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RunningAppContext
    implements AppContext {
        private DAG dag;
        private final Configuration conf;
        private final ClusterInfo clusterInfo = new ClusterInfo();
        private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final Lock rLock = this.rwLock.readLock();
        private final Lock wLock = this.rwLock.writeLock();

        public RunningAppContext(Configuration config) {
            this.conf = config;
        }

        @Override
        public DAGAppMaster getAppMaster() {
            return DAGAppMaster.this;
        }

        @Override
        public Configuration getAMConf() {
            return this.conf;
        }

        @Override
        public ApplicationAttemptId getApplicationAttemptId() {
            return DAGAppMaster.this.appAttemptID;
        }

        @Override
        public ApplicationId getApplicationID() {
            return DAGAppMaster.this.appAttemptID.getApplicationId();
        }

        @Override
        public String getApplicationName() {
            return DAGAppMaster.this.appName;
        }

        @Override
        public long getStartTime() {
            return DAGAppMaster.this.startTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DAG getCurrentDAG() {
            try {
                this.rLock.lock();
                DAG dAG = this.dag;
                return dAG;
            }
            finally {
                this.rLock.unlock();
            }
        }

        @Override
        public EventHandler getEventHandler() {
            return DAGAppMaster.this.dispatcher.getEventHandler();
        }

        @Override
        public String getUser() {
            return this.dag.getUserName();
        }

        @Override
        public Clock getClock() {
            return DAGAppMaster.this.clock;
        }

        @Override
        public ClusterInfo getClusterInfo() {
            return this.clusterInfo;
        }

        @Override
        public AMContainerMap getAllContainers() {
            return DAGAppMaster.this.containers;
        }

        @Override
        public AMNodeMap getAllNodes() {
            return DAGAppMaster.this.nodes;
        }

        @Override
        public TaskSchedulerEventHandler getTaskScheduler() {
            return DAGAppMaster.this.taskSchedulerEventHandler;
        }

        @Override
        public Map<String, LocalResource> getSessionResources() {
            return DAGAppMaster.this.sessionResources;
        }

        @Override
        public boolean isSession() {
            return DAGAppMaster.this.isSession;
        }

        @Override
        public DAGAppMasterState getAMState() {
            return DAGAppMaster.this.state;
        }

        @Override
        public Map<ApplicationAccessType, String> getApplicationACLs() {
            if (DAGAppMaster.this.getServiceState() != Service.STATE.STARTED) {
                throw new TezUncheckedException("Cannot get ApplicationACLs before all services have started");
            }
            return DAGAppMaster.this.taskSchedulerEventHandler.getApplicationAcls();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TezDAGID getCurrentDAGID() {
            try {
                this.rLock.lock();
                if (this.dag != null) {
                    TezDAGID tezDAGID = this.dag.getID();
                    return tezDAGID;
                }
                TezDAGID tezDAGID = null;
                return tezDAGID;
            }
            finally {
                this.rLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDAG(DAG dag) {
            try {
                this.wLock.lock();
                this.dag = dag;
            }
            finally {
                this.wLock.unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DAGClientHandler {
        public List<String> getAllDAGs() throws TezException {
            return Collections.singletonList(DAGAppMaster.this.currentDAG.getID().toString());
        }

        public DAGStatus getDAGStatus(String dagIdStr, Set<StatusGetOpts> statusOptions) throws TezException {
            return this.getDAG(dagIdStr).getDAGStatus(statusOptions);
        }

        public VertexStatus getVertexStatus(String dagIdStr, String vertexName, Set<StatusGetOpts> statusOptions) throws TezException {
            VertexStatusBuilder status = this.getDAG(dagIdStr).getVertexStatus(vertexName, statusOptions);
            if (status == null) {
                throw new TezException("Unknown vertexName: " + vertexName);
            }
            return status;
        }

        DAG getDAG(String dagIdStr) throws TezException {
            TezDAGID dagId = TezDAGID.fromString((String)dagIdStr);
            if (dagId == null) {
                throw new TezException("Bad dagId: " + dagIdStr);
            }
            if (DAGAppMaster.this.currentDAG == null) {
                throw new TezException("No running dag at present");
            }
            if (!dagId.equals((Object)DAGAppMaster.this.currentDAG.getID())) {
                LOG.warn((Object)("Current DAGID : " + (DAGAppMaster.this.currentDAG.getID() == null ? "NULL" : DAGAppMaster.this.currentDAG.getID()) + ", Looking for string (not found): " + dagIdStr + ", dagIdObj: " + dagId));
                throw new TezException("Unknown dagId: " + dagIdStr);
            }
            return DAGAppMaster.this.currentDAG;
        }

        public void tryKillDAG(String dagIdStr) throws TezException {
            DAG dag = this.getDAG(dagIdStr);
            LOG.info((Object)("Sending client kill to dag: " + dagIdStr));
            DAGAppMaster.this.sendEvent((Event)new DAGEvent(dag.getID(), DAGEventType.DAG_KILL));
        }

        public synchronized String submitDAG(DAGProtos.DAGPlan dagPlan) throws TezException {
            return DAGAppMaster.this.submitDAGToAppMaster(dagPlan);
        }

        public synchronized void shutdownAM() {
            LOG.info((Object)"Received message to shutdown AM");
            DAGAppMaster.this.shutdownTezAM();
        }

        public synchronized TezSessionStatus getSessionStatus() throws TezException {
            if (!DAGAppMaster.this.isSession) {
                throw new TezException("Unsupported operation as AM not running in session mode");
            }
            switch (DAGAppMaster.this.state) {
                case NEW: 
                case INITED: {
                    return TezSessionStatus.INITIALIZING;
                }
                case IDLE: {
                    return TezSessionStatus.READY;
                }
                case RUNNING: {
                    return TezSessionStatus.RUNNING;
                }
                case ERROR: 
                case FAILED: 
                case SUCCEEDED: 
                case KILLED: {
                    return TezSessionStatus.SHUTDOWN;
                }
            }
            return TezSessionStatus.INITIALIZING;
        }
    }

    private class DAGAppMasterShutdownHandler {
        private AtomicBoolean shutdownHandled = new AtomicBoolean(false);

        private DAGAppMasterShutdownHandler() {
        }

        public void shutdown() {
            if (!this.shutdownHandled.compareAndSet(false, true)) {
                LOG.info((Object)"Ignoring multiple shutdown events");
                return;
            }
            LOG.info((Object)"Handling DAGAppMaster shutdown");
            AMShutdownRunnable r = new AMShutdownRunnable();
            Thread t = new Thread((Runnable)r, "AMShutdownThread");
            t.start();
        }

        private class AMShutdownRunnable
        implements Runnable {
            private AMShutdownRunnable() {
            }

            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    LOG.info((Object)"Calling stop for all the services");
                    DAGAppMaster.this.stop();
                    LOG.info((Object)"Exiting DAGAppMaster..GoodBye!");
                    DAGAppMaster.this.sysexit();
                }
                catch (Throwable t) {
                    LOG.warn((Object)"Graceful stop failed ", t);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DAGAppMasterEventHandler
    implements EventHandler<DAGAppMasterEvent> {
        private DAGAppMasterEventHandler() {
        }

        public void handle(DAGAppMasterEvent event) {
            DAGAppMaster.this.handle(event);
        }
    }
}

