/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.TezMRTypeConverter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.committer.VertexContext;
import org.apache.tez.dag.api.committer.VertexOutputCommitter;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.utils.TezBuilderUtils;
import org.apache.tez.mapreduce.hadoop.MRHelpers;

public class MRVertexOutputCommitter
extends VertexOutputCommitter {
    private static final Log LOG = LogFactory.getLog(MRVertexOutputCommitter.class);
    private OutputCommitter committer = null;
    private org.apache.hadoop.mapred.JobContext jobContext = null;
    private volatile boolean initialized = false;
    private JobConf jobConf = null;

    private OutputCommitter getOutputCommitter(VertexContext context) {
        OutputCommitter committer = null;
        boolean newApiCommitter = false;
        if (this.jobConf.getBoolean("mapred.reducer.new-api", false) || this.jobConf.getBoolean("mapred.mapper.new-api", false)) {
            newApiCommitter = true;
            LOG.info((Object)"Using mapred newApiCommitter.");
        }
        LOG.info((Object)("OutputCommitter set in config for vertex: " + context.getVertexID() + " : " + this.jobConf.get("mapred.output.committer.class")));
        if (newApiCommitter) {
            TezTaskID taskId = TezBuilderUtils.newTaskId(context.getDAGID(), context.getVertexID().getId(), 0);
            TezTaskAttemptID attemptID = TezBuilderUtils.newTaskAttemptId(taskId, 0);
            TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl((Configuration)this.jobConf, TezMRTypeConverter.fromTez(attemptID));
            try {
                OutputFormat outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)taskContext.getOutputFormatClass(), (Configuration)this.jobConf);
                committer = outputFormat.getOutputCommitter((TaskAttemptContext)taskContext);
            }
            catch (Exception e) {
                throw new TezUncheckedException((Throwable)e);
            }
        } else {
            committer = (OutputCommitter)ReflectionUtils.newInstance((Class)this.jobConf.getClass("mapred.output.committer.class", FileOutputCommitter.class, org.apache.hadoop.mapred.OutputCommitter.class), (Configuration)this.jobConf);
        }
        LOG.info((Object)("OutputCommitter is " + committer.getClass().getName()));
        return committer;
    }

    private org.apache.hadoop.mapred.JobContext getJobContextFromVertexContext(VertexContext context) throws IOException {
        JobID jobId = TypeConverter.fromYarn((ApplicationId)context.getDAGID().getApplicationId());
        return new MRJobContextImpl(this.jobConf, jobId);
    }

    private JobStatus.State getJobStateFromVertexStatusState(VertexStatus.State state) {
        switch (state) {
            case INITED: {
                return JobStatus.State.PREP;
            }
            case RUNNING: {
                return JobStatus.State.RUNNING;
            }
            case SUCCEEDED: {
                return JobStatus.State.SUCCEEDED;
            }
            case KILLED: {
                return JobStatus.State.KILLED;
            }
            case FAILED: 
            case ERROR: {
                return JobStatus.State.FAILED;
            }
        }
        throw new TezUncheckedException("Unknown VertexStatus.State: " + state);
    }

    public void init(VertexContext context) throws IOException {
        byte[] userPayload = context.getUserPayload();
        this.jobConf = userPayload == null ? new JobConf() : new JobConf(MRHelpers.createConfFromUserPayload((byte[])context.getUserPayload()));
        this.jobConf.setInt("mapreduce.job.application.attempt.id", context.getApplicationAttemptId().getAttemptId());
        this.committer = this.getOutputCommitter(context);
        this.jobContext = this.getJobContextFromVertexContext(context);
        this.initialized = true;
    }

    public void setupVertex() throws IOException {
        if (!this.initialized) {
            throw new RuntimeException("Committer not initialized");
        }
        this.committer.setupJob((JobContext)this.jobContext);
    }

    public void commitVertex() throws IOException {
        if (!this.initialized) {
            throw new RuntimeException("Committer not initialized");
        }
        this.committer.commitJob((JobContext)this.jobContext);
    }

    public void abortVertex(VertexStatus.State finalState) throws IOException {
        if (!this.initialized) {
            throw new RuntimeException("Committer not initialized");
        }
        JobStatus.State jobState = this.getJobStateFromVertexStatusState(finalState);
        this.committer.abortJob((JobContext)this.jobContext, jobState);
    }

    private static class MRJobContextImpl
    extends JobContextImpl {
        public MRJobContextImpl(JobConf jobConf, JobID jobId) {
            super(jobConf, jobId);
        }
    }
}

