/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.RootInputInitializerManager;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.runtime.api.InputInitializerContext;

public class TezRootInputInitializerContextImpl
implements InputInitializerContext {
    private RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor> input;
    private final Vertex vertex;
    private final AppContext appContext;
    private final RootInputInitializerManager manager;

    public TezRootInputInitializerContextImpl(RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor> input, Vertex vertex, AppContext appContext, RootInputInitializerManager manager) {
        Objects.requireNonNull(input, "input is null");
        Objects.requireNonNull(vertex, "vertex is null");
        Objects.requireNonNull(appContext, "appContext is null");
        Objects.requireNonNull(manager, "initializerManager is null");
        this.input = input;
        this.vertex = vertex;
        this.appContext = appContext;
        this.manager = manager;
    }

    public ApplicationId getApplicationId() {
        return this.vertex.getVertexId().getDAGId().getApplicationId();
    }

    public String getDAGName() {
        return this.vertex.getDAG().getName();
    }

    public String getInputName() {
        return this.input.getName();
    }

    public UserPayload getInputUserPayload() {
        return ((InputDescriptor)this.input.getIODescriptor()).getUserPayload();
    }

    public UserPayload getUserPayload() {
        return ((InputInitializerDescriptor)this.input.getControllerDescriptor()).getUserPayload();
    }

    public Configuration getVertexConfiguration() {
        return this.vertex.getConf();
    }

    public int getNumTasks() {
        return this.vertex.getTotalTasks();
    }

    public Resource getVertexTaskResource() {
        return this.vertex.getTaskResource();
    }

    public Resource getTotalAvailableResource() {
        return this.appContext.getTaskScheduler().getTotalResources(this.vertex.getTaskSchedulerIdentifier());
    }

    public int getNumClusterNodes() {
        return this.appContext.getTaskScheduler().getNumClusterNodes();
    }

    public int getDAGAttemptNumber() {
        return this.appContext.getApplicationAttemptId().getAttemptId();
    }

    public int getVertexNumTasks(String vertexName) {
        return this.appContext.getCurrentDAG().getVertex(vertexName).getTotalTasks();
    }

    public void registerForVertexStateUpdates(String vertexName, Set<VertexState> stateSet) {
        this.manager.registerForVertexUpdates(vertexName, this.input.getName(), stateSet);
    }

    public void addCounters(TezCounters tezCounters) {
        this.vertex.addCounters(tezCounters);
    }
}

