/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.utils;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.api.TezException;

@InterfaceAudience.Private
public class RelocalizationUtils {
    public static List<URL> processAdditionalResources(Map<String, URI> additionalResources, Configuration conf, String destDir) throws IOException, TezException {
        if (additionalResources == null || additionalResources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList urls = Lists.newArrayListWithCapacity((int)additionalResources.size());
        for (Map.Entry<String, URI> lrEntry : additionalResources.entrySet()) {
            Path dFile = RelocalizationUtils.downloadResource(lrEntry.getKey(), lrEntry.getValue(), conf, destDir);
            urls.add(dFile.toUri().toURL());
        }
        return urls;
    }

    public static void addUrlsToClassPath(List<URL> urls) {
        ReflectionUtils.addResourcesToSystemClassLoader(urls);
    }

    private static Path downloadResource(String destName, URI uri, Configuration conf, String destDir) throws IOException {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        Path cwd = new Path(destDir);
        Path dFile = new Path(cwd, destName);
        Path srcPath = new Path(uri);
        fs.copyToLocalFile(srcPath, dFile);
        return dFile.makeQualified(FileSystem.getLocal((Configuration)conf).getUri(), cwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getLocalSha(Path path, Configuration conf) throws IOException {
        try (FSDataInputStream is = null;){
            is = FileSystem.getLocal((Configuration)conf).open(path);
            byte[] byArray = DigestUtils.sha256((InputStream)is);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResourceSha(URI uri, Configuration conf) throws IOException {
        try (InputStream is = null;){
            is = FileSystem.get((URI)uri, (Configuration)conf).open(new Path(uri));
            byte[] byArray = DigestUtils.sha256((InputStream)is);
            return byArray;
        }
    }
}

