/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.utils;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class EnvironmentUpdateUtils {
    public static void put(String key, String value) {
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        environment.put(key, value);
        EnvironmentUpdateUtils.updateEnvironment(environment);
    }

    public static void putAll(Map<String, String> additionalEnvironment) {
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        environment.putAll(additionalEnvironment);
        EnvironmentUpdateUtils.updateEnvironment(environment);
    }

    private static void updateEnvironment(Map<String, String> environment) {
        try {
            Class<?>[] classes;
            for (Class<?> clazz : classes = Collections.class.getDeclaredClasses()) {
                if (!"java.util.Collections$UnmodifiableMap".equals(clazz.getName())) continue;
                Field field = clazz.getDeclaredField("m");
                field.setAccessible(true);
                Object obj = field.get(System.getenv());
                Map map = (Map)obj;
                map.clear();
                map.putAll(environment);
            }
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Failed to update Environment variables", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to update Environment variables", e);
        }
    }
}

