/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezID;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TezVertexID
extends TezID {
    public static final String VERTEX = "vertex";
    protected static final ThreadLocal<NumberFormat> idFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(2);
            return fmt;
        }
    };
    private TezDAGID dagId;

    public TezVertexID() {
    }

    public TezVertexID(TezDAGID dagId, int id) {
        super(id);
        if (dagId == null) {
            throw new IllegalArgumentException("dagId cannot be null");
        }
        this.dagId = dagId;
    }

    public TezDAGID getDAGId() {
        return this.dagId;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TezVertexID that = (TezVertexID)o;
        return this.dagId.equals(that.dagId);
    }

    public int compareTo(TezID o) {
        TezVertexID that = (TezVertexID)o;
        return this.dagId.compareTo(that.dagId);
    }

    public String toString() {
        return this.appendTo(new StringBuilder(VERTEX)).toString();
    }

    public void readFields(DataInput in) throws IOException {
        this.dagId = new TezDAGID();
        this.dagId.readFields(in);
        super.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        this.dagId.write(out);
        super.write(out);
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return this.dagId.appendTo(builder).append('_').append(idFormat.get().format(this.id));
    }

    public int hashCode() {
        return this.dagId.hashCode() * 530017 + this.id;
    }
}

