/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.records.TezID;

public class TezDAGID
extends TezID {
    private ApplicationId applicationId;
    public static final String DAG = "dag";
    protected static final ThreadLocal<NumberFormat> tezAppIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(4);
            return fmt;
        }
    };
    protected static final ThreadLocal<NumberFormat> tezDagIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(1);
            return fmt;
        }
    };

    public TezDAGID() {
    }

    public TezDAGID(ApplicationId applicationId, int id) {
        super(id);
        if (applicationId == null) {
            throw new IllegalArgumentException("applicationId cannot be null");
        }
        this.applicationId = applicationId;
    }

    public TezDAGID(String yarnRMIdentifier, int appId, int id) {
        this(ApplicationId.newInstance((long)Long.valueOf(yarnRMIdentifier), (int)appId), id);
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TezDAGID that = (TezDAGID)o;
        return this.applicationId.equals((Object)that.applicationId);
    }

    public int compareTo(TezID o) {
        TezDAGID that = (TezDAGID)o;
        return this.applicationId.compareTo(that.applicationId);
    }

    public void readFields(DataInput in) throws IOException {
        this.applicationId = ApplicationId.newInstance((long)in.readLong(), (int)in.readInt());
        super.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.applicationId.getClusterTimestamp());
        out.writeInt(this.applicationId.getId());
        super.write(out);
    }

    public String toString() {
        return this.appendTo(new StringBuilder(DAG)).toString();
    }

    public static TezDAGID fromString(String dagId) {
        try {
            String[] split = dagId.split("_");
            String rmId = split[1];
            int appId = tezAppIdFormat.get().parse(split[2]).intValue();
            int id = tezDagIdFormat.get().parse(split[3]).intValue();
            return new TezDAGID(rmId, appId, id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return builder.append('_').append(this.applicationId.getClusterTimestamp()).append('_').append(tezAppIdFormat.get().format(this.applicationId.getId())).append('_').append(tezDagIdFormat.get().format(this.id));
    }

    public int hashCode() {
        return this.applicationId.hashCode() * 524287 + this.id;
    }
}

