/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.events;

import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.runtime.api.Event;

@InterfaceAudience.Public
public final class DataMovementEvent
extends Event {
    private final int sourceIndex;
    private int targetIndex;
    private final ByteBuffer userPayload;
    private int version;

    private DataMovementEvent(int sourceIndex, ByteBuffer userPayload) {
        this.userPayload = userPayload;
        this.sourceIndex = sourceIndex;
    }

    @InterfaceAudience.Private
    private DataMovementEvent(int sourceIndex, int targetIndex, int version, ByteBuffer userPayload) {
        this.userPayload = userPayload;
        this.sourceIndex = sourceIndex;
        this.version = version;
        this.targetIndex = targetIndex;
    }

    private DataMovementEvent(ByteBuffer userPayload) {
        this(-1, userPayload);
    }

    public static DataMovementEvent create(int sourceIndex, ByteBuffer userPayload) {
        return new DataMovementEvent(sourceIndex, userPayload);
    }

    public static DataMovementEvent create(ByteBuffer userPayload) {
        return new DataMovementEvent(userPayload);
    }

    @InterfaceAudience.Private
    public static DataMovementEvent create(int sourceIndex, int targetIndex, int version, ByteBuffer userPayload) {
        return new DataMovementEvent(sourceIndex, targetIndex, version, userPayload);
    }

    public ByteBuffer getUserPayload() {
        return this.userPayload == null ? null : this.userPayload.asReadOnlyBuffer();
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    @InterfaceAudience.Private
    public void setTargetIndex(int targetIndex) {
        this.targetIndex = targetIndex;
    }

    public int getVersion() {
        return this.version;
    }

    @InterfaceAudience.Private
    public void setVersion(int version) {
        this.version = version;
    }

    public String toString() {
        return "DataMovementEvent [sourceIndex=" + this.sourceIndex + ", targetIndex=" + this.targetIndex + ", version=" + this.version + "]";
    }
}

