/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.dag.api.records.DAGProtos;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Progress {
    DAGProtos.ProgressProtoOrBuilder proxy = null;

    Progress(DAGProtos.ProgressProtoOrBuilder proxy) {
        this.proxy = proxy;
    }

    public int getTotalTaskCount() {
        return this.proxy.getTotalTaskCount();
    }

    public int getSucceededTaskCount() {
        return this.proxy.getSucceededTaskCount();
    }

    public int getRunningTaskCount() {
        return this.proxy.getRunningTaskCount();
    }

    public int getFailedTaskCount() {
        return this.proxy.getFailedTaskCount();
    }

    public int getKilledTaskCount() {
        return this.proxy.getKilledTaskCount();
    }

    public int getFailedTaskAttemptCount() {
        return this.proxy.getFailedTaskAttemptCount();
    }

    public int getKilledTaskAttemptCount() {
        return this.proxy.getKilledTaskAttemptCount();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Progress) {
            Progress other = (Progress)obj;
            return this.getTotalTaskCount() == other.getTotalTaskCount() && this.getSucceededTaskCount() == other.getSucceededTaskCount() && this.getRunningTaskCount() == other.getRunningTaskCount() && this.getFailedTaskCount() == other.getFailedTaskCount() && this.getKilledTaskCount() == other.getKilledTaskCount() && this.getFailedTaskAttemptCount() == other.getFailedTaskAttemptCount() && this.getKilledTaskAttemptCount() == other.getKilledTaskAttemptCount();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TotalTasks: ");
        sb.append(this.getTotalTaskCount());
        sb.append(" Succeeded: ");
        sb.append(this.getSucceededTaskCount());
        sb.append(" Running: ");
        sb.append(this.getRunningTaskCount());
        sb.append(" Failed: ");
        sb.append(this.getFailedTaskCount());
        sb.append(" Killed: ");
        sb.append(this.getKilledTaskCount());
        if (this.getFailedTaskAttemptCount() > 0) {
            sb.append(" FailedTaskAttempts: ");
            sb.append(this.getFailedTaskAttemptCount());
        }
        if (this.getKilledTaskAttemptCount() > 0) {
            sb.append(" KilledTaskAttempts: ");
            sb.append(this.getKilledTaskAttemptCount());
        }
        return sb.toString();
    }
}

