/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.runtime.api.OutputCommitter;
import org.apache.tez.runtime.api.TezRootInputInitializer;

public class Vertex {
    private final String vertexName;
    private final ProcessorDescriptor processorDescriptor;
    private final int parallelism;
    private VertexLocationHint taskLocationsHint;
    private final Resource taskResource;
    private Map<String, LocalResource> taskLocalResources = new HashMap<String, LocalResource>();
    private Map<String, String> taskEnvironment = new HashMap<String, String>();
    private final List<RootInputLeafOutput<InputDescriptor>> additionalInputs = new ArrayList<RootInputLeafOutput<InputDescriptor>>();
    private final List<RootInputLeafOutput<OutputDescriptor>> additionalOutputs = new ArrayList<RootInputLeafOutput<OutputDescriptor>>();
    private VertexManagerPluginDescriptor vertexManagerPlugin;
    private final List<Vertex> inputVertices = new ArrayList<Vertex>();
    private final List<Vertex> outputVertices = new ArrayList<Vertex>();
    private final List<String> inputEdgeIds = new ArrayList<String>();
    private final List<String> outputEdgeIds = new ArrayList<String>();
    private final Map<String, VertexGroup.GroupInfo> groupInputs = Maps.newHashMap();
    private String javaOpts = "";

    public Vertex(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism, Resource taskResource) {
        this.vertexName = vertexName;
        this.processorDescriptor = processorDescriptor;
        this.parallelism = parallelism;
        this.taskResource = taskResource;
        if (parallelism < -1) {
            throw new IllegalArgumentException("Parallelism should be -1 if determined by the AM, otherwise should be >= 0");
        }
        if (taskResource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
    }

    public String getVertexName() {
        return this.vertexName;
    }

    public ProcessorDescriptor getProcessorDescriptor() {
        return this.processorDescriptor;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public Resource getTaskResource() {
        return this.taskResource;
    }

    public Vertex setTaskLocationsHint(List<VertexLocationHint.TaskLocationHint> locations) {
        if (locations == null) {
            return this;
        }
        assert (locations.size() == this.parallelism);
        this.taskLocationsHint = new VertexLocationHint(locations);
        return this;
    }

    VertexLocationHint getTaskLocationsHint() {
        return this.taskLocationsHint;
    }

    public Vertex setTaskLocalResources(Map<String, LocalResource> localResources) {
        this.taskLocalResources = localResources == null ? new HashMap<String, LocalResource>() : localResources;
        return this;
    }

    public Map<String, LocalResource> getTaskLocalResources() {
        return this.taskLocalResources;
    }

    public Vertex setTaskEnvironment(Map<String, String> environment) {
        this.taskEnvironment = environment == null ? new HashMap<String, String>() : environment;
        return this;
    }

    public Map<String, String> getTaskEnvironment() {
        return this.taskEnvironment;
    }

    public Vertex setJavaOpts(String javaOpts) {
        this.javaOpts = javaOpts;
        return this;
    }

    public Vertex addInput(String inputName, InputDescriptor inputDescriptor, Class<? extends TezRootInputInitializer> inputInitializer) {
        if (this.additionalInputs.size() == 1) {
            throw new IllegalStateException("For now, only a single Root Input can be added to a Vertex");
        }
        this.additionalInputs.add(new RootInputLeafOutput<InputDescriptor>(inputName, inputDescriptor, inputInitializer));
        return this;
    }

    public Vertex addOutput(String outputName, OutputDescriptor outputDescriptor, Class<? extends OutputCommitter> outputCommitterClazz) {
        this.additionalOutputs.add(new RootInputLeafOutput<OutputDescriptor>(outputName, outputDescriptor, outputCommitterClazz));
        return this;
    }

    Vertex addAdditionalOutput(RootInputLeafOutput<OutputDescriptor> output) {
        this.additionalOutputs.add(output);
        return this;
    }

    public Vertex addOutput(String outputName, OutputDescriptor outputDescriptor) {
        return this.addOutput(outputName, outputDescriptor, null);
    }

    public Vertex setVertexManagerPlugin(VertexManagerPluginDescriptor vertexManagerPluginDescriptor) {
        this.vertexManagerPlugin = vertexManagerPluginDescriptor;
        return this;
    }

    public String getJavaOpts() {
        return this.javaOpts;
    }

    public String toString() {
        return "[" + this.vertexName + " : " + this.processorDescriptor.getClassName() + "]";
    }

    VertexManagerPluginDescriptor getVertexManagerPlugin() {
        return this.vertexManagerPlugin;
    }

    Map<String, VertexGroup.GroupInfo> getGroupInputs() {
        return this.groupInputs;
    }

    void addGroupInput(String groupName, VertexGroup.GroupInfo groupInputInfo) {
        if (this.groupInputs.put(groupName, groupInputInfo) != null) {
            throw new IllegalStateException("Vertex: " + this.getVertexName() + " already has group input with name:" + groupName);
        }
    }

    void addInputVertex(Vertex inputVertex, Edge edge) {
        this.inputVertices.add(inputVertex);
        this.inputEdgeIds.add(edge.getId());
    }

    void addOutputVertex(Vertex outputVertex, Edge edge) {
        this.outputVertices.add(outputVertex);
        this.outputEdgeIds.add(edge.getId());
    }

    public List<Vertex> getInputVertices() {
        return Collections.unmodifiableList(this.inputVertices);
    }

    public List<Vertex> getOutputVertices() {
        return Collections.unmodifiableList(this.outputVertices);
    }

    List<String> getInputEdgeIds() {
        return this.inputEdgeIds;
    }

    List<String> getOutputEdgeIds() {
        return this.outputEdgeIds;
    }

    List<RootInputLeafOutput<InputDescriptor>> getInputs() {
        return this.additionalInputs;
    }

    List<RootInputLeafOutput<OutputDescriptor>> getOutputs() {
        return this.additionalOutputs;
    }
}

