/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.Private
public class TezYARNUtils {
    public static void setEnvFromInputString(Map<String, String> env, String envString, String classPathSeparator) {
        if (envString != null && envString.length() > 0) {
            String[] childEnvs = envString.split(",");
            Pattern p = Pattern.compile(Shell.getEnvironmentVariableRegex());
            for (String cEnv : childEnvs) {
                String[] parts = cEnv.split("=");
                Matcher m = p.matcher(parts[1]);
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    String var = m.group(1);
                    String replace = env.get(var);
                    if (replace == null) {
                        replace = System.getenv(var);
                    }
                    if (replace == null) {
                        replace = "";
                    }
                    m.appendReplacement(sb, Matcher.quoteReplacement(replace));
                }
                m.appendTail(sb);
                TezYARNUtils.addToEnvironment(env, parts[0], sb.toString(), classPathSeparator);
            }
        }
    }

    public static void addToEnvironment(Map<String, String> environment, String variable, String value, String classPathSeparator) {
        String val = environment.get(variable);
        val = val == null ? value : val + classPathSeparator + value;
        environment.put(StringInterner.weakIntern((String)variable), StringInterner.weakIntern((String)val));
    }
}

