/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.rpc.DAGClientRPCImpl;

public class TezClient {
    private static final Log LOG = LogFactory.getLog(TezClient.class);
    private final TezConfiguration conf;
    private final YarnConfiguration yarnConf;
    private YarnClient yarnClient;
    Map<String, LocalResource> tezJarResources = null;
    private JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    private static final char SEPARATOR = '_';
    private static final String DAG = "dag";
    private static final ThreadLocal<NumberFormat> idFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(6);
            return fmt;
        }
    };

    public TezClient(TezConfiguration conf) {
        this.conf = conf;
        this.yarnConf = new YarnConfiguration((Configuration)conf);
        this.yarnClient = new YarnClientImpl();
        this.yarnClient.init((Configuration)this.yarnConf);
        this.yarnClient.start();
    }

    public DAGClient submitDAGApplication(DAG dag, AMConfiguration amConfig) throws TezException, IOException {
        ApplicationId appId = this.createApplication();
        return this.submitDAGApplication(appId, dag, amConfig);
    }

    @InterfaceAudience.Private
    public DAGClient submitDAGApplication(ApplicationId appId, DAG dag, AMConfiguration amConfig) throws TezException, IOException {
        try {
            Credentials credentials = amConfig.getCredentials();
            if (credentials == null) {
                credentials = new Credentials();
            }
            TezClientUtils.processTezLocalCredentialsFile(credentials, this.conf);
            TezClientUtils.createSessionToken(appId.toString(), this.jobTokenSecretManager, credentials);
            Map<String, LocalResource> tezJarResources = this.getTezJarResources(credentials);
            ApplicationSubmissionContext appContext = TezClientUtils.createApplicationSubmissionContext(this.conf, appId, dag, dag.getName(), amConfig, tezJarResources, credentials);
            LOG.info((Object)("Submitting DAG to YARN, applicationId=" + appId));
            this.yarnClient.submitApplication(appContext);
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
        return this.getDAGClient(appId);
    }

    public ApplicationId createApplication() throws TezException, IOException {
        try {
            return this.yarnClient.createApplication().getNewApplicationResponse().getApplicationId();
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
    }

    private synchronized Map<String, LocalResource> getTezJarResources(Credentials credentials) throws IOException {
        if (this.tezJarResources == null) {
            this.tezJarResources = TezClientUtils.setupTezJarsLocalResources(this.conf, credentials);
        }
        return this.tezJarResources;
    }

    @InterfaceAudience.Private
    public DAGClient getDAGClient(ApplicationId appId) throws IOException, TezException {
        return new DAGClientRPCImpl(appId, this.getDefaultTezDAGID(appId), this.conf);
    }

    String getDefaultTezDAGID(ApplicationId appId) {
        return DAG + '_' + appId.getClusterTimestamp() + '_' + appId.getId() + '_' + idFormat.get().format(1L);
    }
}

