/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public abstract class TezEntityDescriptor
implements Writable {
    protected byte[] userPayload;
    private String className;

    @InterfaceAudience.Private
    public TezEntityDescriptor() {
    }

    public TezEntityDescriptor(String className) {
        this.className = className;
    }

    public byte[] getUserPayload() {
        return this.userPayload;
    }

    public TezEntityDescriptor setUserPayload(byte[] userPayload) {
        this.userPayload = userPayload;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.className);
        if (this.userPayload == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.userPayload.length);
            out.write(this.userPayload);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.className = Text.readString((DataInput)in);
        int payloadLength = in.readInt();
        if (payloadLength != -1) {
            this.userPayload = new byte[payloadLength];
            in.readFully(this.userPayload);
        }
    }
}

