/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.tez.runtime.api.events;

import org.apache.tez.runtime.api.Event;

/**
 * Event generated by an Input to indicate error when trying to retrieve data.
 * This is not necessarily a fatal event - it's an indication to the AM to retry
 * source data generation.
 */
public final class InputReadErrorEvent extends Event {

  /**
   * Diagnostics/trace of the error that occurred on the Input's edge.
   */
  private final String diagnostics;

  /**
   * Index of the physical edge on which the error occurred.
   */
  private final int index;

  /**
   * Version of the data on which the error occurred.
   */
  private final int version;

  public InputReadErrorEvent(String diagnostics, int index,
      int version) {
    super();
    this.diagnostics = diagnostics;
    this.index = index;
    this.version = version;
  }

  public String getDiagnostics() {
    return diagnostics;
  }

  public int getIndex() {
    return index;
  }

  public int getVersion() {
    return version;
  }

}
