/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client.rpc;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.api.records.DAGProtos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAGClientRPCImpl
implements DAGClient {
    private static final Log LOG = LogFactory.getLog(DAGClientRPCImpl.class);
    private final ApplicationId appId;
    private final String dagId;
    private final TezConfiguration conf;
    private ApplicationReport appReport;
    private YarnClient yarnClient;
    private DAGClientAMProtocolBlockingPB proxy = null;

    public DAGClientRPCImpl(ApplicationId appId, String dagId, TezConfiguration conf) {
        this.appId = appId;
        this.dagId = dagId;
        this.conf = conf;
        this.yarnClient = new YarnClientImpl();
        this.yarnClient.init((Configuration)new YarnConfiguration((Configuration)conf));
        this.yarnClient.start();
        this.appReport = null;
    }

    @Override
    public ApplicationId getApplicationId() {
        return this.appId;
    }

    @Override
    public DAGStatus getDAGStatus(Set<StatusGetOpts> statusOptions) throws IOException, TezException {
        if (this.createAMProxyIfNeeded()) {
            try {
                return this.getDAGStatusViaAM(statusOptions);
            }
            catch (TezException e) {
                this.resetProxy(e);
            }
        }
        return this.getDAGStatusViaRM();
    }

    @Override
    public VertexStatus getVertexStatus(String vertexName, Set<StatusGetOpts> statusOptions) throws IOException, TezException {
        if (this.createAMProxyIfNeeded()) {
            try {
                return this.getVertexStatusViaAM(vertexName, statusOptions);
            }
            catch (TezException e) {
                this.resetProxy(e);
            }
        }
        return null;
    }

    @Override
    public void tryKillDAG() throws TezException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("TryKill for app: " + this.appId + " dag:" + this.dagId));
        }
        if (this.createAMProxyIfNeeded()) {
            DAGClientAMProtocolRPC.TryKillDAGRequestProto requestProto = DAGClientAMProtocolRPC.TryKillDAGRequestProto.newBuilder().setDagId(this.dagId).build();
            try {
                this.proxy.tryKillDAG(null, requestProto);
            }
            catch (ServiceException e) {
                this.resetProxy((Exception)((Object)e));
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy);
        }
        if (this.yarnClient != null) {
            this.yarnClient.stop();
        }
    }

    @Override
    public ApplicationReport getApplicationReport() {
        return this.appReport;
    }

    void resetProxy(Exception e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resetting AM proxy for app: " + this.appId + " dag:" + this.dagId + " due to exception :"), (Throwable)e);
        }
        this.proxy = null;
    }

    DAGStatus getDAGStatusViaAM(Set<StatusGetOpts> statusOptions) throws IOException, TezException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GetDAGStatus via AM for app: " + this.appId + " dag:" + this.dagId));
        }
        DAGClientAMProtocolRPC.GetDAGStatusRequestProto.Builder requestProtoBuilder = DAGClientAMProtocolRPC.GetDAGStatusRequestProto.newBuilder().setDagId(this.dagId);
        if (statusOptions != null) {
            requestProtoBuilder.addAllStatusOptions(DagTypeConverters.convertStatusGetOptsToProto(statusOptions));
        }
        try {
            return new DAGStatus(this.proxy.getDAGStatus(null, requestProtoBuilder.build()).getDagStatus());
        }
        catch (ServiceException e) {
            throw new TezException(e);
        }
    }

    DAGStatus getDAGStatusViaRM() throws TezException, IOException {
        DAGProtos.DAGStatusStateProto dagState;
        ApplicationReport appReport;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GetDAGStatus via AM for app: " + this.appId + " dag:" + this.dagId));
        }
        try {
            appReport = this.yarnClient.getApplicationReport(this.appId);
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
        if (appReport == null) {
            throw new TezException("Unknown/Invalid appId: " + this.appId);
        }
        DAGProtos.DAGStatusProto.Builder builder = DAGProtos.DAGStatusProto.newBuilder();
        DAGStatus dagStatus = new DAGStatus(builder);
        block1 : switch (appReport.getYarnApplicationState()) {
            case NEW: 
            case NEW_SAVING: 
            case SUBMITTED: 
            case ACCEPTED: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_SUBMITTED;
                break;
            }
            case RUNNING: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_RUNNING;
                break;
            }
            case FAILED: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_FAILED;
                break;
            }
            case KILLED: {
                dagState = DAGProtos.DAGStatusStateProto.DAG_KILLED;
                break;
            }
            case FINISHED: {
                switch (appReport.getFinalApplicationStatus()) {
                    case UNDEFINED: 
                    case FAILED: {
                        dagState = DAGProtos.DAGStatusStateProto.DAG_FAILED;
                        break block1;
                    }
                    case KILLED: {
                        dagState = DAGProtos.DAGStatusStateProto.DAG_KILLED;
                        break block1;
                    }
                    case SUCCEEDED: {
                        dagState = DAGProtos.DAGStatusStateProto.DAG_SUCCEEDED;
                        break block1;
                    }
                }
                throw new TezUncheckedException("Encountered unknown final application status from YARN, appState=" + appReport.getYarnApplicationState() + ", finalStatus=" + appReport.getFinalApplicationStatus());
            }
            default: {
                throw new TezUncheckedException("Encountered unknown application state from YARN, appState=" + appReport.getYarnApplicationState());
            }
        }
        builder.setState(dagState);
        if (appReport.getDiagnostics() != null) {
            builder.addAllDiagnostics(Collections.singleton(appReport.getDiagnostics()));
        }
        return dagStatus;
    }

    VertexStatus getVertexStatusViaAM(String vertexName, Set<StatusGetOpts> statusOptions) throws TezException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GetVertexStatus via AM for app: " + this.appId + " dag: " + this.dagId + " vertex: " + vertexName));
        }
        DAGClientAMProtocolRPC.GetVertexStatusRequestProto.Builder requestProtoBuilder = DAGClientAMProtocolRPC.GetVertexStatusRequestProto.newBuilder().setDagId(this.dagId).setVertexName(vertexName);
        if (statusOptions != null) {
            requestProtoBuilder.addAllStatusOptions(DagTypeConverters.convertStatusGetOptsToProto(statusOptions));
        }
        try {
            return new VertexStatus(this.proxy.getVertexStatus(null, requestProtoBuilder.build()).getVertexStatus());
        }
        catch (ServiceException e) {
            throw new TezException(e);
        }
    }

    ApplicationReport getAppReport() throws IOException, TezException {
        try {
            ApplicationReport appReport = this.yarnClient.getApplicationReport(this.appId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("App: " + this.appId + " in state: " + appReport.getYarnApplicationState()));
            }
            return appReport;
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
    }

    boolean createAMProxyIfNeeded() throws IOException, TezException {
        if (this.proxy != null) {
            return true;
        }
        this.appReport = this.getAppReport();
        if (this.appReport == null) {
            return false;
        }
        YarnApplicationState appState = this.appReport.getYarnApplicationState();
        if (appState != YarnApplicationState.RUNNING) {
            return false;
        }
        if (this.appReport.getHost() == null || this.appReport.getHost().equals("N/A") || this.appReport.getRpcPort() == 0) {
            return false;
        }
        this.proxy = TezClientUtils.getAMProxy(this.conf, this.appReport.getHost(), this.appReport.getRpcPort(), this.appReport.getClientToAMToken());
        return true;
    }
}

