/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.runtime.api.TezRootInputInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vertex {
    private final String vertexName;
    private final ProcessorDescriptor processorDescriptor;
    private final int parallelism;
    private VertexLocationHint taskLocationsHint;
    private final Resource taskResource;
    private Map<String, LocalResource> taskLocalResources;
    private Map<String, String> taskEnvironment;
    private final List<RootInputLeafOutput<InputDescriptor>> additionalInputs = new ArrayList<RootInputLeafOutput<InputDescriptor>>();
    private final List<RootInputLeafOutput<OutputDescriptor>> additionalOutputs = new ArrayList<RootInputLeafOutput<OutputDescriptor>>();
    private final List<Vertex> inputVertices = new ArrayList<Vertex>();
    private final List<Vertex> outputVertices = new ArrayList<Vertex>();
    private final List<String> inputEdgeIds = new ArrayList<String>();
    private final List<String> outputEdgeIds = new ArrayList<String>();
    private String javaOpts = "";

    public Vertex(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism, Resource taskResource) {
        this.vertexName = vertexName;
        this.processorDescriptor = processorDescriptor;
        this.parallelism = parallelism;
        this.taskResource = taskResource;
        if (parallelism < -1) {
            throw new IllegalArgumentException("Parallelism should be -1 if determined by the AM, otherwise should be >= 0");
        }
        if (taskResource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
    }

    public String getVertexName() {
        return this.vertexName;
    }

    public ProcessorDescriptor getProcessorDescriptor() {
        return this.processorDescriptor;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public Resource getTaskResource() {
        return this.taskResource;
    }

    public Vertex setTaskLocationsHint(List<VertexLocationHint.TaskLocationHint> locations) {
        if (locations == null) {
            return this;
        }
        assert (locations.size() == this.parallelism);
        this.taskLocationsHint = new VertexLocationHint(this.parallelism, locations);
        return this;
    }

    VertexLocationHint getTaskLocationsHint() {
        return this.taskLocationsHint;
    }

    public Vertex setTaskLocalResources(Map<String, LocalResource> localResources) {
        this.taskLocalResources = localResources;
        return this;
    }

    public Map<String, LocalResource> getTaskLocalResources() {
        return this.taskLocalResources;
    }

    public Vertex setTaskEnvironment(Map<String, String> environment) {
        this.taskEnvironment = environment;
        return this;
    }

    public Map<String, String> getTaskEnvironment() {
        return this.taskEnvironment;
    }

    public Vertex setJavaOpts(String javaOpts) {
        this.javaOpts = javaOpts;
        return this;
    }

    public Vertex addInput(String inputName, InputDescriptor inputDescriptor, Class<? extends TezRootInputInitializer> inputInitializer) {
        if (this.additionalInputs.size() == 1) {
            throw new IllegalStateException("For now, only a single Root Input can be added to a Vertex");
        }
        this.additionalInputs.add(new RootInputLeafOutput<InputDescriptor>(inputName, inputDescriptor, inputInitializer));
        return this;
    }

    public Vertex addOutput(String outputName, OutputDescriptor outputDescriptor) {
        this.additionalOutputs.add(new RootInputLeafOutput<OutputDescriptor>(outputName, outputDescriptor, null));
        return this;
    }

    public String getJavaOpts() {
        return this.javaOpts;
    }

    public String toString() {
        return "[" + this.vertexName + " : " + this.processorDescriptor.getClassName() + "]";
    }

    void addInputVertex(Vertex inputVertex, String edgeId) {
        this.inputVertices.add(inputVertex);
        this.inputEdgeIds.add(edgeId);
    }

    void addOutputVertex(Vertex outputVertex, String edgeId) {
        this.outputVertices.add(outputVertex);
        this.outputEdgeIds.add(edgeId);
    }

    public List<Vertex> getInputVertices() {
        return Collections.unmodifiableList(this.inputVertices);
    }

    public List<Vertex> getOutputVertices() {
        return Collections.unmodifiableList(this.outputVertices);
    }

    List<String> getInputEdgeIds() {
        return this.inputEdgeIds;
    }

    List<String> getOutputEdgeIds() {
        return this.outputEdgeIds;
    }

    List<RootInputLeafOutput<InputDescriptor>> getInputs() {
        return this.additionalInputs;
    }

    List<RootInputLeafOutput<OutputDescriptor>> getOutputs() {
        return this.additionalOutputs;
    }
}

