/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.TezEntityDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.records.DAGProtos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAG {
    final BiMap<String, Vertex> vertices = HashBiMap.create();
    final List<Edge> edges = new ArrayList<Edge>();
    final String name;

    public DAG(String name) {
        this.name = name;
    }

    public synchronized DAG addVertex(Vertex vertex) {
        if (this.vertices.containsKey((Object)vertex.getVertexName())) {
            throw new IllegalStateException("Vertex " + vertex.getVertexName() + " already defined!");
        }
        this.vertices.put((Object)vertex.getVertexName(), (Object)vertex);
        return this;
    }

    public synchronized Vertex getVertex(String vertexName) {
        return (Vertex)this.vertices.get((Object)vertexName);
    }

    @InterfaceAudience.Private
    public synchronized Set<Vertex> getVertices() {
        return Collections.unmodifiableSet(this.vertices.values());
    }

    public synchronized DAG addEdge(Edge edge) {
        if (!this.vertices.containsValue((Object)edge.getInputVertex())) {
            throw new IllegalArgumentException("Input vertex " + edge.getInputVertex() + " doesn't exist!");
        }
        if (!this.vertices.containsValue((Object)edge.getOutputVertex())) {
            throw new IllegalArgumentException("Output vertex " + edge.getOutputVertex() + " doesn't exist!");
        }
        if (this.edges.contains(edge)) {
            throw new IllegalArgumentException("Edge " + edge + " already defined!");
        }
        edge.getInputVertex().addOutputVertex(edge.getOutputVertex(), edge.getId());
        edge.getOutputVertex().addInputVertex(edge.getInputVertex(), edge.getId());
        this.edges.add(edge);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void verify() throws IllegalStateException {
        this.verify(true);
    }

    /*
     * WARNING - void declaration
     */
    public void verify(boolean restricted) throws IllegalStateException {
        Vertex vertex;
        if (this.vertices.isEmpty()) {
            throw new IllegalStateException("Invalid dag containing 0 vertices");
        }
        HashMap<String, AnnotatedVertex> vertexMap = new HashMap<String, AnnotatedVertex>();
        HashMap<Vertex, HashSet<String>> inboundVertexMap = new HashMap<Vertex, HashSet<String>>();
        HashMap<Vertex, HashSet<String>> outboundVertexMap = new HashMap<Vertex, HashSet<String>>();
        for (Vertex v : this.vertices.values()) {
            if (vertexMap.containsKey(v.getVertexName())) {
                throw new IllegalStateException("DAG contains multiple vertices with name: " + v.getVertexName());
            }
            vertexMap.put(v.getVertexName(), new AnnotatedVertex(v));
        }
        HashMap<Vertex, List<Edge>> edgeMap = new HashMap<Vertex, List<Edge>>();
        for (Edge edge : this.edges) {
            void var10_25;
            Vertex inputVertex = edge.getInputVertex();
            Vertex vertex2 = edge.getOutputVertex();
            List list = (List)edgeMap.get(inputVertex);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                edgeMap.put(inputVertex, arrayList);
            }
            var10_25.add(edge);
            HashSet<String> inboundSet = (HashSet<String>)inboundVertexMap.get(vertex2);
            if (inboundSet == null) {
                inboundSet = new HashSet<String>();
                inboundVertexMap.put(vertex2, inboundSet);
            }
            inboundSet.add(inputVertex.getVertexName());
            HashSet<String> outboundSet = (HashSet<String>)outboundVertexMap.get(inputVertex);
            if (outboundSet == null) {
                outboundSet = new HashSet<String>();
                outboundVertexMap.put(inputVertex, outboundSet);
            }
            outboundSet.add(vertex2.getVertexName());
        }
        for (Vertex vertex3 : this.vertices.values()) {
            for (RootInputLeafOutput<InputDescriptor> rootInputLeafOutput : vertex3.getInputs()) {
                if (!vertexMap.containsKey(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex3.getVertexName() + " contains an Input with the same name as vertex: " + rootInputLeafOutput.getName());
            }
            for (RootInputLeafOutput<TezEntityDescriptor> rootInputLeafOutput : vertex3.getOutputs()) {
                if (!vertexMap.containsKey(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex3.getVertexName() + " contains an Output with the same name as vertex: " + rootInputLeafOutput.getName());
            }
        }
        for (Map.Entry entry : inboundVertexMap.entrySet()) {
            vertex = (Vertex)entry.getKey();
            for (RootInputLeafOutput<InputDescriptor> rootInputLeafOutput : vertex.getInputs()) {
                if (!((Set)entry.getValue()).contains(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex.getVertexName() + " contains an incoming vertex and Input with the same name: " + rootInputLeafOutput.getName());
            }
        }
        for (Map.Entry entry : outboundVertexMap.entrySet()) {
            vertex = (Vertex)entry.getKey();
            for (RootInputLeafOutput<OutputDescriptor> rootInputLeafOutput : vertex.getOutputs()) {
                if (!((Set)entry.getValue()).contains(rootInputLeafOutput.getName())) continue;
                throw new IllegalStateException("Vertex: " + vertex.getVertexName() + " contains an outgoing vertex and Output with the same name: " + rootInputLeafOutput.getName());
            }
        }
        this.detectCycles(edgeMap, vertexMap);
        if (restricted) {
            for (Edge edge : this.edges) {
                ++((AnnotatedVertex)vertexMap.get((Object)edge.getInputVertex().getVertexName())).outDegree;
                if (edge.getEdgeProperty().getDataSourceType() != EdgeProperty.DataSourceType.PERSISTED) {
                    throw new IllegalStateException("Unsupported source type on edge. " + edge);
                }
                if (edge.getEdgeProperty().getSchedulingType() == EdgeProperty.SchedulingType.SEQUENTIAL) continue;
                throw new IllegalStateException("Unsupported scheduling type on edge. " + edge);
            }
        }
    }

    private void detectCycles(Map<Vertex, List<Edge>> edgeMap, Map<String, AnnotatedVertex> vertexMap) throws IllegalStateException {
        Integer nextIndex = 0;
        Stack<AnnotatedVertex> stack = new Stack<AnnotatedVertex>();
        for (AnnotatedVertex av : vertexMap.values()) {
            if (av.index != -1) continue;
            assert (stack.empty());
            this.strongConnect(av, vertexMap, edgeMap, stack, nextIndex);
        }
    }

    private void strongConnect(AnnotatedVertex av, Map<String, AnnotatedVertex> vertexMap, Map<Vertex, List<Edge>> edgeMap, Stack<AnnotatedVertex> stack, Integer nextIndex) throws IllegalStateException {
        av.index = nextIndex;
        av.lowlink = nextIndex;
        Integer n = nextIndex;
        Integer n2 = nextIndex = Integer.valueOf(nextIndex + 1);
        stack.push(av);
        av.onstack = true;
        List<Edge> edges = edgeMap.get(av.v);
        if (edges != null) {
            for (Edge e : edgeMap.get(av.v)) {
                AnnotatedVertex outVertex = vertexMap.get(e.getOutputVertex().getVertexName());
                if (outVertex.index == -1) {
                    this.strongConnect(outVertex, vertexMap, edgeMap, stack, nextIndex);
                    av.lowlink = Math.min(av.lowlink, outVertex.lowlink);
                    continue;
                }
                if (!outVertex.onstack) continue;
                av.lowlink = Math.min(av.lowlink, outVertex.index);
            }
        }
        if (av.lowlink == av.index) {
            AnnotatedVertex pop = stack.pop();
            pop.onstack = false;
            if (pop != av) {
                StringBuilder message = new StringBuilder();
                message.append(av.v.getVertexName() + " <- ");
                while (pop != av) {
                    message.append(pop.v.getVertexName() + " <- ");
                    pop.onstack = false;
                    pop = stack.pop();
                }
                message.append(av.v.getVertexName());
                throw new IllegalStateException("DAG contains a cycle: " + message);
            }
        }
    }

    @InterfaceAudience.Private
    public DAGProtos.DAGPlan createDag(Configuration dagConf) {
        this.verify(true);
        DAGProtos.DAGPlan.Builder dagBuilder = DAGProtos.DAGPlan.newBuilder();
        dagBuilder.setName(this.name);
        for (Vertex vertex : this.vertices.values()) {
            DAGProtos.VertexPlan.Builder vertexBuilder = DAGProtos.VertexPlan.newBuilder();
            vertexBuilder.setName(vertex.getVertexName());
            vertexBuilder.setType(DAGProtos.PlanVertexType.NORMAL);
            vertexBuilder.setProcessorDescriptor(DagTypeConverters.convertToDAGPlan(vertex.getProcessorDescriptor()));
            if (vertex.getInputs().size() > 0) {
                for (RootInputLeafOutput<InputDescriptor> rootInputLeafOutput : vertex.getInputs()) {
                    vertexBuilder.addInputs(DagTypeConverters.convertToDAGPlan(rootInputLeafOutput));
                }
            }
            if (vertex.getOutputs().size() > 0) {
                for (RootInputLeafOutput<TezEntityDescriptor> rootInputLeafOutput : vertex.getOutputs()) {
                    vertexBuilder.addOutputs(DagTypeConverters.convertToDAGPlan(rootInputLeafOutput));
                }
            }
            DAGProtos.PlanTaskConfiguration.Builder taskConfigBuilder = DAGProtos.PlanTaskConfiguration.newBuilder();
            Resource resource = vertex.getTaskResource();
            taskConfigBuilder.setNumTasks(vertex.getParallelism());
            taskConfigBuilder.setMemoryMb(resource.getMemory());
            taskConfigBuilder.setVirtualCores(resource.getVirtualCores());
            taskConfigBuilder.setJavaOpts(vertex.getJavaOpts());
            taskConfigBuilder.setTaskModule(vertex.getVertexName());
            DAGProtos.PlanLocalResource.Builder localResourcesBuilder = DAGProtos.PlanLocalResource.newBuilder();
            if (vertex.getTaskLocalResources() != null) {
                localResourcesBuilder.clear();
                for (Map.Entry entry : vertex.getTaskLocalResources().entrySet()) {
                    String key = (String)entry.getKey();
                    LocalResource lr = (LocalResource)entry.getValue();
                    localResourcesBuilder.setName(key);
                    localResourcesBuilder.setUri(DagTypeConverters.convertToDAGPlan(lr.getResource()));
                    localResourcesBuilder.setSize(lr.getSize());
                    localResourcesBuilder.setTimeStamp(lr.getTimestamp());
                    localResourcesBuilder.setType(DagTypeConverters.convertToDAGPlan(lr.getType()));
                    localResourcesBuilder.setVisibility(DagTypeConverters.convertToDAGPlan(lr.getVisibility()));
                    if (lr.getType() == LocalResourceType.PATTERN) {
                        if (lr.getPattern() == null || lr.getPattern().isEmpty()) {
                            throw new TezUncheckedException("LocalResource type set to pattern but pattern is null or empty");
                        }
                        localResourcesBuilder.setPattern(lr.getPattern());
                    }
                    taskConfigBuilder.addLocalResource(localResourcesBuilder);
                }
            }
            if (vertex.getTaskEnvironment() != null) {
                for (String string : vertex.getTaskEnvironment().keySet()) {
                    DAGProtos.PlanKeyValuePair.Builder envSettingBuilder = DAGProtos.PlanKeyValuePair.newBuilder();
                    envSettingBuilder.setKey(string);
                    envSettingBuilder.setValue(vertex.getTaskEnvironment().get(string));
                    taskConfigBuilder.addEnvironmentSetting(envSettingBuilder);
                }
            }
            if (vertex.getTaskLocationsHint() != null && vertex.getTaskLocationsHint().getTaskLocationHints() != null) {
                for (VertexLocationHint.TaskLocationHint taskLocationHint : vertex.getTaskLocationsHint().getTaskLocationHints()) {
                    DAGProtos.PlanTaskLocationHint.Builder taskLocationHintBuilder = DAGProtos.PlanTaskLocationHint.newBuilder();
                    if (taskLocationHint.getDataLocalHosts() != null) {
                        taskLocationHintBuilder.addAllHost(taskLocationHint.getDataLocalHosts());
                    }
                    if (taskLocationHint.getRacks() != null) {
                        taskLocationHintBuilder.addAllRack(taskLocationHint.getRacks());
                    }
                    vertexBuilder.addTaskLocationHint(taskLocationHintBuilder);
                }
            }
            for (String string : vertex.getInputEdgeIds()) {
                vertexBuilder.addInEdgeId(string);
            }
            for (String string : vertex.getOutputEdgeIds()) {
                vertexBuilder.addOutEdgeId(string);
            }
            vertexBuilder.setTaskConfig(taskConfigBuilder);
            dagBuilder.addVertex(vertexBuilder);
        }
        for (Edge edge : this.edges) {
            DAGProtos.EdgePlan.Builder edgeBuilder = DAGProtos.EdgePlan.newBuilder();
            edgeBuilder.setId(edge.getId());
            edgeBuilder.setInputVertexName(edge.getInputVertex().getVertexName());
            edgeBuilder.setOutputVertexName(edge.getOutputVertex().getVertexName());
            edgeBuilder.setDataMovementType(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getDataMovementType()));
            edgeBuilder.setDataSourceType(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getDataSourceType()));
            edgeBuilder.setSchedulingType(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getSchedulingType()));
            edgeBuilder.setEdgeSource(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getEdgeSource()));
            edgeBuilder.setEdgeDestination(DagTypeConverters.convertToDAGPlan(edge.getEdgeProperty().getEdgeDestination()));
            dagBuilder.addEdge(edgeBuilder);
        }
        if (dagConf != null) {
            Iterator iter = dagConf.iterator();
            DAGProtos.ConfigurationProto.Builder confProtoBuilder = DAGProtos.ConfigurationProto.newBuilder();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                DAGProtos.PlanKeyValuePair.Builder kvp = DAGProtos.PlanKeyValuePair.newBuilder();
                kvp.setKey((String)entry.getKey());
                kvp.setValue((String)entry.getValue());
                confProtoBuilder.addConfKeyValues(kvp);
            }
            dagBuilder.setDagKeyValues(confProtoBuilder);
        }
        return dagBuilder.build();
    }

    private static class AnnotatedVertex {
        Vertex v;
        int index;
        int lowlink;
        boolean onstack;
        int outDegree;

        private AnnotatedVertex(Vertex v) {
            this.v = v;
            this.index = -1;
            this.lowlink = -1;
            this.outDegree = 0;
        }
    }
}

