/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import java.io.IOException;
import java.util.Map;
import org.apache.tapestry5.internal.webresources.ResourceTransformUtils;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.assets.ResourceDependencies;

public class ContentChangeTracker
implements ResourceDependencies {
    private final Map<Resource, Long> checksums = CollectionFactory.newMap();

    public void addDependency(Resource dependency) {
        long checksum = ResourceTransformUtils.toChecksum(dependency);
        this.checksums.put(dependency, checksum);
    }

    public boolean dirty() throws IOException {
        for (Map.Entry<Resource, Long> e : this.checksums.entrySet()) {
            long current = ResourceTransformUtils.toChecksum(e.getKey());
            if (current == e.getValue()) continue;
            return true;
        }
        return false;
    }
}

