/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.HttpCommandProcessor;
import com.thoughtworks.selenium.Selenium;
import java.io.File;
import java.util.Map;
import org.apache.tapestry5.test.ErrorReporterImpl;
import org.apache.tapestry5.test.ErrorReportingCommandProcessor;
import org.apache.tapestry5.test.Jetty7Runner;
import org.apache.tapestry5.test.TapestryTestConstants;
import org.openqa.selenium.server.SeleniumServer;
import org.testng.ITestContext;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.xml.XmlTest;

public class SeleniumLauncher {
    private SeleniumServer seleniumServer;
    private Selenium selenium;
    private Runnable stopWebServer;

    @Parameters(value={"tapestry.web-app-folder", "tapestry.context-path", "tapestry.port", "tapestry.ssl-port", "tapestry.browser-start-command"})
    @BeforeTest(dependsOnGroups={"beforeStartup"})
    public synchronized void startup(@Optional(value="src/main/webapp") String webAppFolder, @Optional(value="") String contextPath, @Optional(value="9090") int port, @Optional(value="8443") int sslPort, @Optional(value="*firefox") String browserStartCommand, ITestContext testContext, XmlTest xmlTest) throws Exception {
        Map testParameters = xmlTest.getParameters();
        if (testParameters.containsKey("tapestry.web-app-folder")) {
            webAppFolder = (String)testParameters.get("tapestry.web-app-folder");
        }
        if (testParameters.containsKey("tapestry.context-path")) {
            contextPath = (String)testParameters.get("tapestry.context-path");
        }
        if (testParameters.containsKey("tapestry.port")) {
            port = Integer.parseInt((String)testParameters.get("tapestry.port"));
        }
        if (testParameters.containsKey("tapestry.browser-start-command")) {
            browserStartCommand = (String)testParameters.get("tapestry.browser-start-command");
        }
        this.stopWebServer = this.launchWebServer(webAppFolder, contextPath, port, sslPort);
        this.seleniumServer = new SeleniumServer();
        File ffProfileTemplate = new File(TapestryTestConstants.MODULE_BASE_DIR, "src/test/conf/ff_profile_template");
        if (ffProfileTemplate.isDirectory()) {
            this.seleniumServer.getConfiguration().setFirefoxProfileTemplate(ffProfileTemplate);
        }
        this.seleniumServer.start();
        String baseURL = String.format("http://localhost:%d%s/", port, contextPath);
        HttpCommandProcessor cp = new HttpCommandProcessor("localhost", 4444, browserStartCommand, baseURL);
        ErrorReporterImpl errorReporter = new ErrorReporterImpl((CommandProcessor)cp, testContext);
        this.selenium = new DefaultSelenium((CommandProcessor)new ErrorReportingCommandProcessor((CommandProcessor)cp, errorReporter));
        this.selenium.start();
        testContext.setAttribute("tapestry.base-url", (Object)baseURL);
        testContext.setAttribute("tapestry.selenium", (Object)this.selenium);
        testContext.setAttribute("tapestry.error-reporter", (Object)errorReporter);
    }

    @AfterTest
    public synchronized void cleanup() {
        if (this.selenium != null) {
            this.selenium.stop();
            this.selenium = null;
        }
        if (this.seleniumServer != null) {
            this.seleniumServer.stop();
            this.seleniumServer = null;
        }
        if (this.stopWebServer != null) {
            this.stopWebServer.run();
            this.stopWebServer = null;
        }
    }

    protected Runnable launchWebServer(String webAppFolder, String contextPath, int port, int sslPort) throws Exception {
        final Jetty7Runner runner = new Jetty7Runner(webAppFolder, contextPath, port, sslPort);
        return new Runnable(){

            public void run() {
                runner.stop();
            }
        };
    }
}

