/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.test;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RandomDataSource {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final Random _random = new Random(System.currentTimeMillis());
    private final List<String> _words = new ArrayList<String>();

    public static void main(String[] args) {
        new RandomDataSource();
    }

    public RandomDataSource() {
        int i;
        for (i = 0; i < 4; ++i) {
            this.readWords("english." + i);
        }
        for (i = 0; i < 3; ++i) {
            this.readWords("american." + i);
        }
        this._log.info((Object)String.format("Dictionary contains %d words", this._words.size()));
    }

    private void readWords(String name) {
        this._log.info((Object)("Reading " + name + " ..."));
        int count = 0;
        InputStream is = this.getClass().getResourceAsStream(name);
        if (is == null) {
            throw new RuntimeException(String.format("File '%s' not found.", name));
        }
        try {
            String word;
            BufferedInputStream bis = new BufferedInputStream(is);
            InputStreamReader isr = new InputStreamReader(bis);
            LineNumberReader r = new LineNumberReader(isr);
            while ((word = r.readLine()) != null) {
                ++count;
                this._words.add(word);
            }
            r.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Error reading '%s': %s", name + ex.getMessage()), ex);
        }
        this._log.info((Object)String.format("... %d words", count));
    }

    public boolean maybe(int percent) {
        assert (percent > 0 && percent <= 100);
        return this._random.nextInt(100) < percent;
    }

    public int random(int min, int max) {
        assert (min <= max);
        return this._random.nextInt(max - min + 1) + min;
    }

    public String word() {
        int index = this._random.nextInt(this._words.size());
        return this._words.get(index);
    }

    public String capitalizedWord() {
        String word = this.word();
        char[] chars = word.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public String safeWord() {
        String word = this.word();
        int x = word.indexOf(39);
        return x < 0 ? word : word.substring(0, x);
    }

    public String oneOf(String ... values) {
        assert (values.length > 0);
        int index = this._random.nextInt(values.length);
        return values[index];
    }

    public String wordList(int minWords, int maxWords, boolean asSentence) {
        assert (minWords <= maxWords);
        assert (minWords > 0);
        StringBuilder builder = new StringBuilder();
        int count = this.random(minWords, maxWords);
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                builder.append(' ');
            }
            if (i == 0 && asSentence) {
                builder.append(this.capitalizedWord());
                continue;
            }
            builder.append(this.word());
        }
        if (asSentence) {
            builder.append('.');
        }
        return builder.toString();
    }

    public String paragraph(int minSentences, int maxSentences, int minWords, int maxWords) {
        assert (minSentences < maxSentences);
        assert (minSentences > 0);
        int count = this.random(minSentences, maxSentences);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                builder.append(' ');
            }
            builder.append(this.wordList(minWords, maxWords, true));
        }
        return builder.toString();
    }
}

