/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.test;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.HttpCommandProcessor;
import com.thoughtworks.selenium.Selenium;
import org.apache.tapestry.test.ErrorReportingCommandProcessor;
import org.apache.tapestry.test.JettyRunner;
import org.apache.tapestry.test.TapestryTestConstants;
import org.openqa.selenium.server.SeleniumServer;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class AbstractIntegrationTestSuite
extends Assert
implements Selenium {
    public static final String DEFAULT_WEB_APP_ROOT = "src/main/webapp";
    public static final String DEFAULT_WEB_BROWSER_COMMAND = "*firefox";
    public static final String PAGE_LOAD_TIMEOUT = "15000";
    public static final int JETTY_PORT = 9999;
    public static final String BASE_URL = String.format("http://localhost:%d/", 9999);
    public static final String SUBMIT = "//input[@type='submit']";
    private final String _webappRoot;
    private final String _seleniumBrowserCommand;
    private JettyRunner _jettyRunner;
    private Selenium _selenium;
    private SeleniumServer _server;

    public AbstractIntegrationTestSuite() {
        this(DEFAULT_WEB_APP_ROOT, DEFAULT_WEB_BROWSER_COMMAND);
    }

    protected AbstractIntegrationTestSuite(String webAppRoot) {
        this(webAppRoot, DEFAULT_WEB_BROWSER_COMMAND);
    }

    protected AbstractIntegrationTestSuite(String webAppRoot, String browserCommand) {
        this._webappRoot = webAppRoot;
        this._seleniumBrowserCommand = browserCommand;
    }

    protected final void assertSourcePresent(String ... expected) {
        String source = this._selenium.getHtmlSource();
        for (String snippet : expected) {
            if (source.contains(snippet)) continue;
            System.err.printf("Source content '%s' not found in:\n%s\n\n", snippet, source);
            throw new AssertionError((Object)("Page did not contain source '" + snippet + "'."));
        }
    }

    protected final void assertAttribute(String locator, String expected) {
        String actual = null;
        try {
            actual = this.getAttribute(locator);
        }
        catch (RuntimeException ex) {
            System.err.printf("Error accessing %s: %s, in:\n\n%s\n\n", locator, ex.getMessage(), this._selenium.getHtmlSource());
            throw ex;
        }
        if (actual.equals(expected)) {
            return;
        }
        System.err.printf("Text for attribute %s should be '%s' but is '%s', in:\n\n%s\n\n", locator, expected, actual, this.getHtmlSource());
        throw new AssertionError((Object)String.format("%s was '%s' not '%s'", locator, actual, expected));
    }

    protected final void assertText(String locator, String expected) {
        String actual = null;
        try {
            actual = this.getText(locator);
        }
        catch (RuntimeException ex) {
            System.err.printf("Error accessing %s: %s, in:\n\n%s\n\n", locator, ex.getMessage(), this._selenium.getHtmlSource());
            throw ex;
        }
        if (actual.equals(expected)) {
            return;
        }
        System.err.printf("Text for %s should be '%s' but is '%s', in:\n\n%s\n\n", locator, expected, actual, this.getHtmlSource());
        throw new AssertionError((Object)String.format("%s was '%s' not '%s'", locator, actual, expected));
    }

    protected final void assertTextPresent(String ... text) {
        int i$ = 0;
        String[] arr$ = text;
        int len$ = arr$.length;
        if (i$ < len$) {
            String item = arr$[i$];
            if (this.isTextPresent(item)) {
                return;
            }
            System.err.printf("Text pattern '%s' not found in:\n%s\n\n", item, this._selenium.getHtmlSource());
            throw new AssertionError((Object)("Page did not contain '" + item + "'."));
        }
    }

    protected final void assertFieldValue(String locator, String expected) {
        AbstractIntegrationTestSuite.assertEquals((String)this.getValue(locator), (String)expected);
    }

    protected final void clickAndWait(String link) {
        this.click(link);
        this.waitForPageToLoad(PAGE_LOAD_TIMEOUT);
    }

    protected final void assertTextSeries(String idFormat, int startIndex, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            String id = String.format(idFormat, startIndex + i);
            this.assertText(id, values[i]);
        }
    }

    protected final void assertAttributeSeries(String idFormat, int startIndex, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            String id = String.format(idFormat, startIndex + i);
            this.assertAttribute(id, values[i]);
        }
    }

    protected final void assertFieldValueSeries(String idFormat, int startIndex, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            String id = String.format(idFormat, startIndex + i);
            this.assertFieldValue(id, values[i]);
        }
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        this._selenium.stop();
        this._selenium = null;
        this._server.stop();
        this._server = null;
        this._jettyRunner.stop();
        this._jettyRunner = null;
    }

    @BeforeClass(alwaysRun=true)
    public void setup() throws Exception {
        this._jettyRunner = new JettyRunner(TapestryTestConstants.MODULE_BASE_DIR, "/", 9999, this._webappRoot);
        this._server = new SeleniumServer();
        this._server.start();
        HttpCommandProcessor cp = new HttpCommandProcessor("localhost", 4444, this._seleniumBrowserCommand, BASE_URL);
        this._selenium = new DefaultSelenium((CommandProcessor)new ErrorReportingCommandProcessor((CommandProcessor)cp));
        this._selenium.start();
    }

    public void addSelection(String locator, String optionLocator) {
        this._selenium.addSelection(locator, optionLocator);
    }

    public void answerOnNextPrompt(String answer) {
        this._selenium.answerOnNextPrompt(answer);
    }

    public void check(String locator) {
        this._selenium.check(locator);
    }

    public void chooseCancelOnNextConfirmation() {
        this._selenium.chooseCancelOnNextConfirmation();
    }

    public void chooseOkOnNextConfirmation() {
        this._selenium.chooseOkOnNextConfirmation();
    }

    public void click(String locator) {
        this._selenium.click(locator);
    }

    public void doubleClick(String locator) {
        this._selenium.doubleClick(locator);
    }

    public void clickAt(String locator, String coordString) {
        this._selenium.clickAt(locator, coordString);
    }

    public void doubleClickAt(String locator, String coordString) {
        this._selenium.doubleClickAt(locator, coordString);
    }

    public void close() {
        this._selenium.close();
    }

    public void fireEvent(String locator, String eventName) {
        this._selenium.fireEvent(locator, eventName);
    }

    public String getAlert() {
        return this._selenium.getAlert();
    }

    public String[] getAllButtons() {
        return this._selenium.getAllButtons();
    }

    public String[] getAllFields() {
        return this._selenium.getAllFields();
    }

    public String[] getAttributeFromAllWindows(String attributeName) {
        return this._selenium.getAttributeFromAllWindows(attributeName);
    }

    public void dragdrop(String locator, String movementsString) {
        this._selenium.dragdrop(locator, movementsString);
    }

    public void setMouseSpeed(String pixels) {
        this._selenium.setMouseSpeed(pixels);
    }

    public Number getMouseSpeed() {
        return this._selenium.getMouseSpeed();
    }

    public void dragAndDrop(String locator, String movementsString) {
        this._selenium.dragAndDrop(locator, movementsString);
    }

    public void dragAndDropToObject(String locatorOfObjectToBeDragged, String locatorOfDragDestinationObject) {
        this._selenium.dragAndDropToObject(locatorOfObjectToBeDragged, locatorOfDragDestinationObject);
    }

    public void windowFocus() {
        this._selenium.windowFocus();
    }

    public void windowMaximize() {
        this._selenium.windowMaximize();
    }

    public String[] getAllWindowIds() {
        return this._selenium.getAllWindowIds();
    }

    public String[] getAllWindowNames() {
        return this._selenium.getAllWindowNames();
    }

    public String[] getAllWindowTitles() {
        return this._selenium.getAllWindowTitles();
    }

    public String[] getAllLinks() {
        return this._selenium.getAllLinks();
    }

    public String getAttribute(String attributeLocator) {
        return this._selenium.getAttribute(attributeLocator);
    }

    public String getBodyText() {
        return this._selenium.getBodyText();
    }

    public String getConfirmation() {
        return this._selenium.getConfirmation();
    }

    public Number getCursorPosition(String locator) {
        return this._selenium.getCursorPosition(locator);
    }

    public String getEval(String script) {
        return this._selenium.getEval(script);
    }

    public String getExpression(String expression) {
        return this._selenium.getExpression(expression);
    }

    public Number getXpathCount(String xpath) {
        return this._selenium.getXpathCount(xpath);
    }

    public void assignId(String locator, String identifier) {
        this._selenium.assignId(locator, identifier);
    }

    public void allowNativeXpath(String allow) {
        this._selenium.allowNativeXpath(allow);
    }

    public String getHtmlSource() {
        return this._selenium.getHtmlSource();
    }

    public String getLocation() {
        return this._selenium.getLocation();
    }

    public String getPrompt() {
        return this._selenium.getPrompt();
    }

    public String getSelectedId(String selectLocator) {
        return this._selenium.getSelectedId(selectLocator);
    }

    public String[] getSelectedIds(String selectLocator) {
        return this._selenium.getSelectedIds(selectLocator);
    }

    public String getSelectedIndex(String selectLocator) {
        return this._selenium.getSelectedIndex(selectLocator);
    }

    public String[] getSelectedIndexes(String selectLocator) {
        return this._selenium.getSelectedIndexes(selectLocator);
    }

    public String getSelectedLabel(String selectLocator) {
        return this._selenium.getSelectedLabel(selectLocator);
    }

    public String[] getSelectedLabels(String selectLocator) {
        return this._selenium.getSelectedLabels(selectLocator);
    }

    public String getSelectedValue(String selectLocator) {
        return this._selenium.getSelectedValue(selectLocator);
    }

    public String[] getSelectedValues(String selectLocator) {
        return this._selenium.getSelectedValues(selectLocator);
    }

    public String[] getSelectOptions(String selectLocator) {
        return this._selenium.getSelectOptions(selectLocator);
    }

    public String getTable(String tableCellAddress) {
        return this._selenium.getTable(tableCellAddress);
    }

    public String getText(String locator) {
        return this._selenium.getText(locator);
    }

    public void highlight(String locator) {
        this._selenium.highlight(locator);
    }

    public String getTitle() {
        return this._selenium.getTitle();
    }

    public String getValue(String locator) {
        return this._selenium.getValue(locator);
    }

    public void goBack() {
        this._selenium.goBack();
    }

    public boolean isAlertPresent() {
        return this._selenium.isAlertPresent();
    }

    public boolean isChecked(String locator) {
        return this._selenium.isChecked(locator);
    }

    public boolean isConfirmationPresent() {
        return this._selenium.isConfirmationPresent();
    }

    public boolean isEditable(String locator) {
        return this._selenium.isEditable(locator);
    }

    public boolean isElementPresent(String locator) {
        return this._selenium.isElementPresent(locator);
    }

    public boolean isPromptPresent() {
        return this._selenium.isPromptPresent();
    }

    public boolean isSomethingSelected(String selectLocator) {
        return this._selenium.isSomethingSelected(selectLocator);
    }

    public boolean isTextPresent(String pattern) {
        return this._selenium.isTextPresent(pattern);
    }

    public boolean isVisible(String locator) {
        return this._selenium.isVisible(locator);
    }

    public void keyDown(String locator, String keycode) {
        this._selenium.keyDown(locator, keycode);
    }

    public void keyPress(String locator, String keycode) {
        this._selenium.keyPress(locator, keycode);
    }

    public void shiftKeyDown() {
        this._selenium.shiftKeyDown();
    }

    public void shiftKeyUp() {
        this._selenium.shiftKeyUp();
    }

    public void metaKeyDown() {
        this._selenium.metaKeyDown();
    }

    public void metaKeyUp() {
        this._selenium.metaKeyUp();
    }

    public void altKeyDown() {
        this._selenium.altKeyDown();
    }

    public void altKeyUp() {
        this._selenium.altKeyUp();
    }

    public void controlKeyDown() {
        this._selenium.controlKeyDown();
    }

    public void controlKeyUp() {
        this._selenium.controlKeyUp();
    }

    public void keyUp(String locator, String keycode) {
        this._selenium.keyUp(locator, keycode);
    }

    public void mouseDown(String locator) {
        this._selenium.mouseDown(locator);
    }

    public void mouseDownAt(String locator, String coordString) {
        this._selenium.mouseDownAt(locator, coordString);
    }

    public void mouseUp(String locator) {
        this._selenium.mouseUp(locator);
    }

    public void mouseUpAt(String locator, String coordString) {
        this._selenium.mouseUpAt(locator, coordString);
    }

    public void mouseMove(String locator) {
        this._selenium.mouseMove(locator);
    }

    public void mouseMoveAt(String locator, String coordString) {
        this._selenium.mouseMoveAt(locator, coordString);
    }

    public void mouseOver(String locator) {
        this._selenium.mouseOver(locator);
    }

    public void mouseOut(String locator) {
        this._selenium.mouseOut(locator);
    }

    public void open(String url) {
        this._selenium.open(url);
        this.waitForPageToLoad(PAGE_LOAD_TIMEOUT);
    }

    public void openWindow(String url, String windowID) {
        this._selenium.openWindow(url, windowID);
    }

    public void refresh() {
        this._selenium.refresh();
    }

    public void removeSelection(String locator, String optionLocator) {
        this._selenium.removeSelection(locator, optionLocator);
    }

    public void removeAllSelections(String locator) {
        this._selenium.removeAllSelections(locator);
    }

    public void select(String selectLocator, String optionLocator) {
        this._selenium.select(selectLocator, optionLocator);
    }

    public void selectWindow(String windowID) {
        this._selenium.selectWindow(windowID);
    }

    public void selectFrame(String locator) {
        this._selenium.selectFrame(locator);
    }

    public boolean getWhetherThisFrameMatchFrameExpression(String currentFrameString, String target) {
        return this._selenium.getWhetherThisFrameMatchFrameExpression(currentFrameString, target);
    }

    public boolean getWhetherThisWindowMatchWindowExpression(String currentWindowString, String target) {
        return this._selenium.getWhetherThisWindowMatchWindowExpression(currentWindowString, target);
    }

    public void setCursorPosition(String locator, String position) {
        this._selenium.setCursorPosition(locator, position);
    }

    public Number getElementIndex(String locator) {
        return this._selenium.getElementIndex(locator);
    }

    public boolean isOrdered(String locator1, String locator2) {
        return this._selenium.isOrdered(locator1, locator2);
    }

    public Number getElementPositionLeft(String locator) {
        return this._selenium.getElementPositionLeft(locator);
    }

    public Number getElementPositionTop(String locator) {
        return this._selenium.getElementPositionTop(locator);
    }

    public Number getElementWidth(String locator) {
        return this._selenium.getElementWidth(locator);
    }

    public Number getElementHeight(String locator) {
        return this._selenium.getElementHeight(locator);
    }

    public void setTimeout(String timeout) {
        this._selenium.setTimeout(timeout);
    }

    public void start() {
        this._selenium.start();
    }

    public void stop() {
        this._selenium.stop();
    }

    public void submit(String formLocator) {
        this._selenium.submit(formLocator);
    }

    public void type(String locator, String value) {
        this._selenium.type(locator, value);
    }

    public void typeKeys(String locator, String value) {
        this._selenium.typeKeys(locator, value);
    }

    public void setSpeed(String value) {
        this._selenium.setSpeed(value);
    }

    public void getSpeed() {
        this._selenium.getSpeed();
    }

    public void uncheck(String locator) {
        this._selenium.uncheck(locator);
    }

    public void waitForCondition(String script, String timeout) {
        this._selenium.waitForCondition(script, timeout);
    }

    public void waitForPageToLoad(String timeout) {
        this._selenium.waitForPageToLoad(timeout);
    }

    public void waitForFrameToLoad(String frameAddress, String timeout) {
        this._selenium.waitForFrameToLoad(frameAddress, timeout);
    }

    public String getCookie() {
        return this._selenium.getCookie();
    }

    public void createCookie(String nameValuePair, String optionsString) {
        this._selenium.createCookie(nameValuePair, optionsString);
    }

    public void deleteCookie(String name, String path) {
        this._selenium.deleteCookie(name, path);
    }

    public void setBrowserLogLevel(String logLevel) {
        this._selenium.setBrowserLogLevel(logLevel);
    }

    public void runScript(String script) {
        this._selenium.runScript(script);
    }

    public void addLocationStrategy(String strategyName, String functionDefinition) {
        this._selenium.addLocationStrategy(strategyName, functionDefinition);
    }

    public void setContext(String context) {
        this._selenium.setContext(context);
    }

    public void captureScreenshot(String filename) {
        this._selenium.captureScreenshot(filename);
    }

    public void waitForPageToLoad() {
        this.waitForPageToLoad(PAGE_LOAD_TIMEOUT);
    }

    public void waitForPopUp(String windowID, String timeout) {
        this._selenium.waitForPopUp(windowID, timeout);
    }

    protected final void start(String ... linkText) {
        this.open(BASE_URL);
        for (String s : linkText) {
            this.clickAndWait(String.format("link=%s", s));
        }
    }
}

