/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import com.javaforge.tapestry.testng.TestBase;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Locatable;
import org.apache.hivemind.Location;
import org.apache.hivemind.ModuleDescriptorProvider;
import org.apache.hivemind.Registry;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.DefaultClassResolver;
import org.apache.hivemind.impl.RegistryBuilder;
import org.apache.hivemind.impl.XmlModuleDescriptorProvider;
import org.apache.hivemind.util.URLResource;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.NestedMarkupWriter;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.json.IJSONWriter;
import org.apache.tapestry.markup.AsciiMarkupFilter;
import org.apache.tapestry.markup.JSONWriterImpl;
import org.apache.tapestry.markup.MarkupFilter;
import org.apache.tapestry.markup.MarkupWriterImpl;
import org.apache.tapestry.services.impl.DefaultResponseBuilder;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IParameterSpecification;
import org.apache.tapestry.test.Creator;
import org.apache.tapestry.web.WebRequest;
import org.easymock.EasyMock;
import org.testng.AssertJUnit;

public class BaseComponentTestCase
extends TestBase {
    private Creator _creator;
    protected CharArrayWriter _charArrayWriter;

    protected Creator getCreator() {
        if (this._creator == null) {
            this._creator = new Creator();
        }
        return this._creator;
    }

    protected ClassResolver getClassResolver() {
        return new DefaultClassResolver();
    }

    protected IMarkupWriter newBufferWriter() {
        this._charArrayWriter = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(this._charArrayWriter);
        return new MarkupWriterImpl("text/html", pw, (MarkupFilter)new AsciiMarkupFilter());
    }

    protected IJSONWriter newBufferJSONWriter() {
        this._charArrayWriter = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(this._charArrayWriter);
        return new JSONWriterImpl(pw);
    }

    protected void assertBuffer(String expected) {
        String actual = this._charArrayWriter.toString();
        AssertJUnit.assertEquals((String)"Buffered markup writer content.", (String)expected, (String)actual);
        this._charArrayWriter.reset();
    }

    protected void assertExceptionSubstring(Throwable t, String msg) {
        AssertJUnit.assertTrue((boolean)t.getMessage().contains(msg));
    }

    protected Object newInstance(Class componentClass) {
        return this.newInstance(componentClass, null);
    }

    protected Object newInstance(Class componentClass, String propertyName, Object propertyValue) {
        return this.getCreator().newInstance(componentClass, new Object[]{propertyName, propertyValue});
    }

    protected IRequestCycle newCycle() {
        return (IRequestCycle)this.newMock(IRequestCycle.class);
    }

    protected IRequestCycle newCycle(IMarkupWriter writer) {
        IRequestCycle cycle = (IRequestCycle)this.newMock(IRequestCycle.class);
        this.trainResponseBuilder(cycle, writer);
        return cycle;
    }

    protected IRequestCycle newCycle(boolean rewinding) {
        return this.newCycle(rewinding, null);
    }

    protected IRequestCycle newCycle(boolean rewinding, boolean trainWriter) {
        IRequestCycle cycle = this.newRequestCycle();
        this.trainIsRewinding(cycle, rewinding);
        if (trainWriter) {
            this.trainResponseBuilder(cycle, null);
        }
        return cycle;
    }

    protected IRequestCycle newCycle(boolean rewinding, IMarkupWriter writer) {
        IRequestCycle cycle = this.newRequestCycle();
        EasyMock.checkOrder((Object)cycle, (boolean)false);
        this.trainIsRewinding(cycle, rewinding);
        if (writer != null) {
            this.trainResponseBuilder(cycle, writer);
        }
        return cycle;
    }

    protected void trainResponseBuilder(IRequestCycle cycle, IMarkupWriter writer) {
        DefaultResponseBuilder builder = new DefaultResponseBuilder(writer == null ? NullWriter.getSharedInstance() : writer);
        EasyMock.expect((Object)cycle.getResponseBuilder()).andReturn((Object)builder);
    }

    protected void trainIsRewinding(IRequestCycle cycle, boolean rewinding) {
        EasyMock.expect((Object)cycle.isRewinding()).andReturn((Object)rewinding);
    }

    protected IRequestCycle newCycleGetPage(String pageName, IPage page) {
        IRequestCycle cycle = this.newRequestCycle();
        EasyMock.expect((Object)cycle.getPage(pageName)).andReturn((Object)page);
        return cycle;
    }

    protected IRequestCycle newCycleGetUniqueId(String id, String uniqueId) {
        IRequestCycle cycle = this.newRequestCycle();
        EasyMock.expect((Object)cycle.getUniqueId(id)).andReturn((Object)uniqueId);
        return cycle;
    }

    protected IRequestCycle newCycleGetParameter(String name, String value) {
        IRequestCycle cycle = this.newRequestCycle();
        EasyMock.expect((Object)cycle.getParameter(name)).andReturn((Object)value);
        return cycle;
    }

    protected IMarkupWriter newWriter() {
        return (IMarkupWriter)this.newMock(IMarkupWriter.class);
    }

    protected IBinding newBinding(Object value) {
        IBinding binding = (IBinding)this.newMock(IBinding.class);
        EasyMock.checkOrder((Object)binding, (boolean)false);
        EasyMock.expect((Object)binding.getObject()).andReturn(value);
        return binding;
    }

    protected IBinding newBinding(Location location) {
        IBinding binding = this.newBinding();
        EasyMock.checkOrder((Object)binding, (boolean)false);
        this.trainGetLocation((Locatable)binding, location);
        return binding;
    }

    protected IComponent newComponent(String extendedId, Location location) {
        IComponent component = (IComponent)this.newMock(IComponent.class);
        EasyMock.checkOrder((Object)component, (boolean)false);
        EasyMock.expect((Object)component.getExtendedId()).andReturn((Object)extendedId);
        EasyMock.expect((Object)component.getLocation()).andReturn((Object)location);
        return component;
    }

    protected IComponentSpecification newSpec(String parameterName, IParameterSpecification pspec) {
        IComponentSpecification spec = (IComponentSpecification)this.newMock(IComponentSpecification.class);
        EasyMock.expect((Object)spec.getParameter(parameterName)).andReturn((Object)pspec);
        return spec;
    }

    protected IRender newRender() {
        return (IRender)this.newMock(IRender.class);
    }

    protected IPage newPage() {
        return (IPage)this.newMock(IPage.class);
    }

    protected IPage newPage(String name) {
        return this.newPage(name, 1);
    }

    protected IPage newPage(String name, int count) {
        IPage page = (IPage)this.newMock(IPage.class);
        EasyMock.checkOrder((Object)page, (boolean)false);
        EasyMock.expect((Object)page.getPageName()).andReturn((Object)name).times(count);
        return page;
    }

    protected IForm newForm() {
        return (IForm)this.newMock(IForm.class);
    }

    protected IRender newBody() {
        return new IRender(){

            public void render(IMarkupWriter writer, IRequestCycle cycle) {
                writer.print("BODY");
            }
        };
    }

    protected PageRenderSupport newPageRenderSupport() {
        return (PageRenderSupport)this.newMock(PageRenderSupport.class);
    }

    protected void trainGetSupport(IRequestCycle cycle, PageRenderSupport support) {
        this.trainGetAttribute(cycle, "org.apache.tapestry.PageRenderSupport", support);
    }

    protected void trainGetAttribute(IRequestCycle cycle, String attributeName, Object attribute) {
        EasyMock.expect((Object)cycle.getAttribute(attributeName)).andReturn(attribute);
    }

    protected void trainGetUniqueId(IRequestCycle cycle, String id, String uniqueId) {
        EasyMock.expect((Object)cycle.getUniqueId(id)).andReturn((Object)uniqueId);
    }

    protected void trainGetIdPath(IComponent component, String idPath) {
        EasyMock.expect((Object)component.getIdPath()).andReturn((Object)idPath);
    }

    protected void trainGetParameter(IRequestCycle cycle, String name, String value) {
        EasyMock.expect((Object)cycle.getParameter(name)).andReturn((Object)value);
    }

    protected void trainGetPageName(IPage page, String pageName) {
        EasyMock.expect((Object)page.getPageName()).andReturn((Object)pageName);
    }

    protected void trainBuildURL(IAsset asset, IRequestCycle cycle, String URL) {
        EasyMock.expect((Object)asset.buildURL()).andReturn((Object)URL);
    }

    protected IAsset newAsset() {
        return (IAsset)this.newMock(IAsset.class);
    }

    protected IEngine newEngine(ClassResolver resolver) {
        IEngine engine = (IEngine)this.newMock(IEngine.class);
        return engine;
    }

    protected void trainGetEngine(IPage page, IEngine engine) {
        EasyMock.expect((Object)page.getEngine()).andReturn((Object)engine);
    }

    protected IComponent newComponent() {
        return (IComponent)this.newMock(IComponent.class);
    }

    protected void trainGetPage(IComponent component, IPage page) {
        EasyMock.expect((Object)component.getPage()).andReturn((Object)page);
    }

    protected void trainGetExtendedId(IComponent component, String extendedId) {
        EasyMock.expect((Object)component.getExtendedId()).andReturn((Object)extendedId);
    }

    protected void trainGetLocation(Locatable locatable, Location location) {
        EasyMock.expect((Object)locatable.getLocation()).andReturn((Object)location);
    }

    protected IBinding newBinding() {
        return (IBinding)this.newMock(IBinding.class);
    }

    protected void trainGetComponent(IComponent container, String componentId, IComponent containee) {
        EasyMock.expect((Object)container.getComponent(componentId)).andReturn((Object)containee);
    }

    protected IEngineService newEngineService() {
        return (IEngineService)this.newMock(IEngineService.class);
    }

    protected void trainGetLink(IEngineService service, IRequestCycle cycle, boolean post, Object parameter, ILink link) {
        EasyMock.expect((Object)service.getLink(post, parameter)).andReturn((Object)link);
    }

    protected void trainGetLinkCheckIgnoreParameter(IEngineService service, IRequestCycle cycle, boolean post, Object parameter, ILink link) {
        EasyMock.expect((Object)service.getLink(EasyMock.eq((boolean)post), EasyMock.anyObject())).andReturn((Object)link);
    }

    protected void trainGetURL(ILink link, String URL) {
        EasyMock.expect((Object)link.getURL()).andReturn((Object)URL);
    }

    protected void trainGetPageRenderSupport(IRequestCycle cycle, PageRenderSupport support) {
        this.trainGetAttribute(cycle, "org.apache.tapestry.PageRenderSupport", support);
    }

    protected IComponentSpecification newSpec() {
        return (IComponentSpecification)this.newMock(IComponentSpecification.class);
    }

    protected Resource newResource() {
        return (Resource)this.newMock(Resource.class);
    }

    protected WebRequest newRequest() {
        return (WebRequest)this.newMock(WebRequest.class);
    }

    protected Location newLocation() {
        return (Location)this.newMock(Location.class);
    }

    protected Location fabricateLocation(int line) {
        Location location = this.newLocation();
        EasyMock.checkOrder((Object)location, (boolean)false);
        EasyMock.expect((Object)location.getLineNumber()).andReturn((Object)line).anyTimes();
        return location;
    }

    protected void trainEncodeURL(IRequestCycle rc, String URL, String encodedURL) {
        EasyMock.expect((Object)rc.encodeURL(URL)).andReturn((Object)encodedURL);
    }

    protected void trainGetServerPort(WebRequest request, int port) {
        EasyMock.expect((Object)request.getServerPort()).andReturn((Object)port);
    }

    protected void trainGetServerName(WebRequest request, String serverName) {
        EasyMock.expect((Object)request.getServerName()).andReturn((Object)serverName);
    }

    protected void trainGetScheme(WebRequest request, String scheme) {
        EasyMock.expect((Object)request.getScheme()).andReturn((Object)scheme);
    }

    protected NestedMarkupWriter newNestedWriter() {
        return (NestedMarkupWriter)this.newMock(NestedMarkupWriter.class);
    }

    protected void trainGetNestedWriter(IMarkupWriter writer, NestedMarkupWriter nested) {
        EasyMock.expect((Object)writer.getNestedWriter()).andReturn((Object)nested);
    }

    protected void trainGetURL(ILink link, String scheme, String anchor, String URL) {
        this.trainGetURL(link, scheme, anchor, URL, 0);
    }

    protected void trainGetURL(ILink link, String scheme, String anchor, String URL, int port) {
        EasyMock.expect((Object)link.getURL(scheme, null, port, anchor, true)).andReturn((Object)URL);
    }

    protected ILink newLink() {
        return (ILink)this.newMock(ILink.class);
    }

    protected void trainGetLink(ILinkComponent component, IRequestCycle cycle, ILink link) {
        EasyMock.expect((Object)component.getLink(cycle)).andReturn((Object)link);
    }

    protected void trainGetEngine(IRequestCycle cycle, IEngine engine) {
        EasyMock.expect((Object)cycle.getEngine()).andReturn((Object)engine);
    }

    protected void trainGetParameterValues(ILink link, String parameterName, String[] values) {
        EasyMock.expect((Object)link.getParameterValues(parameterName)).andReturn((Object)values);
    }

    protected void trainGetParameterNames(ILink link, String[] names) {
        EasyMock.expect((Object)link.getParameterNames()).andReturn((Object)names);
    }

    protected void trainGetSpecification(IComponent component, IComponentSpecification spec) {
        EasyMock.expect((Object)component.getSpecification()).andReturn((Object)spec);
    }

    protected void trainGetBinding(IComponent component, String name, IBinding binding) {
        EasyMock.expect((Object)component.getBinding(name)).andReturn((Object)binding);
    }

    protected Log newLog() {
        return (Log)this.newMock(Log.class);
    }

    protected void trainGetId(IComponent component, String id) {
        EasyMock.expect((Object)component.getId()).andReturn((Object)id);
    }

    protected void trainExtractBrowserEvent(IRequestCycle cycle) {
        EasyMock.expect((Object)cycle.getParameter("beventname")).andReturn((Object)"onClick").anyTimes();
        EasyMock.expect((Object)cycle.getParameter("beventtype")).andReturn((Object)"click");
        EasyMock.expect((Object)cycle.getParameters("beventkeys")).andReturn(null);
        EasyMock.expect((Object)cycle.getParameter("beventcharCode")).andReturn(null);
        EasyMock.expect((Object)cycle.getParameter("beventpageX")).andReturn((Object)"123");
        EasyMock.expect((Object)cycle.getParameter("beventpageY")).andReturn((Object)"1243");
        EasyMock.expect((Object)cycle.getParameter("beventlayerX")).andReturn(null);
        EasyMock.expect((Object)cycle.getParameter("beventlayerY")).andReturn(null);
        EasyMock.expect((Object)cycle.getParameter("beventtarget.id")).andReturn((Object)"element1");
    }

    protected Registry buildFrameworkRegistry(String file) throws Exception {
        return this.buildFrameworkRegistry(new String[]{file});
    }

    protected Registry buildFrameworkRegistry(String[] files) throws Exception {
        ClassResolver resolver = this.getClassResolver();
        ArrayList<Resource> descriptorResources = new ArrayList<Resource>();
        for (int i = 0; i < files.length; ++i) {
            Resource resource = this.getResource(files[i]);
            descriptorResources.add(resource);
        }
        XmlModuleDescriptorProvider provider = new XmlModuleDescriptorProvider(resolver, descriptorResources);
        return this.buildFrameworkRegistry((ModuleDescriptorProvider)provider);
    }

    protected Registry buildFrameworkRegistry(ModuleDescriptorProvider customProvider) {
        ClassResolver resolver = this.getClassResolver();
        RegistryBuilder builder = new RegistryBuilder();
        builder.addModuleDescriptorProvider((ModuleDescriptorProvider)new XmlModuleDescriptorProvider(resolver));
        builder.addModuleDescriptorProvider(customProvider);
        return builder.constructRegistry(Locale.getDefault());
    }

    protected Registry buildMinimalRegistry(Resource l) throws Exception {
        RegistryBuilder builder = new RegistryBuilder();
        return builder.constructRegistry(Locale.getDefault());
    }

    protected Resource getResource(String file) {
        URL url = ((Object)((Object)this)).getClass().getResource(file);
        if (url == null) {
            throw new NullPointerException("No resource named '" + file + "'.");
        }
        return new URLResource(url);
    }

    public static boolean assertListEquals(Object[] expected, Object[] actual) {
        if (expected == null || actual == null) {
            BaseComponentTestCase.notEquals(expected, actual);
        }
        if (!Arrays.equals(expected, actual)) {
            BaseComponentTestCase.notEquals(expected, actual);
        }
        return true;
    }

    public static boolean assertListEquals(Object[] expected, List actual) {
        if (expected == null || actual == null) {
            BaseComponentTestCase.notEquals(expected, actual);
        }
        Object[] acarr = actual.toArray(new Object[actual.size()]);
        return BaseComponentTestCase.assertListEquals(expected, acarr);
    }

    public static void notEquals(Object expected, Object actual) {
        throw new AssertionError((Object)("Parameters don't match, expected: <" + expected + "> actual: <" + actual + ">"));
    }
}

