/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.BlockingChannelConnector;
import org.mortbay.jetty.webapp.WebAppContext;

public class JettyRunner {
    public static final String DEFAULT_CONTEXT_PATH = "/";
    public static final int DEFAULT_PORT = 80;
    public static final String DEFAULT_WAR_PATH = "src/main/webapp";
    private final String _contextPath;
    private final int _port;
    private final String _warPath;
    private final Server _jetty;

    public JettyRunner() {
        this(DEFAULT_CONTEXT_PATH, 80, DEFAULT_WAR_PATH);
    }

    public JettyRunner(String contextPath, int port, String warPath) {
        this._contextPath = contextPath;
        this._port = port;
        this._warPath = warPath;
        this._jetty = new Server();
        this.startJetty();
    }

    public void stop() {
        try {
            this._jetty.stop();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error stopping Jetty instance: " + ex.toString(), ex);
        }
    }

    public String toString() {
        return String.format("<JettyRunner %s:%d (%s)>", this._contextPath, this._port, this._warPath);
    }

    private void startJetty() {
        try {
            BlockingChannelConnector connector = new BlockingChannelConnector();
            connector.setPort(this._port);
            this._jetty.setConnectors(new Connector[]{connector});
            WebAppContext context = new WebAppContext();
            context.setContextPath(this._contextPath);
            context.setWar(this._warPath);
            this._jetty.addHandler((Handler)context);
            this._jetty.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failure starting Jetty instance: " + ex.toString(), ex);
        }
    }
}

